/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.GuiElement;
import io.github.moulberry.notenoughupdates.core.util.render.RenderUtils;
import io.github.moulberry.notenoughupdates.core.util.render.TextRenderUtils;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class AuctionBINWarning
extends GuiElement {
    private static final AuctionBINWarning INSTANCE = new AuctionBINWarning();
    private static final Pattern ITEM_PRICE_REGEX = Pattern.compile("\u00a7fItem price: \u00a76([0-9,]+) coins");
    private boolean showWarning = false;
    private List<String> sellingTooltip;
    private String sellingName;
    private long sellingPrice;
    private long lowestPrice;
    private long buyPercentage;
    private int sellStackAmount;
    private boolean isALoss = true;

    public static AuctionBINWarning getInstance() {
        return INSTANCE;
    }

    private boolean shouldPerformCheck() {
        if (!NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            this.sellingTooltip = null;
            this.showWarning = false;
            return false;
        }
        if (Utils.getOpenChestName().startsWith("Create BIN Auction")) {
            return true;
        }
        this.sellingTooltip = null;
        this.showWarning = false;
        return false;
    }

    public boolean shouldShow() {
        return this.shouldPerformCheck() && this.showWarning;
    }

    @SubscribeEvent
    public void onMouseClick(SlotClickEvent event) {
        float overcutFactor;
        float undercutFactor;
        ItemStack sellStack;
        String displayName;
        Matcher priceMatcher;
        if (!this.shouldPerformCheck()) {
            return;
        }
        if (event.slotId != 29) {
            return;
        }
        this.sellingPrice = -1L;
        ItemStack priceStack = event.guiContainer.field_147002_h.func_75139_a(31).func_75211_c();
        if (priceStack != null && (priceMatcher = ITEM_PRICE_REGEX.matcher(displayName = priceStack.func_82833_r())).matches()) {
            try {
                this.sellingPrice = Long.parseLong(priceMatcher.group(1).replace(",", ""));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((sellStack = event.guiContainer.field_147002_h.func_75139_a(13).func_75211_c()) == null) {
            return;
        }
        String internalname = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(sellStack);
        this.sellStackAmount = sellStack.field_77994_a;
        if (internalname == null) {
            return;
        }
        JsonObject itemInfo = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(internalname);
        this.sellingName = itemInfo == null || !itemInfo.has("displayname") ? internalname : itemInfo.get("displayname").getAsString();
        this.sellingTooltip = sellStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, Minecraft.func_71410_x().field_71474_y.field_82882_x);
        this.lowestPrice = NotEnoughUpdates.INSTANCE.manager.auctionManager.getLowestBin(internalname);
        if (this.lowestPrice <= 0L) {
            this.lowestPrice = (int)NotEnoughUpdates.INSTANCE.manager.auctionManager.getItemAvgBin(internalname);
        }
        if ((undercutFactor = 1.0f - NotEnoughUpdates.INSTANCE.config.ahTweaks.warningThreshold / 100.0f) < 0.0f) {
            undercutFactor = 0.0f;
        }
        if (undercutFactor > 1.0f) {
            undercutFactor = 1.0f;
        }
        if ((overcutFactor = 1.0f - NotEnoughUpdates.INSTANCE.config.ahTweaks.overcutWarningThreshold / 100.0f) < 0.0f) {
            overcutFactor = 0.0f;
        }
        if (overcutFactor > 1.0f) {
            overcutFactor = 1.0f;
        }
        if (this.lowestPrice == -1L) {
            return;
        }
        if (NotEnoughUpdates.INSTANCE.config.ahTweaks.underCutWarning && this.sellingPrice > 0L && this.lowestPrice > 0L && (float)this.sellingPrice < (float)((long)this.sellStackAmount * this.lowestPrice) * undercutFactor) {
            this.showWarning = true;
            event.setCanceled(true);
        } else if (NotEnoughUpdates.INSTANCE.config.ahTweaks.overCutWarning && this.sellingPrice > 0L && this.lowestPrice > 0L && (float)this.sellingPrice > (float)((long)this.sellStackAmount * this.lowestPrice) * (overcutFactor + 1.0f)) {
            this.showWarning = true;
            event.setCanceled(true);
        }
    }

    public void overrideIsMouseOverSlot(Slot slot, int mouseX, int mouseY, CallbackInfoReturnable<Boolean> cir) {
        if (this.shouldShow()) {
            cir.setReturnValue((Object)false);
        }
    }

    @Override
    public void render() {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
        Gui.func_73734_a((int)0, (int)0, (int)width, (int)height, (int)Integer.MIN_VALUE);
        RenderUtils.drawFloatingRectDark(width / 2 - 90, height / 2 - 45, 180, 90);
        int neuLength = Minecraft.func_71410_x().field_71466_p.func_78256_a("\u00a7lNEU");
        Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a7lNEU", width / 2 + 90 - neuLength - 3, height / 2 - 45 + 4, -16777216);
        TextRenderUtils.drawStringCenteredScaledMaxWidth("Are you SURE?", width / 2, height / 2 - 45 + 10, false, 170, -49088);
        String lowestPriceStr = this.lowestPrice * (long)this.sellStackAmount > 999L ? Utils.shortNumberFormat(this.lowestPrice * (long)this.sellStackAmount, 0) : "" + this.lowestPrice * (long)this.sellStackAmount;
        String sellingPriceStr = this.sellingPrice > 999L ? Utils.shortNumberFormat(this.sellingPrice, 0) : "" + this.sellingPrice;
        String sellLine = "\u00a77[ \u00a7r" + this.sellingName + "\u00a77 ]";
        TextRenderUtils.drawStringCenteredScaledMaxWidth(sellLine, width / 2, height / 2 - 45 + 25, false, 170, -1);
        TextRenderUtils.drawStringCenteredScaledMaxWidth(this.lowestPrice > 0L ? "has a lowest BIN of \u00a76" + lowestPriceStr + "\u00a7r coins" : "\u00a7cWarning: No lowest BIN found!", width / 2, height / 2 - 45 + 34, false, 170, -6250336);
        if (this.sellingPrice > this.lowestPrice * (long)this.sellStackAmount) {
            this.buyPercentage = this.sellingPrice * 100L / (this.lowestPrice * (long)this.sellStackAmount);
            this.isALoss = false;
        } else if (this.sellingPrice < this.lowestPrice * (long)this.sellStackAmount) {
            this.buyPercentage = 100L - this.sellingPrice * 100L / (this.lowestPrice * (long)this.sellStackAmount);
            if (this.buyPercentage <= 0L) {
                this.buyPercentage = 1L;
            }
            this.isALoss = true;
        }
        TextRenderUtils.drawStringCenteredScaledMaxWidth("Continue selling it for", width / 2, height / 2 - 45 + 50, false, 170, -6250336);
        TextRenderUtils.drawStringCenteredScaledMaxWidth("\u00a76" + sellingPriceStr + "\u00a7r coins?" + (this.lowestPrice > 0L ? "(\u00a7" + (this.isALoss ? "c-" : "a+") + (this.buyPercentage >= 100L ? this.buyPercentage - 100L : this.buyPercentage) + "%\u00a7r)" : ""), width / 2, height / 2 - 45 + 59, false, 170, -6250336);
        RenderUtils.drawFloatingRectDark(width / 2 - 43, height / 2 + 23, 40, 16, false);
        RenderUtils.drawFloatingRectDark(width / 2 + 3, height / 2 + 23, 40, 16, false);
        TextRenderUtils.drawStringCenteredScaledMaxWidth(EnumChatFormatting.GREEN + "[Y]es", width / 2 - 23, height / 2 + 31, true, 36, -16711936);
        TextRenderUtils.drawStringCenteredScaledMaxWidth(EnumChatFormatting.RED + "[N]o", width / 2 + 23, height / 2 + 31, true, 36, -65536);
        if (this.sellingTooltip != null) {
            int mouseX = Mouse.getX() * width / Minecraft.func_71410_x().field_71443_c;
            int mouseY = height - Mouse.getY() * height / Minecraft.func_71410_x().field_71440_d - 1;
            int sellLineLength = Minecraft.func_71410_x().field_71466_p.func_78256_a(sellLine);
            if (mouseX >= width / 2 - sellLineLength / 2 && mouseX <= width / 2 + sellLineLength / 2 && mouseY >= height / 2 - 45 + 20 && mouseY <= height / 2 - 45 + 30) {
                Utils.drawHoveringText(this.sellingTooltip, mouseX, mouseY, width, height, -1);
            }
        }
        GlStateManager.func_179121_F();
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int width = scaledResolution.func_78326_a();
        int height = scaledResolution.func_78328_b();
        if (Mouse.getEventButtonState()) {
            if (mouseY >= height / 2 + 23 && mouseY <= height / 2 + 23 + 16) {
                if (mouseX >= width / 2 - 43 && mouseX <= width / 2 - 3) {
                    GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
                    Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, 29, 0, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                }
                this.showWarning = false;
            }
            if (mouseX < width / 2 - 90 || mouseX > width / 2 + 90 || mouseY < height / 2 - 45 || mouseY > height / 2 + 45) {
                this.showWarning = false;
            }
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        if (!Keyboard.getEventKeyState()) {
            if (Keyboard.getEventKey() == 21 || Keyboard.getEventKey() == 28) {
                GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
                Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, 29, 0, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            }
            this.showWarning = false;
        }
        return false;
    }
}

