/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.mbgui;

import io.github.moulberry.notenoughupdates.mbgui.MBAnchorPoint;
import io.github.moulberry.notenoughupdates.mbgui.MBGuiElement;
import io.github.moulberry.notenoughupdates.mbgui.MBGuiGroup;
import io.github.moulberry.notenoughupdates.miscgui.GuiItemRecipe;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class MBGuiGroupFloating
extends MBGuiGroup {
    private GuiScreen lastScreen = null;
    private final HashMap<MBGuiElement, Vector2f> childrenPositionOffset = new HashMap();
    private final LinkedHashMap<MBGuiElement, MBAnchorPoint> children;

    public MBGuiGroupFloating(int width, int height, LinkedHashMap<MBGuiElement, MBAnchorPoint> children) {
        this.width = width;
        this.height = height;
        this.children = children;
        this.recalculate();
    }

    public Map<MBGuiElement, MBAnchorPoint> getChildrenMap() {
        return Collections.unmodifiableMap(this.children);
    }

    @Override
    public Map<MBGuiElement, Vector2f> getChildrenPosition() {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen instanceof GuiContainer || currentScreen instanceof GuiItemRecipe) {
            if (this.lastScreen != currentScreen) {
                this.lastScreen = currentScreen;
                ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
                int screenWidth = scaledResolution.func_78326_a();
                int screenHeight = scaledResolution.func_78328_b();
                int xSize = -1;
                int ySize = -1;
                int guiLeft = -1;
                int guiTop = -1;
                if (currentScreen instanceof GuiContainer) {
                    GuiContainer currentContainer = (GuiContainer)currentScreen;
                    try {
                        xSize = (Integer)Utils.getField(GuiContainer.class, currentContainer, "xSize", "field_146999_f");
                        ySize = (Integer)Utils.getField(GuiContainer.class, currentContainer, "ySize", "field_147000_g");
                        guiLeft = (Integer)Utils.getField(GuiContainer.class, currentContainer, "guiLeft", "field_147003_i");
                        guiTop = (Integer)Utils.getField(GuiContainer.class, currentContainer, "guiTop", "field_147009_r");
                    }
                    catch (Exception exception) {}
                } else {
                    xSize = ((GuiItemRecipe)currentScreen).xSize;
                    ySize = ((GuiItemRecipe)currentScreen).ySize;
                    guiLeft = ((GuiItemRecipe)currentScreen).guiLeft;
                    guiTop = ((GuiItemRecipe)currentScreen).guiTop;
                }
                if (xSize <= 0 && ySize <= 0 && guiLeft <= 0 && guiTop <= 0) {
                    this.lastScreen = null;
                    return Collections.unmodifiableMap(this.childrenPosition);
                }
                for (Map.Entry<MBGuiElement, MBAnchorPoint> entry : this.children.entrySet()) {
                    MBGuiElement child = entry.getKey();
                    MBAnchorPoint anchorPoint = entry.getValue();
                    Vector2f childPos = this.childrenPosition.containsKey(child) ? new Vector2f((ReadableVector2f)this.childrenPosition.get(child)) : new Vector2f();
                    if (anchorPoint.inventoryRelative) {
                        int defGuiLeft = (screenWidth - xSize) / 2;
                        int defGuiTop = (screenHeight - ySize) / 2;
                        childPos.x += (float)(guiLeft - defGuiLeft) + (0.5f - anchorPoint.anchorPoint.x) * (float)xSize;
                        childPos.y += (float)(guiTop - defGuiTop) + (0.5f - anchorPoint.anchorPoint.y) * (float)ySize;
                    }
                    this.childrenPositionOffset.put(child, childPos);
                }
            }
            return Collections.unmodifiableMap(this.childrenPositionOffset);
        }
        return Collections.unmodifiableMap(this.childrenPosition);
    }

    @Override
    public void recalculate() {
        this.lastScreen = null;
        for (MBGuiElement mBGuiElement : this.children.keySet()) {
            mBGuiElement.recalculate();
        }
        for (Map.Entry entry : this.children.entrySet()) {
            MBGuiElement child = (MBGuiElement)entry.getKey();
            MBAnchorPoint anchorPoint = (MBAnchorPoint)entry.getValue();
            float x = anchorPoint.anchorPoint.x * (float)this.width - anchorPoint.anchorPoint.x * (float)child.getWidth() + anchorPoint.offset.x;
            float y = anchorPoint.anchorPoint.y * (float)this.height - anchorPoint.anchorPoint.y * (float)child.getHeight() + anchorPoint.offset.y;
            if (anchorPoint.inventoryRelative) {
                x = (float)this.width * 0.5f + anchorPoint.offset.x;
                y = (float)this.height * 0.5f + anchorPoint.offset.y;
            }
            this.childrenPosition.put(child, new Vector2f(x, y));
        }
    }

    @Override
    public Collection<MBGuiElement> getChildren() {
        return this.children.keySet();
    }
}

