/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.loader;

import io.github.moulberry.notenoughupdates.loader.ClassLoaderExtUtil;
import java.io.File;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.jetbrains.annotations.Nullable;

public abstract class JARLoadingTweaker
implements ITweaker {
    private List<FileSystem> toClose = new ArrayList<FileSystem>();

    protected abstract Path getFilesToLoad();

    protected abstract String getTestClass();

    @Nullable
    protected Path getShadowedElement(String path) {
        URI uri = Objects.requireNonNull(this.getClass().getResource(path)).toURI();
        if ("jar".equals(uri.getScheme())) {
            FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
            this.closeFileSystemLater(fs);
            return fs.getPath(path, new String[0]);
        }
        return Paths.get(uri);
    }

    protected void closeFileSystemLater(FileSystem fileSystem) {
        this.toClose.add(fileSystem);
    }

    public void acceptOptions(List<String> args, File gameDir, File assetsDir, String profile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performLoading(LaunchClassLoader classLoader) {
        try {
            if (Launch.blackboard.get("fml.deobfuscatedEnvironment") == Boolean.TRUE) {
                System.out.println("Skipping JAR loading in development environment.");
                return;
            }
            Path p = this.getFilesToLoad();
            System.out.println("Loading a JAR from " + p.toAbsolutePath());
            Path tempDirectory = Files.createTempDirectory("notenoughupdates-extracted-" + this.getClass().getSimpleName(), new FileAttribute[0]);
            System.out.println("Using temporary directory " + tempDirectory + " to store extracted jars.");
            tempDirectory.toFile().deleteOnExit();
            try (Stream<Path> libraries = Files.walk(p, 1, new FileVisitOption[0]);){
                libraries.filter(it -> it.getFileName().toString().toLowerCase(Locale.ROOT).endsWith(".jar")).forEach(it -> {
                    try {
                        Path extractedPath = tempDirectory.resolve(it.getFileName().toString());
                        extractedPath.toFile().deleteOnExit();
                        Files.copy(it, extractedPath, new CopyOption[0]);
                        ClassLoaderExtUtil.addClassSourceTwice(classLoader, extractedPath.toUri().toURL());
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                });
            }
            classLoader.loadClass(this.getTestClass());
            System.out.println("Could successfully load a class from loaded library.");
            return;
        }
        catch (Throwable e2) {
            System.err.println("Failed to load a JAR into NEU. This is most likely a bad thing.");
            e2.printStackTrace();
        }
        finally {
            Iterator<FileSystem> iterator = this.toClose.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                }
                try {
                    iterator.next().close();
                    continue;
                }
                catch (Throwable e3) {
                    e3.printStackTrace();
                    continue;
                }
                finally {
                    iterator.remove();
                    continue;
                }
                break;
            }
        }
    }

    public String getLaunchTarget() {
        return null;
    }

    public String[] getLaunchArguments() {
        return new String[0];
    }
}

