/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.listener;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.dungeons.DungeonWin;
import io.github.moulberry.notenoughupdates.miscfeatures.CookieWarning;
import io.github.moulberry.notenoughupdates.miscfeatures.CrystalMetalDetectorSolver;
import io.github.moulberry.notenoughupdates.miscfeatures.EnderNodes;
import io.github.moulberry.notenoughupdates.miscfeatures.StreamerMode;
import io.github.moulberry.notenoughupdates.miscfeatures.world.EnderNodeHighlighter;
import io.github.moulberry.notenoughupdates.overlays.OverlayManager;
import io.github.moulberry.notenoughupdates.overlays.SlayerOverlay;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ChatListener {
    private final NotEnoughUpdates neu;
    private static final Pattern SLAYER_EXP_PATTERN = Pattern.compile("   (Spider|Zombie|Wolf|Enderman|Blaze) Slayer LVL (\\d) - (?:Next LVL in ([\\d,]+) XP!|LVL MAXED OUT!)");
    private static final Pattern SKY_BLOCK_LEVEL_PATTERN = Pattern.compile("\\[(\\d{1,4})\\] .*");
    private final Pattern PARTY_FINDER_PATTERN = Pattern.compile("\u00a7dParty Finder \u00a7r\u00a7f> (.*)\u00a7ejoined the (dungeon )?group!");
    private AtomicBoolean missingRecipe = new AtomicBoolean(false);

    public ChatListener(NotEnoughUpdates neu) {
        this.neu = neu;
    }

    private String processText(String text) {
        if (SBInfo.getInstance().getLocation() == null) {
            return text;
        }
        if (!SBInfo.getInstance().getLocation().startsWith("mining_") && !SBInfo.getInstance().getLocation().equals("crystal_hollows")) {
            return text;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return text;
        }
        if (!NotEnoughUpdates.INSTANCE.config.mining.drillFuelBar) {
            return text;
        }
        return Utils.trimIgnoreColour(text.replaceAll(EnumChatFormatting.DARK_GREEN + "\\S+ Drill Fuel", ""));
    }

    private IChatComponent processChatComponent(IChatComponent chatComponent) {
        IChatComponent newComponent;
        if (chatComponent instanceof ChatComponentText) {
            ChatComponentText text = (ChatComponentText)chatComponent;
            newComponent = new ChatComponentText(this.processText(text.func_150261_e()));
            newComponent.func_150255_a(text.func_150256_b().func_150232_l());
            for (IChatComponent sibling : text.func_150253_a()) {
                newComponent.func_150257_a(this.processChatComponent(sibling));
            }
        } else if (chatComponent instanceof ChatComponentTranslation) {
            ChatComponentTranslation trans = (ChatComponentTranslation)chatComponent;
            Object[] args = trans.func_150271_j();
            Object[] newArgs = new Object[args.length];
            for (int i = 0; i < trans.func_150271_j().length; ++i) {
                newArgs[i] = args[i] instanceof IChatComponent ? this.processChatComponent((IChatComponent)args[i]) : args[i];
            }
            newComponent = new ChatComponentTranslation(trans.func_150268_i(), newArgs);
            for (IChatComponent sibling : trans.func_150253_a()) {
                newComponent.func_150257_a(this.processChatComponent(sibling));
            }
        } else {
            newComponent = chatComponent.func_150259_f();
        }
        return newComponent;
    }

    private IChatComponent replaceSocialControlsWithPV(IChatComponent chatComponent) {
        if (NotEnoughUpdates.INSTANCE.config.misc.replaceSocialOptions1 == 0 || !NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard()) {
            return chatComponent;
        }
        List siblings = chatComponent.func_150253_a();
        if (siblings.size() < 2) {
            return chatComponent;
        }
        IChatComponent targetedComponent = (IChatComponent)siblings.get(siblings.size() - 2);
        String chatClickCommand = this.getChatClickEvent((IChatComponent)siblings.get(0));
        if (chatClickCommand == null) {
            chatClickCommand = this.getChatClickEvent(targetedComponent);
        }
        if (chatClickCommand == null) {
            return chatComponent;
        }
        String username = chatClickCommand.equals("/viewprofile") ? Utils.getNameFromChatComponent(chatComponent) : targetedComponent.func_150256_b().func_150235_h().func_150668_b().substring(15);
        username = username.replaceAll("[^a-zA-Z0-9_]", "");
        if (NotEnoughUpdates.INSTANCE.config.misc.replaceSocialOptions1 == 1) {
            ChatStyle pvClickStyle = ChatListener.getPVChatStyle(username);
            targetedComponent.func_150255_a(pvClickStyle);
            return chatComponent;
        }
        if (NotEnoughUpdates.INSTANCE.config.misc.replaceSocialOptions1 == 2) {
            ChatStyle ahClickStyle = Utils.createClickStyle(ClickEvent.Action.RUN_COMMAND, "/ah " + username, "" + EnumChatFormatting.YELLOW + "Click to open " + EnumChatFormatting.AQUA + EnumChatFormatting.BOLD + username + EnumChatFormatting.RESET + EnumChatFormatting.YELLOW + "'s /ah page");
            targetedComponent.func_150255_a(ahClickStyle);
            return chatComponent;
        }
        return chatComponent;
    }

    private String getChatClickEvent(IChatComponent sibling) {
        if (sibling.func_150256_b() != null && sibling.func_150256_b().func_150235_h() != null) {
            String clickEvent = sibling.func_150256_b().func_150235_h().func_150668_b();
            if (clickEvent.startsWith("/socialoptions")) {
                return "/socialoptions";
            }
            if (clickEvent.startsWith("/viewprofile")) {
                return "/viewprofile";
            }
        }
        return null;
    }

    private static ChatStyle getPVChatStyle(String username) {
        username = username.replaceAll("[^a-zA-Z0-9_]", "");
        return Utils.createClickStyle(ClickEvent.Action.RUN_COMMAND, "/pv " + username, "" + EnumChatFormatting.YELLOW + "Click to open " + EnumChatFormatting.AQUA + EnumChatFormatting.BOLD + username + EnumChatFormatting.RESET + EnumChatFormatting.YELLOW + "'s profile in " + EnumChatFormatting.DARK_PURPLE + EnumChatFormatting.BOLD + "NEU's" + EnumChatFormatting.RESET + EnumChatFormatting.YELLOW + " profile viewer.");
    }

    @SubscribeEvent(priority=EventPriority.LOW, receiveCanceled=true)
    public void onGuiChat(ClientChatReceivedEvent e2) {
        Matcher LvlMatcher;
        String m2;
        String m;
        if (e2.type == 2) {
            CrystalMetalDetectorSolver.process(e2.message);
            e2.message = this.processChatComponent(e2.message);
            return;
        }
        if (e2.type == 0) {
            e2.message = this.replaceSocialControlsWithPV(e2.message);
            if (NotEnoughUpdates.INSTANCE.config.misc.dungeonGroupsPV) {
                e2.message = this.dungeonPartyJoinPV(e2.message);
            }
        }
        DungeonWin.onChatMessage(e2);
        String r = null;
        String unformatted = Utils.cleanColour(e2.message.func_150260_c());
        Matcher matcher = SLAYER_EXP_PATTERN.matcher(unformatted);
        if (unformatted.startsWith("You are playing on profile: ")) {
            SBInfo.getInstance().setCurrentProfile(unformatted.substring("You are playing on profile: ".length()).split(" ")[0].trim());
        } else if (unformatted.startsWith("Your profile was changed to: ")) {
            SBInfo.getInstance().setCurrentProfile(unformatted.substring("Your profile was changed to: ".length()).split(" ")[0].trim());
        }
        if (e2.message.func_150254_d().equals(EnumChatFormatting.RESET.toString() + EnumChatFormatting.RED + "You haven't unlocked this recipe!" + EnumChatFormatting.RESET)) {
            r = EnumChatFormatting.RED + "You haven't unlocked this recipe!";
        } else if (e2.message.func_150254_d().startsWith(EnumChatFormatting.RESET.toString() + EnumChatFormatting.RED + "Invalid recipe ")) {
            r = "";
        } else if (unformatted.equals("  SLAYER QUEST FAILED!")) {
            SlayerOverlay.isSlain = false;
            SlayerOverlay.timeSinceLastBoss = 0L;
        } else if (unformatted.equals("  NICE! SLAYER BOSS SLAIN!")) {
            SlayerOverlay.isSlain = true;
        } else if (unformatted.equals("  SLAYER QUEST STARTED!")) {
            SlayerOverlay.isSlain = false;
            if (SlayerOverlay.timeSinceLastBoss != 0L) {
                SlayerOverlay.timeSinceLastBoss2 = SlayerOverlay.timeSinceLastBoss;
            }
            SlayerOverlay.timeSinceLastBoss = System.currentTimeMillis();
        } else if (unformatted.startsWith("   RNG Meter")) {
            SlayerOverlay.RNGMeter = unformatted.substring("   RNG Meter - ".length());
        } else if (matcher.matches()) {
            SlayerOverlay.slayerLVL = matcher.group(2);
            SlayerOverlay.slayerXp = !SlayerOverlay.slayerLVL.equals("9") ? matcher.group(3) : "maxed";
        } else if (unformatted.startsWith("Sending to server") || unformatted.startsWith("Your Slayer Quest has been cancelled!")) {
            SlayerOverlay.slayerQuest = false;
            SlayerOverlay.unloadOverlayTimer = System.currentTimeMillis();
        } else if (unformatted.startsWith("You consumed a Booster Cookie!")) {
            CookieWarning.resetNotification();
        } else if (unformatted.startsWith("QUICK MATHS! Solve:") && NotEnoughUpdates.INSTANCE.hasSkyblockScoreboard() && Math.random() < 0.2 && NotEnoughUpdates.INSTANCE.config.misc.calculationMode == 2) {
            ClientCommandHandler.instance.func_71556_a((ICommandSender)Minecraft.func_71410_x().field_71439_g, "/neucalc " + unformatted.substring("QUICK MATHS! Solve: ".length()));
        }
        if (r != null) {
            if (this.neu.manager.failViewItem(r)) {
                e2.setCanceled(true);
            }
            this.missingRecipe.set(true);
        }
        if (unformatted.startsWith("Sending to server") && NotEnoughUpdates.INSTANCE.config.misc.streamerMode && e2.message instanceof ChatComponentText && !(m = e2.message.func_150254_d()).equals(m2 = StreamerMode.filterChat(e2.message.func_150254_d()))) {
            e2.message = new ChatComponentText(m2);
        }
        if (unformatted.startsWith("You found ") && SBInfo.getInstance().getLocation() != null && SBInfo.getInstance().getLocation().equals("crystal_hollows")) {
            CrystalMetalDetectorSolver.resetSolution(true);
        }
        if (unformatted.startsWith("[NPC] Keeper of ") | unformatted.startsWith("[NPC] Professor Robot: ") || unformatted.startsWith("  ") || unformatted.startsWith("\u2726") || unformatted.equals("  You've earned a Crystal Loot Bundle!")) {
            OverlayManager.crystalHollowOverlay.message(unformatted);
        }
        if ((LvlMatcher = SKY_BLOCK_LEVEL_PATTERN.matcher(unformatted)).matches() && Integer.parseInt(LvlMatcher.group(1)) < NotEnoughUpdates.INSTANCE.config.misc.filterChatLevel && NotEnoughUpdates.INSTANCE.config.misc.filterChatLevel != 0 && !unformatted.contains(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            e2.setCanceled(true);
        }
        OverlayManager.powderGrindingOverlay.onMessage(unformatted);
        if (unformatted.startsWith("ENDER NODE!")) {
            EnderNodeHighlighter.getInstance().highlightedBlocks.clear();
        }
        if (unformatted.equals("ENDER NODE! You found Endermite Nest!")) {
            EnderNodes.displayEndermiteNotif();
        }
    }

    private IChatComponent dungeonPartyJoinPV(IChatComponent message) {
        String text = message.func_150254_d();
        Matcher matcher = this.PARTY_FINDER_PATTERN.matcher(text);
        if (matcher.find()) {
            String name = StringUtils.func_76338_a((String)matcher.group(1)).trim();
            ChatComponentText componentText = new ChatComponentText(text);
            componentText.func_150255_a(ChatListener.getPVChatStyle(name));
            return componentText;
        }
        return message;
    }
}

