/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.moe.nea.lisp;

import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispParsingError;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispPosition;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.StringRacer;
import java.util.Stack;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\nJ\u001a\u0010\u0015\u001a\u00020\u00032\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00180\u0017J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010 \u001a\u00020\u0018J\u000e\u0010!\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\nJ\u0010\u0010\"\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\nJ\u0006\u0010#\u001a\u00020\u001aJ\u0006\u0010$\u001a\u00020\u001aJ\u0006\u0010%\u001a\u00020\u001aJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\nJ\u000e\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/StringRacer;", "", "filename", "", "backing", "(Ljava/lang/String;Ljava/lang/String;)V", "getBacking", "()Ljava/lang/String;", "getFilename", "idx", "", "getIdx", "()I", "setIdx", "(I)V", "stack", "Ljava/util/Stack;", "getStack", "()Ljava/util/Stack;", "consumeCountReq", "count", "consumeWhile", "shouldConsumeThisString", "Lkotlin/Function1;", "", "discardState", "", "error", "", "errorMessage", "expect", "search", "finished", "peek", "peekReq", "popState", "pushState", "skipWhitespace", "span", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispPosition;", "start", "tryConsume", "string", "nealisp"})
public final class StringRacer {
    @NotNull
    private final String filename;
    @NotNull
    private final String backing;
    private int idx;
    @NotNull
    private final Stack<Integer> stack;

    public StringRacer(@NotNull String filename, @NotNull String backing) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter((Object)backing, (String)"backing");
        this.filename = filename;
        this.backing = backing;
        this.stack = new Stack();
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    @NotNull
    public final String getBacking() {
        return this.backing;
    }

    public final int getIdx() {
        return this.idx;
    }

    public final void setIdx(int n) {
        this.idx = n;
    }

    @NotNull
    public final Stack<Integer> getStack() {
        return this.stack;
    }

    public final void pushState() {
        this.stack.push(this.idx);
    }

    public final void popState() {
        Integer n = this.stack.pop();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"stack.pop()");
        this.idx = ((Number)n).intValue();
    }

    @NotNull
    public final LispPosition span(int start) {
        return new LispPosition(start, this.idx, this.filename, this.backing);
    }

    public final void discardState() {
        this.stack.pop();
    }

    @NotNull
    public final String peek(int count) {
        String string = this.backing.substring(Math.min(this.idx, this.backing.length()), Math.min(this.idx + count, this.backing.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        return string;
    }

    public final boolean finished() {
        return ((CharSequence)this.peek(1)).length() == 0;
    }

    @Nullable
    public final String peekReq(int count) {
        String p = this.peek(count);
        if (p.length() != count) {
            return null;
        }
        return p;
    }

    @Nullable
    public final String consumeCountReq(int count) {
        String p = this.peekReq(count);
        if (p != null) {
            this.idx += count;
        }
        return p;
    }

    public final boolean tryConsume(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        String p = this.peek(string.length());
        if (!Intrinsics.areEqual((Object)p, (Object)string)) {
            return false;
        }
        this.idx += p.length();
        return true;
    }

    @NotNull
    public final String consumeWhile(@NotNull Function1<? super String, Boolean> shouldConsumeThisString) {
        String nextString;
        String nextPart;
        Intrinsics.checkNotNullParameter(shouldConsumeThisString, (String)"shouldConsumeThisString");
        String lastString = "";
        while (!(((CharSequence)(nextPart = this.peek(1))).length() == 0) && ((Boolean)shouldConsumeThisString.invoke((Object)(nextString = lastString + nextPart))).booleanValue()) {
            int n = this.idx;
            this.idx = n + 1;
            lastString = nextString;
        }
        return lastString;
    }

    public final void expect(@NotNull String search, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)search, (String)"search");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (!this.tryConsume(search)) {
            this.error(errorMessage);
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public final Void error(@NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        throw new LispParsingError(this.backing, this.idx, errorMessage);
    }

    public final void skipWhitespace() {
        this.consumeWhile((Function1<? super String, Boolean>)((Function1)skipWhitespace.1.INSTANCE));
    }
}

