/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.moe.nea.lisp;

import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispAst;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispData;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispExecutionContext;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispParser;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispScriptEngineFactory;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.StackFrame;
import java.io.Reader;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.SimpleBindings;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispScriptEngine;", "Ljavax/script/AbstractScriptEngine;", "factory", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispScriptEngineFactory;", "(Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispScriptEngineFactory;)V", "executionContext", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispExecutionContext;", "getExecutionContext", "()Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispExecutionContext;", "createBindings", "Ljavax/script/Bindings;", "eval", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispData;", "reader", "Ljava/io/Reader;", "context", "Ljavax/script/ScriptContext;", "script", "", "getFactory", "nealisp"})
public final class LispScriptEngine
extends AbstractScriptEngine {
    @NotNull
    private final LispScriptEngineFactory factory;
    @NotNull
    private final LispExecutionContext executionContext;

    public LispScriptEngine(@NotNull LispScriptEngineFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factory = factory;
        this.executionContext = new LispExecutionContext();
        this.executionContext.setupStandardBindings();
    }

    @NotNull
    public final LispExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    @Nullable
    public LispData eval(@NotNull String script, @NotNull ScriptContext context) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getAttribute("scriptName");
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            string = "script.lisp";
        }
        String fileName = string;
        LispAst.Program program = LispParser.Companion.parse(fileName, script);
        StackFrame root = this.executionContext.genBindings();
        Bindings bindings = context.getBindings(100);
        Intrinsics.checkNotNullExpressionValue((Object)bindings, (String)"context.getBindings(ScriptContext.ENGINE_SCOPE)");
        for (Map.Entry entry : ((Map)bindings).entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            Object v = value;
            if (v instanceof String) {
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                Intrinsics.checkNotNullExpressionValue(value, (String)"value");
                root.setValueLocal(name, new LispData.LispString((String)value));
                continue;
            }
            if (v instanceof Number) {
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                root.setValueLocal(name, new LispData.LispNumber(((Number)value).doubleValue()));
                continue;
            }
            if (v instanceof Boolean) {
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                Intrinsics.checkNotNullExpressionValue(value, (String)"value");
                root.setValueLocal(name, new LispData.LispNumber((Boolean)value != false ? 1.0 : 0.0));
                continue;
            }
            if (v == null) {
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                root.setValueLocal(name, LispData.LispNil.INSTANCE);
                continue;
            }
            throw new IllegalStateException(("Could not convert " + value + " to lisp value").toString());
        }
        return this.executionContext.executeProgram(root, program);
    }

    @Override
    @Nullable
    public LispData eval(@NotNull Reader reader, @NotNull ScriptContext context) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.eval(TextStreamsKt.readText((Reader)reader), context);
    }

    @Override
    @NotNull
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    @NotNull
    public LispScriptEngineFactory getFactory() {
        return this.factory;
    }
}

