/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.xml;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.TypeUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.observer.GetSetter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class XMLBoundProperties {
    final Map<String, Field> namedProperties = new HashMap<String, Field>();
    final Map<String, Method> namedFunctions = new HashMap<String, Method>();
    private static MethodHandles.Lookup lookup = MethodHandles.lookup();

    public <T> Consumer<T> getBoundFunction(String name, Object object, Class<T> tClass) {
        Method method = this.namedFunctions.get(name);
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("Return type of bound method " + name + " must be void on object " + object);
        }
        if (method.getParameterCount() != 1) {
            throw new IllegalArgumentException("Bound method " + name + " should only take one argument on object " + object);
        }
        if (!TypeUtils.doesAExtendB(tClass, method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Bound method " + name + " should take one argument of type " + tClass + " instead of " + method.getParameterTypes()[0]);
        }
        final MethodHandle methodHandle = lookup.unreflect(method).bindTo(object);
        return new Consumer<T>(){

            @Override
            public void accept(T t) {
                methodHandle.invoke(t);
            }
        };
    }

    public Runnable getBoundFunction(String name, Object object) {
        Method method = this.namedFunctions.get(name);
        if (method.getReturnType() != Void.TYPE) {
            throw new IllegalArgumentException("Return type of bound method " + name + " must be void on object " + object);
        }
        if (method.getParameterCount() != 0) {
            throw new IllegalArgumentException("Bound method " + name + " should only take one argument on object " + object);
        }
        final MethodHandle methodHandle = lookup.unreflect(method).bindTo(object);
        return new Runnable(){

            @Override
            public void run() {
                methodHandle.invoke();
            }
        };
    }

    public <T> GetSetter<T> getBoundProperty(String name, Class<T> clazz, final Object object) {
        if (name.equals("this")) {
            if (!TypeUtils.doesAExtendB(object.getClass(), clazz)) {
                throw new IllegalArgumentException("Bind target " + name + " is of the wrong type " + object.getClass() + " instead of " + clazz);
            }
            return new GetSetter<T>(){

                @Override
                public T get() {
                    return object;
                }

                @Override
                public void set(T newValue) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        Field field = this.namedProperties.get(name);
        if (field == null) {
            Method method = this.namedFunctions.get(name);
            if (method == null) {
                throw new NullPointerException("Could not find bind target for " + name + " in " + clazz);
            }
            if (!TypeUtils.doesAExtendB(method.getReturnType(), clazz)) {
                throw new IllegalArgumentException("Bind target " + method + " is of the wrong type " + method.getReturnType() + " instead of " + clazz);
            }
            if (method.getParameterCount() != 0) {
                throw new RuntimeException("Bind target " + method + " is not a pure getter");
            }
            final MethodHandle unreflect = lookup.unreflect(method).bindTo(object);
            return new GetSetter<T>(){

                @Override
                public T get() {
                    return unreflect.invoke();
                }

                @Override
                public void set(T newValue) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (!TypeUtils.doesAExtendB(field.getType(), clazz)) {
            throw new IllegalArgumentException("Bind target " + name + " is of the wrong type " + field.getType() + " instead of " + clazz);
        }
        field.setAccessible(true);
        final MethodHandle getter = lookup.unreflectGetter(field).bindTo(object);
        final MethodHandle setter = lookup.unreflectSetter(field).bindTo(object);
        return new GetSetter<T>(){

            @Override
            public T get() {
                return getter.invoke();
            }

            @Override
            public void set(T newValue) {
                setter.invoke(newValue);
            }
        };
    }

    public Map<String, Field> getNamedProperties() {
        return this.namedProperties;
    }

    public Map<String, Method> getNamedFunctions() {
        return this.namedFunctions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XMLBoundProperties)) {
            return false;
        }
        XMLBoundProperties other = (XMLBoundProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Field> this$namedProperties = this.getNamedProperties();
        Map<String, Field> other$namedProperties = other.getNamedProperties();
        if (this$namedProperties == null ? other$namedProperties != null : !((Object)this$namedProperties).equals(other$namedProperties)) {
            return false;
        }
        Map<String, Method> this$namedFunctions = this.getNamedFunctions();
        Map<String, Method> other$namedFunctions = other.getNamedFunctions();
        return !(this$namedFunctions == null ? other$namedFunctions != null : !((Object)this$namedFunctions).equals(other$namedFunctions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XMLBoundProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        Map<String, Field> $namedProperties = this.getNamedProperties();
        result2 = result2 * 59 + ($namedProperties == null ? 43 : ((Object)$namedProperties).hashCode());
        Map<String, Method> $namedFunctions = this.getNamedFunctions();
        result2 = result2 * 59 + ($namedFunctions == null ? 43 : ((Object)$namedFunctions).hashCode());
        return result2;
    }

    public String toString() {
        return "XMLBoundProperties(namedProperties=" + this.getNamedProperties() + ", namedFunctions=" + this.getNamedFunctions() + ")";
    }
}

