/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.elements;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.GuiTextures;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IMinecraft;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiElement;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.RenderUtils;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class GuiElementSlider
extends GuiElement {
    private static final int HEIGHT = 16;
    private final float minValue;
    private final float maxValue;
    private final float minStep;
    private float value;
    private final Consumer<Float> setCallback;
    public int x;
    public int y;
    public int width;
    private boolean clicked = false;

    public GuiElementSlider(int x, int y, int width, float minValue, float maxValue, float minStep, float value, Consumer<Float> setCallback) {
        if (minStep < 0.0f) {
            minStep = 0.01f;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.minStep = minStep;
        this.value = value;
        this.setCallback = setCallback;
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public void render() {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int mouseX = Mouse.getX() * scaledResolution.func_78326_a() / Minecraft.func_71410_x().field_71443_c;
        float value = this.value;
        if (this.clicked) {
            value = (float)(mouseX - this.x) * (this.maxValue - this.minValue) / (float)this.width + this.minValue;
            value = Math.max(this.minValue, Math.min(this.maxValue, value));
            value = (float)Math.round(value / this.minStep) * this.minStep;
        }
        float sliderAmount = Math.max(0.0f, Math.min(1.0f, (value - this.minValue) / (this.maxValue - this.minValue)));
        int sliderAmountI = (int)((float)this.width * sliderAmount);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IMinecraft.instance.bindTexture(GuiTextures.SLIDER_ON_CAP);
        RenderUtils.drawTexturedRect(this.x, this.y, 4.0f, 16.0f, 9728);
        IMinecraft.instance.bindTexture(GuiTextures.SLIDER_OFF_CAP);
        RenderUtils.drawTexturedRect(this.x + this.width - 4, this.y, 4.0f, 16.0f, 9728);
        if (sliderAmountI > 5) {
            IMinecraft.instance.bindTexture(GuiTextures.SLIDER_ON_SEGMENT);
            RenderUtils.drawTexturedRect(this.x + 4, this.y, sliderAmountI - 4, 16.0f, 9728);
        }
        if (sliderAmountI < this.width - 5) {
            IMinecraft.instance.bindTexture(GuiTextures.SLIDER_OFF_SEGMENT);
            RenderUtils.drawTexturedRect(this.x + sliderAmountI, this.y, this.width - 4 - sliderAmountI, 16.0f, 9728);
        }
        for (int i = 1; i < 4; ++i) {
            int notchX = this.x + this.width * i / 4 - 1;
            IMinecraft.instance.bindTexture(notchX > this.x + sliderAmountI ? GuiTextures.SLIDER_OFF_NOTCH : GuiTextures.SLIDER_ON_NOTCH);
            RenderUtils.drawTexturedRect(notchX, this.y + 6, 2.0f, 4.0f, 9728);
        }
        IMinecraft.instance.bindTexture(GuiTextures.SLIDER_BUTTON);
        RenderUtils.drawTexturedRect(this.x + sliderAmountI - 4, this.y, 8.0f, 16.0f, 9728);
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY) {
        if (!Mouse.isButtonDown((int)0)) {
            this.clicked = false;
        }
        if (Mouse.getEventButton() == 0) {
            boolean bl = this.clicked = Mouse.getEventButtonState() && mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + 16;
            if (this.clicked) {
                float value = (float)(mouseX - this.x) * (this.maxValue - this.minValue) / (float)this.width + this.minValue;
                value = Math.max(this.minValue, Math.min(this.maxValue, value));
                value = (float)((double)Math.round(value / this.minStep) * (double)this.minStep);
                this.setCallback.accept(Float.valueOf(value));
                return true;
            }
        }
        if (!Mouse.getEventButtonState() && Mouse.getEventButton() == -1 && this.clicked) {
            float value = (float)(mouseX - this.x) * (this.maxValue - this.minValue) / (float)this.width + this.minValue;
            value = Math.max(this.minValue, Math.min(this.maxValue, value));
            value = (float)Math.round(value / this.minStep) * this.minStep;
            this.setCallback.accept(Float.valueOf(value));
            return true;
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        return false;
    }
}

