/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core.util;

import io.github.moulberry.notenoughupdates.core.GuiElement;
import io.github.moulberry.notenoughupdates.util.GuiTextures;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.input.Mouse;

public class GuiElementSlider
extends GuiElement {
    public int x;
    public int y;
    public int width;
    private static final int HEIGHT = 16;
    private final float minValue;
    private final float maxValue;
    private final float minStep;
    private float value;
    private final Consumer<Float> setCallback;
    private boolean clicked = false;

    public GuiElementSlider(int x, int y, int width, float minValue, float maxValue, float minStep, float value, Consumer<Float> setCallback) {
        if (minStep < 0.0f) {
            minStep = 0.01f;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.minStep = minStep;
        this.value = value;
        this.setCallback = setCallback;
    }

    public void setValue(float value) {
        this.value = value;
    }

    @Override
    public void render() {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int mouseX = Mouse.getX() * scaledResolution.func_78326_a() / Minecraft.func_71410_x().field_71443_c;
        float value = this.value;
        if (this.clicked) {
            value = (float)(mouseX - this.x) * (this.maxValue - this.minValue) / (float)this.width + this.minValue;
            value = Math.max(this.minValue, Math.min(this.maxValue, value));
            value = (float)Math.round(value / this.minStep) * this.minStep;
        }
        float sliderAmount = Math.max(0.0f, Math.min(1.0f, (value - this.minValue) / (this.maxValue - this.minValue)));
        int sliderAmountI = (int)((float)this.width * sliderAmount);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.slider_on_cap);
        Utils.drawTexturedRect(this.x, this.y, 4.0f, 16.0f, 9728);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.slider_off_cap);
        Utils.drawTexturedRect(this.x + this.width - 4, this.y, 4.0f, 16.0f, 9728);
        if (sliderAmountI > 5) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.slider_on_segment);
            Utils.drawTexturedRect(this.x + 4, this.y, sliderAmountI - 4, 16.0f, 9728);
        }
        if (sliderAmountI < this.width - 5) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.slider_off_segment);
            Utils.drawTexturedRect(this.x + sliderAmountI, this.y, this.width - 4 - sliderAmountI, 16.0f, 9728);
        }
        for (int i = 1; i < 4; ++i) {
            int notchX = this.x + this.width * i / 4 - 1;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(notchX > this.x + sliderAmountI ? GuiTextures.slider_off_notch : GuiTextures.slider_on_notch);
            Utils.drawTexturedRect(notchX, this.y + 6, 2.0f, 4.0f, 9728);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(GuiTextures.slider_button_new);
        Utils.drawTexturedRect(this.x + sliderAmountI - 4, this.y, 8.0f, 16.0f, 9728);
    }

    @Override
    public boolean mouseInput(int mouseX, int mouseY) {
        if (!Mouse.isButtonDown((int)0)) {
            this.clicked = false;
        }
        if (Mouse.getEventButton() == 0) {
            boolean bl = this.clicked = Mouse.getEventButtonState() && mouseX > this.x && mouseX < this.x + this.width && mouseY > this.y && mouseY < this.y + 16;
            if (this.clicked) {
                this.value = (float)(mouseX - this.x) * (this.maxValue - this.minValue) / (float)this.width + this.minValue;
                this.value = Math.max(this.minValue, Math.min(this.maxValue, this.value));
                this.value = (float)((double)Math.round(this.value / this.minStep) * (double)this.minStep);
                this.setCallback.accept(Float.valueOf(this.value));
                return true;
            }
        }
        if (!Mouse.getEventButtonState() && Mouse.getEventButton() == -1 && this.clicked) {
            this.value = (float)(mouseX - this.x) * (this.maxValue - this.minValue) / (float)this.width + this.minValue;
            this.value = Math.max(this.minValue, Math.min(this.maxValue, this.value));
            this.value = (float)Math.round(this.value / this.minStep) * this.minStep;
            this.setCallback.accept(Float.valueOf(this.value));
            return true;
        }
        return false;
    }

    @Override
    public boolean keyboardInput() {
        return false;
    }
}

