/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import io.github.moulberry.notenoughupdates.ItemPriceInformation;
import io.github.moulberry.notenoughupdates.NEUManager;
import io.github.moulberry.notenoughupdates.NEUOverlay;
import io.github.moulberry.notenoughupdates.NEURepoResourcePack;
import io.github.moulberry.notenoughupdates.autosubscribe.AutoLoad;
import io.github.moulberry.notenoughupdates.core.BackgroundBlur;
import io.github.moulberry.notenoughupdates.core.config.ConfigUtil;
import io.github.moulberry.notenoughupdates.cosmetics.ShaderManager;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.observer.PropertyTypeAdapterFactory;
import io.github.moulberry.notenoughupdates.listener.ChatListener;
import io.github.moulberry.notenoughupdates.listener.ItemTooltipEssenceShopListener;
import io.github.moulberry.notenoughupdates.listener.ItemTooltipListener;
import io.github.moulberry.notenoughupdates.listener.ItemTooltipRngListener;
import io.github.moulberry.notenoughupdates.listener.NEUEventListener;
import io.github.moulberry.notenoughupdates.listener.RenderListener;
import io.github.moulberry.notenoughupdates.listener.WorldListener;
import io.github.moulberry.notenoughupdates.miscfeatures.CustomSkulls;
import io.github.moulberry.notenoughupdates.miscfeatures.FairySouls;
import io.github.moulberry.notenoughupdates.miscfeatures.NPCRetexturing;
import io.github.moulberry.notenoughupdates.miscfeatures.Navigation;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.miscfeatures.SlotLocking;
import io.github.moulberry.notenoughupdates.miscfeatures.StorageManager;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.CustomBlockSounds;
import io.github.moulberry.notenoughupdates.miscfeatures.inventory.MuseumCheapestItemOverlay;
import io.github.moulberry.notenoughupdates.miscfeatures.inventory.MuseumItemHighlighter;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizeManager;
import io.github.moulberry.notenoughupdates.mixins.AccessorMinecraft;
import io.github.moulberry.notenoughupdates.oneconfig.IOneConfigCompat;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.overlays.OverlayManager;
import io.github.moulberry.notenoughupdates.profileviewer.ProfileViewer;
import io.github.moulberry.notenoughupdates.recipes.RecipeGenerator;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.brigadier.BrigadierRoot;
import io.github.moulberry.notenoughupdates.util.hypixelapi.HypixelItemAPI;
import io.github.moulberry.notenoughupdates.util.kotlin.KotlinTypeAdapterFactory;
import java.awt.Color;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenHell;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraft.world.biome.BiomeGenSnow;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="notenoughupdates", version="2.4.0", clientSideOnly=true, useMetadata=true, guiFactory="io.github.moulberry.notenoughupdates.core.config.MoulConfigGuiForgeInterop")
public class NotEnoughUpdates {
    public static final String MODID = "notenoughupdates";
    public static final String VERSION = "2.4.0";
    private static final Pattern versionPattern = Pattern.compile("([0-9]+)\\.([0-9]+)\\.([0-9]+)");
    public static final int VERSION_ID = NotEnoughUpdates.parseVersion("2.4.0");
    public static final Logger LOGGER = LogManager.getLogger((String)"NotEnoughUpdates");
    public static final BiomeGenBase crystalHollowsJungle = new BiomeGenJungle(101, true).func_76739_b(5470985).func_76735_a("NeuCrystalHollowsJungle").func_76733_a(5470985).func_76732_a(0.95f, 0.9f);
    public static final BiomeGenBase crystalHollowsMagmaFields = new BiomeGenHell(102).func_76739_b(0xFF0000).func_76735_a("NeuCrystalHollowsMagmaFields").func_76745_m().func_76732_a(2.0f, 0.0f);
    public static final BiomeGenBase crystalHollowsGoblinHoldout = new BiomeGenMesa(103, false, false).func_76739_b(13274213).func_76735_a("NeuCrystalHollowsGoblinHoldout");
    public static final BiomeGenBase crystalHollowsPrecursorRemnants = new BiomeGenMesa(104, false, true).func_76739_b(11573093).func_76735_a("NeuCrystalHollowsPrecursorRemnants");
    public static final BiomeGenBase crystalHollowsMithrilDeposit = new BiomeGenSnow(105, false).func_76739_b(0xFFFFFF).func_76735_a("NeuCrystalHollowsMithrilDeposits");
    public static final BiomeGenBase crystalHollowsCrystalNucleus = new BiomeGenJungle(106, true).func_76739_b(5470985).func_76735_a("NeuCrystalHollowsCrystalNucleus").func_76733_a(5470985).func_76732_a(0.95f, 0.9f);
    public static final BiomeGenBase smolderingTomb = new BiomeGenHell(107).func_76739_b(0xFFFFFF).func_76735_a("NeuSmolderingTomb");
    public static final BiomeGenBase glaciteMineshaft = new BiomeGenSnow(108, false).func_76739_b(0xFFFFFF).func_76735_a("NeuGlaciteMineshaft");
    public static final BiomeGenBase glaciteTunnels = new BiomeGenSnow(109, false).func_76739_b(0xFFFFFF).func_76735_a("NeuGlaciteTunnels");
    private static final long CHAT_MSG_COOLDOWN = 200L;
    private static final Set<String> SKYBLOCK_IN_ALL_LANGUAGES = Sets.newHashSet((Object[])new String[]{"SKYBLOCK", "\u7a7a\u5c9b\u751f\u5b58", "\u7a7a\u5cf6\u751f\u5b58", "SKIBLOCK"});
    public static NotEnoughUpdates INSTANCE = null;
    public static HashMap<String, String> petRarityToColourMap = new HashMap<String, String>(){
        {
            this.put("UNKNOWN", EnumChatFormatting.RED.toString());
            this.put("COMMON", EnumChatFormatting.WHITE.toString());
            this.put("UNCOMMON", EnumChatFormatting.GREEN.toString());
            this.put("RARE", EnumChatFormatting.BLUE.toString());
            this.put("EPIC", EnumChatFormatting.DARK_PURPLE.toString());
            this.put("LEGENDARY", EnumChatFormatting.GOLD.toString());
            this.put("MYTHIC", EnumChatFormatting.LIGHT_PURPLE.toString());
        }
    };
    public static ProfileViewer profileViewer;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().registerTypeAdapterFactory(new PropertyTypeAdapterFactory()).registerTypeAdapterFactory(KotlinTypeAdapterFactory.INSTANCE).create();
    public NEUManager manager;
    public NEUOverlay overlay;
    public NEUConfig config;
    public Navigation navigation = new Navigation(this);
    public GuiScreen openGui = null;
    public long lastOpenedGui = 0L;
    public boolean packDevEnabled = false;
    public Color[][] colourMap = null;
    private File configFile;
    private long lastChatMessage = 0L;
    private long secondLastChatMessage = 0L;
    private String currChatMessage = null;
    private File neuDir;
    private boolean hasSkyblockScoreboard;

    private static int parseVersion(String versionName) {
        Matcher matcher = versionPattern.matcher(versionName);
        if (!matcher.matches()) {
            return 0;
        }
        int major = Integer.parseInt(matcher.group(1));
        if (major < 0 || major > 99) {
            return 0;
        }
        int minor = Integer.parseInt(matcher.group(2));
        if (minor < 0 || minor > 99) {
            return 0;
        }
        int patch = Integer.parseInt(matcher.group(3));
        if (patch < 0 || patch > 99) {
            return 0;
        }
        return major * 10000 + minor * 100 + patch;
    }

    public NotEnoughUpdates() {
        ((AccessorMinecraft)FMLClientHandler.instance().getClient()).onGetDefaultResourcePacks().add(new NEURepoResourcePack(null, "neurepo"));
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void newConfigFile() {
        this.configFile = new File(INSTANCE.getNeuDir(), "configNew.json");
    }

    public File getNeuDir() {
        return this.neuDir;
    }

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        INSTANCE = this;
        this.neuDir = new File(event.getModConfigurationDirectory(), MODID);
        this.neuDir.mkdirs();
        this.configFile = new File(this.neuDir, "configNew.json");
        if (this.configFile.exists()) {
            this.config = ConfigUtil.loadConfig(NEUConfig.class, this.configFile, this.gson);
        }
        ItemCustomizeManager.loadCustomization(new File(this.neuDir, "itemCustomization.json"));
        StorageManager.getInstance().loadConfig(new File(this.neuDir, "storageItems.json"));
        FairySouls.getInstance().loadFoundSoulsForAllProfiles(new File(this.neuDir, "collected_fairy_souls.json"), this.gson);
        PetInfoOverlay.loadConfig(new File(this.neuDir, "petCache.json"));
        SlotLocking.getInstance().loadConfig(new File(this.neuDir, "slotLocking.json"));
        ItemPriceInformation.init(new File(this.neuDir, "auctionable_items.json"), this.gson);
        if (this.config == null) {
            this.config = new NEUConfig();
            this.saveConfig();
        } else {
            if (this.config.profileViewer.pageLayout.size() == 8) {
                this.config.profileViewer.pageLayout.add(8);
            }
            if (this.config.profileViewer.pageLayout.size() == 9) {
                this.config.profileViewer.pageLayout.add(9);
            }
            if (this.config.profileViewer.pageLayout.size() == 10) {
                this.config.profileViewer.pageLayout.add(10);
            }
            if (this.config.profileViewer.pageLayout.size() == 11) {
                this.config.profileViewer.pageLayout.add(11);
            }
            if (this.config.profileViewer.pageLayout.size() == 12) {
                this.config.profileViewer.pageLayout.add(12);
            }
            if (this.config.profileViewer.pageLayout.size() == 13) {
                this.config.profileViewer.pageLayout.add(13);
            }
            if ((this.config.apiData.repoUser.isEmpty() || this.config.apiData.repoName.isEmpty() || this.config.apiData.repoBranch.isEmpty()) && this.config.apiData.autoupdate_new) {
                this.config.apiData.repoUser = "NotEnoughUpdates";
                this.config.apiData.repoName = "NotEnoughUpdates-REPO";
                this.config.apiData.repoBranch = "master";
            }
            if ("prerelease".equals(this.config.apiData.repoBranch)) {
                this.config.apiData.repoBranch = "master";
            }
            if (this.config.apiData.moulberryCodesApi.isEmpty()) {
                this.config.apiData.moulberryCodesApi = "moulberry.codes";
            }
            if (this.config.ahGraph.serverUrl.trim().isEmpty()) {
                this.config.ahGraph.serverUrl = "pricehistory.notenoughupdates.org";
            }
            this.saveConfig();
        }
        if (this.config != null && this.config.mining.powderGrindingTrackerResetMode == 2) {
            OverlayManager.powderGrindingOverlay.load();
        }
        IOneConfigCompat.getInstance().ifPresent(it -> it.initConfig(this.config));
        MinecraftForge.EVENT_BUS.register((Object)new NEUEventListener(this));
        MinecraftForge.EVENT_BUS.register((Object)new RecipeGenerator(this));
        MinecraftForge.EVENT_BUS.register((Object)OverlayManager.petInfoOverlay);
        MinecraftForge.EVENT_BUS.register((Object)OverlayManager.timersOverlay);
        MinecraftForge.EVENT_BUS.register((Object)new ChatListener(this));
        MinecraftForge.EVENT_BUS.register((Object)new ItemTooltipListener(this));
        MinecraftForge.EVENT_BUS.register((Object)new ItemTooltipRngListener(this));
        MinecraftForge.EVENT_BUS.register((Object)new ItemTooltipEssenceShopListener(this));
        MinecraftForge.EVENT_BUS.register((Object)new RenderListener(this));
        MinecraftForge.EVENT_BUS.register((Object)this.navigation);
        MinecraftForge.EVENT_BUS.register((Object)new WorldListener(this));
        AutoLoad.INSTANCE.provide(supplier -> MinecraftForge.EVENT_BUS.register(supplier.get()));
        MinecraftForge.EVENT_BUS.register((Object)MuseumItemHighlighter.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)MuseumCheapestItemOverlay.INSTANCE);
        if (Minecraft.func_71410_x().func_110442_L() instanceof IReloadableResourceManager) {
            IReloadableResourceManager manager = (IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
            manager.func_110542_a((IResourceManagerReloadListener)CustomSkulls.getInstance());
            manager.func_110542_a((IResourceManagerReloadListener)NPCRetexturing.getInstance());
            manager.func_110542_a((IResourceManagerReloadListener)ShaderManager.getInstance());
            manager.func_110542_a((IResourceManagerReloadListener)new ItemCustomizeManager.ReloadListener());
            manager.func_110542_a((IResourceManagerReloadListener)new CustomBlockSounds.ReloaderListener());
        }
        BrigadierRoot.INSTANCE.updateHooks();
        BackgroundBlur.registerListener();
        this.manager = new NEUManager(this, this.neuDir);
        this.manager.loadItemInformation();
        this.overlay = new NEUOverlay(this.manager);
        profileViewer = new ProfileViewer(this.manager);
        HypixelItemAPI.INSTANCE.loadItemData();
        for (KeyBinding kb : this.manager.keybinds) {
            ClientRegistry.registerKeyBinding((KeyBinding)kb);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            File tmp = new File(this.neuDir, "tmp");
            if (tmp.exists()) {
                for (File tmpFile : tmp.listFiles()) {
                    tmpFile.delete();
                }
                tmp.delete();
            }
        }));
    }

    public void saveConfig() {
        try {
            OverlayManager.powderGrindingOverlay.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ConfigUtil.saveConfig(this.config, this.configFile, this.gson);
        ItemCustomizeManager.saveCustomization(new File(this.neuDir, "itemCustomization.json"));
        StorageManager.getInstance().saveConfig(new File(this.neuDir, "storageItems.json"));
        FairySouls.getInstance().saveFoundSoulsForAllProfiles(new File(this.neuDir, "collected_fairy_souls.json"), this.gson);
        PetInfoOverlay.saveConfig(new File(this.neuDir, "petCache.json"));
        SlotLocking.getInstance().saveConfig(new File(this.neuDir, "slotLocking.json"));
    }

    public void sendChatMessage(String message) {
        if (System.currentTimeMillis() - this.lastChatMessage > 200L) {
            this.secondLastChatMessage = this.lastChatMessage;
            this.lastChatMessage = System.currentTimeMillis();
            Minecraft.func_71410_x().field_71439_g.func_71165_d(message);
            this.currChatMessage = null;
        } else {
            this.currChatMessage = message;
        }
    }

    public void trySendCommand(String message) {
        if (ClientCommandHandler.instance.func_71556_a((ICommandSender)Minecraft.func_71410_x().field_71439_g, message) == 0) {
            this.sendChatMessage(message);
        }
    }

    public void displayLinks(JsonObject update, int totalWidth) {
        String discord_link = update.get("discord_link").getAsString();
        String youtube_link = update.get("youtube_link").getAsString();
        String twitch_link = update.get("twitch_link").getAsString();
        String github_link = update.get("github_link").getAsString();
        String other_text = update.get("other_text").getAsString();
        String other_link = update.get("other_link").getAsString();
        ChatComponentText other = null;
        if (other_text.length() > 0) {
            other = new ChatComponentText(EnumChatFormatting.GRAY + "[" + EnumChatFormatting.BLUE + other_text + EnumChatFormatting.GRAY + "]");
            other.func_150255_a(Utils.createClickStyle(ClickEvent.Action.OPEN_URL, other_link));
        }
        ChatComponentText links = new ChatComponentText("");
        ChatComponentText separator = new ChatComponentText(EnumChatFormatting.GRAY + EnumChatFormatting.BOLD.toString() + EnumChatFormatting.STRIKETHROUGH + "-");
        ChatComponentText discord = new ChatComponentText(EnumChatFormatting.GRAY + "[" + EnumChatFormatting.BLUE + "Discord" + EnumChatFormatting.GRAY + "]");
        discord.func_150255_a(Utils.createClickStyle(ClickEvent.Action.OPEN_URL, discord_link));
        ChatComponentText youtube = new ChatComponentText(EnumChatFormatting.GRAY + "[" + EnumChatFormatting.RED + "YouTube" + EnumChatFormatting.GRAY + "]");
        youtube.func_150255_a(Utils.createClickStyle(ClickEvent.Action.OPEN_URL, youtube_link));
        ChatComponentText twitch = new ChatComponentText(EnumChatFormatting.GRAY + "[" + EnumChatFormatting.DARK_PURPLE + "Twitch" + EnumChatFormatting.GRAY + "]");
        twitch.func_150255_a(Utils.createClickStyle(ClickEvent.Action.OPEN_URL, twitch_link));
        ChatComponentText github = new ChatComponentText(EnumChatFormatting.GRAY + "[" + EnumChatFormatting.DARK_PURPLE + "GitHub" + EnumChatFormatting.GRAY + "]");
        github.func_150255_a(Utils.createClickStyle(ClickEvent.Action.OPEN_URL, github_link));
        links.func_150257_a((IChatComponent)separator);
        links.func_150257_a((IChatComponent)discord);
        links.func_150257_a((IChatComponent)separator);
        links.func_150257_a((IChatComponent)youtube);
        links.func_150257_a((IChatComponent)separator);
        links.func_150257_a((IChatComponent)twitch);
        links.func_150257_a((IChatComponent)separator);
        links.func_150257_a((IChatComponent)github);
        links.func_150257_a((IChatComponent)separator);
        if (other != null) {
            links.func_150257_a((IChatComponent)other);
            links.func_150257_a((IChatComponent)separator);
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int missingWidth = Math.max(0, totalWidth - fr.func_78256_a(links.func_150254_d()));
        int missingCharsOnEitherSide = missingWidth / fr.func_78256_a(EnumChatFormatting.BOLD + "-") / 2;
        StringBuilder sb = new StringBuilder(missingCharsOnEitherSide + 6);
        sb.append(EnumChatFormatting.GRAY);
        sb.append(EnumChatFormatting.BOLD);
        sb.append(EnumChatFormatting.STRIKETHROUGH);
        for (int i = 0; i < missingCharsOnEitherSide; ++i) {
            sb.append("-");
        }
        String padding = sb.toString();
        ChatComponentText cp = new ChatComponentText("");
        cp.func_150258_a(padding);
        cp.func_150257_a((IChatComponent)links);
        cp.func_150258_a(padding);
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)cp);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            this.openGui = null;
            this.currChatMessage = null;
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (this.openGui != null) {
            if (Minecraft.func_71410_x().field_71439_g.field_71070_bA != null) {
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
            }
            Minecraft.func_71410_x().func_147108_a(this.openGui);
            this.openGui = null;
            this.lastOpenedGui = System.currentTimeMillis();
        }
        if (this.currChatMessage != null && currentTime - this.lastChatMessage > 200L) {
            this.lastChatMessage = currentTime;
            Minecraft.func_71410_x().field_71439_g.func_71165_d(this.currChatMessage);
            this.currChatMessage = null;
        }
    }

    public boolean isOnSkyblock() {
        if (!this.config.misc.onlyShowOnSkyblock) {
            return true;
        }
        return this.hasSkyblockScoreboard();
    }

    public boolean hasSkyblockScoreboard() {
        return this.hasSkyblockScoreboard;
    }

    public void updateSkyblockScoreboard() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71441_e != null && mc.field_71439_g != null) {
            if (mc.func_71356_B() || mc.field_71439_g.func_142021_k() == null || !mc.field_71439_g.func_142021_k().toLowerCase(Locale.ROOT).contains("hypixel")) {
                this.hasSkyblockScoreboard = false;
                return;
            }
            Scoreboard scoreboard = mc.field_71441_e.func_96441_U();
            ScoreObjective sidebarObjective = scoreboard.func_96539_a(1);
            if (sidebarObjective != null) {
                String objectiveName = sidebarObjective.func_96678_d().replaceAll("(?i)\\u00A7.", "");
                for (String skyblock : SKYBLOCK_IN_ALL_LANGUAGES) {
                    if (!objectiveName.startsWith(skyblock)) continue;
                    this.hasSkyblockScoreboard = true;
                    return;
                }
            }
            this.hasSkyblockScoreboard = false;
        }
    }
}

