/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WPCell;
import info.bliki.wiki.filter.WPList;
import info.bliki.wiki.filter.WPListElement;
import info.bliki.wiki.filter.WPRow;
import info.bliki.wiki.filter.WPTable;
import info.bliki.wiki.model.ITableOfContent;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.util.NodeAttribute;
import info.bliki.wiki.tags.util.WikiTagNode;
import java.util.ArrayList;
import java.util.List;

public class WikipediaScanner {
    public static final int EOF = -1;
    protected int fScannerPosition;
    protected IWikiModel fWikiModel;
    protected final String fStringSource;
    protected final char[] fSource;

    public WikipediaScanner(String src) {
        this(src, 0);
    }

    public WikipediaScanner(String src, int position) {
        this.fSource = src.toCharArray();
        this.fStringSource = src;
        this.fScannerPosition = position;
    }

    public void setModel(IWikiModel wikiModel) {
        this.fWikiModel = wikiModel;
    }

    public int getPosition() {
        return this.fScannerPosition;
    }

    public void setPosition(int newPos) {
        this.fScannerPosition = newPos;
    }

    public WPTable wpTable(ITableOfContent tableOfContentTag) {
        WPTable table = null;
        WPCell cell = null;
        ArrayList<WPCell> cells = new ArrayList<WPCell>();
        WPRow row = new WPRow(cells);
        try {
            if (this.fScannerPosition < 0) {
                this.fScannerPosition = 0;
            }
            if (this.fSource[this.fScannerPosition++] != '{') {
                return null;
            }
            if (this.fSource[this.fScannerPosition++] != '|') {
                return null;
            }
            ArrayList<WPRow> rows = new ArrayList<WPRow>();
            table = new WPTable(rows);
            int startPos = this.fScannerPosition;
            this.nextNewline();
            table.setParams(this.fStringSource.substring(startPos, this.fScannerPosition));
            int ch = 32;
            block19: while (true) {
                ch = this.fSource[this.fScannerPosition++];
                switch (ch) {
                    case 91: {
                        int position = WikipediaScanner.findNestedEndSingle(this.fSource, '[', ']', this.fScannerPosition);
                        if (position < 0) continue block19;
                        this.fScannerPosition = position;
                        continue block19;
                    }
                    case 123: {
                        int cposition = WikipediaScanner.findNestedEndSingle(this.fSource, '{', '}', this.fScannerPosition);
                        if (cposition < 0) continue block19;
                        this.fScannerPosition = cposition;
                        continue block19;
                    }
                    case 10: {
                        ch = this.fSource[this.fScannerPosition++];
                        while (ch == 32 || ch == 9) {
                            ch = this.fSource[this.fScannerPosition++];
                        }
                        switch (ch) {
                            case 124: {
                                if (cell != null) {
                                    cell.createTagStack(table, this.fSource, this.fWikiModel, this.fScannerPosition - 2);
                                    cell = null;
                                }
                                ch = this.fSource[this.fScannerPosition++];
                                switch (ch) {
                                    case 45: {
                                        this.addTableRow(table, row);
                                        cells = new ArrayList();
                                        row = new WPRow(cells);
                                        startPos = this.fScannerPosition;
                                        this.nextNewlineCell(cell);
                                        row.setParams(this.fStringSource.substring(startPos, this.fScannerPosition));
                                        continue block19;
                                    }
                                    case 43: {
                                        this.addTableRow(table, row);
                                        cells = new ArrayList();
                                        row = new WPRow(cells);
                                        row.setType(4);
                                        cell = new WPCell(this.fScannerPosition);
                                        cell.setType(4);
                                        cells.add(cell);
                                        this.nextNewlineCell(cell);
                                        cell.createTagStack(table, this.fSource, this.fWikiModel, this.fScannerPosition);
                                        cell = null;
                                        this.addTableRow(table, row);
                                        cells = new ArrayList();
                                        row = new WPRow(cells);
                                        continue block19;
                                    }
                                    case 125: {
                                        this.addTableRow(table, row);
                                        return table;
                                    }
                                }
                                --this.fScannerPosition;
                                cell = new WPCell(this.fScannerPosition);
                                cells.add(cell);
                                continue block19;
                            }
                            case 33: {
                                if (cell != null) {
                                    cell.createTagStack(table, this.fSource, this.fWikiModel, this.fScannerPosition - 2);
                                    cell = null;
                                }
                                ch = this.fSource[this.fScannerPosition++];
                                cell = new WPCell(this.fScannerPosition - 1);
                                cell.setType(2);
                                cells.add(cell);
                                continue block19;
                            }
                            case 123: {
                                if (this.fSource[this.fScannerPosition] != '|') continue block19;
                                this.fScannerPosition = this.indexEndOfTable();
                                continue block19;
                            }
                        }
                        --this.fScannerPosition;
                        continue block19;
                    }
                    case 124: {
                        ch = this.fSource[this.fScannerPosition++];
                        if (ch == 124) {
                            if (cell != null) {
                                cell.createTagStack(table, this.fSource, this.fWikiModel, this.fScannerPosition - 2);
                                cell = null;
                            }
                            cell = new WPCell(this.fScannerPosition);
                            cells.add(cell);
                            continue block19;
                        }
                        --this.fScannerPosition;
                        if (cell == null) continue block19;
                        cell.setAttributesStartPos(this.fScannerPosition - 1);
                        continue block19;
                    }
                    case 33: {
                        ch = this.fSource[this.fScannerPosition++];
                        if (ch == 33) {
                            if (cell != null) {
                                cell.createTagStack(table, this.fSource, this.fWikiModel, this.fScannerPosition - 2);
                                cell = null;
                            }
                            cell = new WPCell(this.fScannerPosition);
                            cell.setType(2);
                            cells.add(cell);
                            continue block19;
                        }
                        --this.fScannerPosition;
                        continue block19;
                    }
                }
                if (cell != null) continue;
                cell = new WPCell(this.fScannerPosition - 1);
                cell.setType(8);
                cells.add(cell);
            }
        }
        catch (IndexOutOfBoundsException e2) {
            this.fScannerPosition = this.fSource.length;
            if (cell != null) {
                cell.createTagStack(table, this.fSource, this.fWikiModel, this.fScannerPosition);
                cell = null;
            }
            if (table != null && row != null && row.size() > 0) {
                this.addTableRow(table, row);
            }
            if (table != null) {
                return table;
            }
            return null;
        }
    }

    private void addTableRow(WPTable table, WPRow row) {
        if (row.getParams() != null) {
            table.add(row);
        } else if (row.size() > 0) {
            table.add(row);
        }
    }

    public WPList wpList() {
        WPList list = null;
        WPListElement listElement = null;
        try {
            char ch;
            char lastCh = ' ';
            char[] sequence = null;
            int count = 0;
            if (this.fScannerPosition < 0) {
                this.fScannerPosition = 0;
                ch = '\n';
            } else {
                ch = this.fSource[this.fScannerPosition++];
            }
            list = new WPList();
            while (true) {
                int temp;
                int startPosition;
                if (ch == ':') {
                    if (this.fScannerPosition < this.fSource.length - 2 && this.fSource[this.fScannerPosition] == '/' && this.fSource[this.fScannerPosition + 1] == '/' && this.fScannerPosition > 1 && Character.isLetter(this.fSource[this.fScannerPosition - 2])) {
                        this.fScannerPosition += 2;
                        ch = this.fSource[this.fScannerPosition++];
                        continue;
                    }
                    if (lastCh == ';' && sequence != null) {
                        block23: {
                            int startPos;
                            startPosition = this.fScannerPosition;
                            if (listElement != null) {
                                listElement.createTagStack(this.fSource, this.fWikiModel, this.fScannerPosition - 1);
                                list.add(listElement);
                                listElement = null;
                            }
                            char[] ddSequence = new char[sequence.length];
                            System.arraycopy(sequence, 0, ddSequence, 0, sequence.length);
                            ddSequence[sequence.length - 1] = 58;
                            sequence = ddSequence;
                            do {
                                if (Character.isWhitespace(ch = this.fSource[this.fScannerPosition++])) continue;
                                startPos = this.fScannerPosition - 1;
                                listElement = new WPListElement(count, sequence, startPos);
                                break block23;
                            } while (ch != 10);
                            startPos = --this.fScannerPosition;
                            listElement = new WPListElement(count, sequence, startPos);
                            listElement.createTagStack(this.fSource, this.fWikiModel, startPos);
                            list.add(listElement);
                            listElement = null;
                        }
                        lastCh = ' ';
                    }
                }
                if (ch == '\n' || this.fScannerPosition == 0) {
                    startPosition = this.fScannerPosition;
                    if (listElement != null) {
                        listElement.createTagStack(this.fSource, this.fWikiModel, this.fScannerPosition - 1);
                        list.add(listElement);
                        listElement = null;
                    }
                    ch = this.fSource[this.fScannerPosition++];
                    block1 : switch (ch) {
                        case '#': 
                        case '*': 
                        case ':': 
                        case ';': {
                            count = 1;
                            lastCh = ch;
                            while (this.fSource[this.fScannerPosition] == '*' || this.fSource[this.fScannerPosition] == '#' || this.fSource[this.fScannerPosition] == ':' || this.fSource[this.fScannerPosition] == ';') {
                                ++count;
                                lastCh = this.fSource[this.fScannerPosition++];
                            }
                            sequence = new char[count];
                            System.arraycopy(this.fSource, this.fScannerPosition - count, sequence, 0, count);
                            do {
                                if (Character.isWhitespace(ch = this.fSource[this.fScannerPosition++])) continue;
                                int startPos = this.fScannerPosition - 1;
                                listElement = new WPListElement(count, sequence, startPos);
                                break block1;
                            } while (ch != 10);
                            int startPos = --this.fScannerPosition;
                            listElement = new WPListElement(count, sequence, startPos);
                            listElement.createTagStack(this.fSource, this.fWikiModel, startPos);
                            list.add(listElement);
                            listElement = null;
                            break;
                        }
                        default: {
                            this.fScannerPosition = startPosition;
                            return list;
                        }
                    }
                }
                if (ch == '<') {
                    int temp2 = this.readSpecialWikiTags(this.fScannerPosition);
                    if (temp2 >= 0) {
                        this.fScannerPosition = temp2;
                    }
                } else if (ch == '[' && (temp = WikipediaScanner.findNestedEndSingle(this.fSource, '[', ']', this.fScannerPosition)) >= 0) {
                    this.fScannerPosition = temp;
                }
                ch = this.fSource[this.fScannerPosition++];
            }
        }
        catch (IndexOutOfBoundsException e2) {
            this.fScannerPosition = this.fSource.length + 1;
            if (list != null) {
                if (listElement != null) {
                    listElement.createTagStack(this.fSource, this.fWikiModel, this.fScannerPosition - 1);
                    list.add(listElement);
                    listElement = null;
                }
                return list;
            }
            return null;
        }
    }

    public int nextNewline() {
        while (this.fSource[this.fScannerPosition++] != '\n') {
        }
        return --this.fScannerPosition;
    }

    public int nextNewlineCell(WPCell cell) {
        char ch;
        while ((ch = this.fSource[this.fScannerPosition++]) != '\n') {
            int cposition;
            if (ch == '|') {
                if (cell == null) continue;
                cell.setAttributesStartPos(this.fScannerPosition - 1);
                continue;
            }
            if (ch == '[') {
                int position = WikipediaScanner.findNestedEndSingle(this.fSource, '[', ']', this.fScannerPosition);
                if (position < 0) continue;
                this.fScannerPosition = position;
                continue;
            }
            if (ch != '{' || (cposition = WikipediaScanner.findNestedEndSingle(this.fSource, '{', '}', this.fScannerPosition)) < 0) continue;
            this.fScannerPosition = cposition;
        }
        return --this.fScannerPosition;
    }

    public int indexEndOfComment() {
        while (this.fScannerPosition < this.fSource.length - 2) {
            char ch;
            if ((ch = this.fSource[this.fScannerPosition++]) != '-' || this.fSource[this.fScannerPosition] != '-' || this.fSource[this.fScannerPosition + 1] != '>') continue;
            return this.fScannerPosition + 2;
        }
        return -1;
    }

    public int indexEndOfNowiki() {
        while (this.fScannerPosition < this.fSource.length - 8) {
            char ch;
            if ((ch = this.fSource[this.fScannerPosition++]) != '<' || this.fSource[this.fScannerPosition] != '/' || this.fSource[this.fScannerPosition + 1] != 'n' || this.fSource[this.fScannerPosition + 2] != 'o' || this.fSource[this.fScannerPosition + 3] != 'w' || this.fSource[this.fScannerPosition + 4] != 'i' || this.fSource[this.fScannerPosition + 5] != 'k' || this.fSource[this.fScannerPosition + 6] != 'i' || this.fSource[this.fScannerPosition + 7] != '>') continue;
            return this.fScannerPosition + 8;
        }
        return -1;
    }

    public int indexEndOfTable() {
        int nestedWikiTableCounter = 1;
        try {
            while (this.fScannerPosition < this.fSource.length) {
                char ch;
                if ((ch = this.fSource[this.fScannerPosition++]) == '<' && this.fSource[this.fScannerPosition] == '!' && this.fSource[this.fScannerPosition + 1] == '-' && this.fSource[this.fScannerPosition + 2] == '-') {
                    this.fScannerPosition += 3;
                    this.fScannerPosition = this.indexEndOfComment();
                    if (this.fScannerPosition != -1) continue;
                    return -1;
                }
                if (ch == '<' && this.fSource[this.fScannerPosition] == 'n' && this.fSource[this.fScannerPosition + 1] == 'o' && this.fSource[this.fScannerPosition + 2] == 'w' && this.fSource[this.fScannerPosition + 3] == 'i' && this.fSource[this.fScannerPosition + 4] == 'k' && this.fSource[this.fScannerPosition + 5] == 'i' && this.fSource[this.fScannerPosition + 6] == '>') {
                    this.fScannerPosition += 7;
                    this.fScannerPosition = this.indexEndOfNowiki();
                    if (this.fScannerPosition != -1) continue;
                    return -1;
                }
                if (ch == '\n' && this.fSource[this.fScannerPosition] == '{' && this.fSource[this.fScannerPosition + 1] == '|') {
                    ++nestedWikiTableCounter;
                    continue;
                }
                if (ch != '\n') continue;
                int oldPosition = this.fScannerPosition;
                ch = this.fSource[this.fScannerPosition++];
                while (ch == ' ' || ch == '\t') {
                    ch = this.fSource[this.fScannerPosition++];
                }
                if (ch == '|' && this.fSource[this.fScannerPosition] == '}' && --nestedWikiTableCounter == 0) {
                    return this.fScannerPosition + 1;
                }
                this.fScannerPosition = oldPosition;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return -1;
    }

    public static boolean startsWith(String str, int toffset, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length() - toffset) {
            return false;
        }
        return str.regionMatches(ignoreCase, toffset, prefix, 0, prefix.length());
    }

    public static List<String> splitByPipe(String sourceString, List<String> resultList) {
        return WikipediaScanner.splitByChar('|', sourceString, resultList, -1);
    }

    public static List<String> splitByPipe(char[] srcArray, int currOffset, int endOffset, List<String> resultList) {
        return WikipediaScanner.splitByChar('|', srcArray, currOffset, endOffset, resultList, -1);
    }

    public static List<String> splitByChar(char splitChar, String sourceString, List<String> resultList, int maxParts) {
        return WikipediaScanner.splitByChar(splitChar, sourceString.toCharArray(), 0, sourceString.length(), resultList, maxParts);
    }

    protected static List<String> splitByChar(char splitChar, char[] srcArray, int currOffset, int endOffset, List<String> resultList, int maxParts) {
        block13: {
            assert (maxParts != 0 && maxParts != 1);
            if (resultList == null) {
                resultList = new ArrayList<String>();
            }
            int[] temp = new int[]{-1, -1};
            int lastOffset = currOffset;
            try {
                while (currOffset < endOffset) {
                    char ch;
                    if ((ch = srcArray[currOffset++]) == '[' && srcArray[currOffset] == '[') {
                        temp[0] = WikipediaScanner.findNestedEnd(srcArray, '[', ']', ++currOffset);
                        if (temp[0] < 0) continue;
                        currOffset = temp[0];
                        continue;
                    }
                    if (ch == '{' && srcArray[currOffset] == '{') {
                        if (srcArray[++currOffset] == '{' && srcArray[currOffset + 1] != '{') {
                            if ((temp = WikipediaScanner.findNestedParamEnd(srcArray, ++currOffset))[0] < 0) continue;
                            currOffset = temp[0];
                            continue;
                        }
                        temp[0] = WikipediaScanner.findNestedTemplateEnd(srcArray, currOffset);
                        if (temp[0] < 0) continue;
                        currOffset = temp[0];
                        continue;
                    }
                    if (ch != splitChar) continue;
                    if (maxParts > 0 && resultList.size() >= maxParts - 1) {
                        currOffset = endOffset;
                        break;
                    }
                    resultList.add(new String(srcArray, lastOffset, currOffset - lastOffset - 1));
                    lastOffset = currOffset;
                }
                if (currOffset > lastOffset) {
                    resultList.add(new String(srcArray, lastOffset, currOffset - lastOffset));
                } else if (currOffset == lastOffset) {
                    resultList.add("");
                }
            }
            catch (IndexOutOfBoundsException e2) {
                if (currOffset > lastOffset) {
                    resultList.add(new String(srcArray, lastOffset, currOffset - lastOffset));
                }
                if (currOffset != lastOffset) break block13;
                resultList.add("");
            }
        }
        return resultList;
    }

    public static int findNestedEnd(char[] sourceArray, char startCh, char endChar, int startPosition) {
        int level = 1;
        int position = startPosition;
        int sourceArrayLength = sourceArray.length - 1;
        try {
            while (position < sourceArrayLength) {
                char ch;
                if ((ch = sourceArray[position++]) == startCh && sourceArray[position] == startCh) {
                    ++position;
                    ++level;
                    continue;
                }
                if (ch != endChar || sourceArray[position] != endChar) continue;
                ++position;
                if (--level != 0) continue;
                return position;
            }
            return -1;
        }
        catch (IndexOutOfBoundsException e2) {
            return -1;
        }
    }

    public static int findNestedEndSingle(char[] sourceArray, char startCh, char endChar, int startPosition) {
        int level = 1;
        int position = startPosition;
        int sourceArrayLength = sourceArray.length;
        try {
            while (position < sourceArrayLength) {
                char ch;
                if ((ch = sourceArray[position++]) == startCh) {
                    ++level;
                    continue;
                }
                if (ch != endChar || --level != 0) continue;
                return position;
            }
            return -1;
        }
        catch (IndexOutOfBoundsException e2) {
            return -1;
        }
    }

    public static int findNestedTemplateEnd(char[] sourceArray, int startPosition) {
        int countOpenBraces = 0;
        int position = startPosition;
        try {
            while (position < sourceArray.length) {
                char ch = sourceArray[position++];
                switch (ch) {
                    case '{': {
                        if (sourceArray[position - 2] != '{' && sourceArray[position] != '{') break;
                        ++countOpenBraces;
                        break;
                    }
                    case '}': {
                        if (sourceArray[position - 2] != '}' && sourceArray[position] != '}') break;
                        if (countOpenBraces > 0) {
                            --countOpenBraces;
                            break;
                        }
                        return position + 1;
                    }
                }
            }
            return -1;
        }
        catch (IndexOutOfBoundsException e2) {
            return -1;
        }
    }

    public static int[] findNestedParamEnd(char[] sourceArray, int startPosition) {
        int sourceArrayLength = sourceArray.length;
        int countSingleOpenBraces = 0;
        int parameterPosition = startPosition;
        try {
            while (parameterPosition < sourceArrayLength) {
                char ch;
                if ((ch = sourceArray[parameterPosition++]) == '{') {
                    if (sourceArrayLength > parameterPosition && sourceArray[parameterPosition] == '{') {
                        if (sourceArrayLength > ++parameterPosition && sourceArray[parameterPosition] == '{' && sourceArray[parameterPosition + 1] != '{') {
                            int[] temp;
                            if ((temp = WikipediaScanner.findNestedParamEnd(sourceArray, ++parameterPosition))[0] >= 0) {
                                parameterPosition = temp[0];
                                continue;
                            }
                            if (temp[1] >= 0) {
                                parameterPosition = temp[1];
                                continue;
                            }
                            return new int[]{-1, -1};
                        }
                        int temp = WikipediaScanner.findNestedTemplateEnd(sourceArray, parameterPosition);
                        if (temp < 0) {
                            return new int[]{-1, -1};
                        }
                        parameterPosition = temp;
                        continue;
                    }
                    ++countSingleOpenBraces;
                    continue;
                }
                if (ch != '}') continue;
                if (countSingleOpenBraces > 0) {
                    --countSingleOpenBraces;
                    continue;
                }
                if (sourceArrayLength <= parameterPosition || sourceArray[parameterPosition] != '}') continue;
                if (sourceArray[parameterPosition + 1] == '}') {
                    return new int[]{parameterPosition + 2, -1};
                }
                return new int[]{-1, parameterPosition + 1};
            }
            return new int[]{-1, -1};
        }
        catch (IndexOutOfBoundsException e2) {
            return new int[]{-1, -1};
        }
    }

    protected WikiTagNode parseTag(int start) {
        boolean done = false;
        ArrayList<NodeAttribute> attributes = new ArrayList<NodeAttribute>();
        int state = 0;
        this.fScannerPosition = start;
        int[] bookmarks = new int[8];
        bookmarks[0] = this.fScannerPosition;
        try {
            block11: while (!done) {
                bookmarks[state + 1] = this.fScannerPosition;
                char ch = this.fSource[this.fScannerPosition++];
                switch (state) {
                    case 0: {
                        if ('\uffffffff' == ch || '>' == ch || '<' == ch) {
                            if ('<' == ch) {
                                bookmarks[state + 1] = --this.fScannerPosition;
                            }
                            this.whitespace(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        this.whitespace(attributes, bookmarks);
                        state = 1;
                        continue block11;
                    }
                    case 1: {
                        if ('\uffffffff' == ch || '>' == ch || '<' == ch) {
                            if ('<' == ch) {
                                bookmarks[state + 1] = --this.fScannerPosition;
                            }
                            this.standalone(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if (Character.isWhitespace(ch)) {
                            bookmarks[6] = bookmarks[2];
                            state = 6;
                            continue block11;
                        }
                        if ('=' != ch) continue block11;
                        state = 2;
                        continue block11;
                    }
                    case 2: {
                        if ('\uffffffff' == ch || '>' == ch) {
                            this.empty(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if ('\'' == ch) {
                            state = 4;
                            bookmarks[4] = bookmarks[3];
                            continue block11;
                        }
                        if ('\"' == ch) {
                            state = 5;
                            bookmarks[5] = bookmarks[3];
                            continue block11;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        state = 3;
                        continue block11;
                    }
                    case 3: {
                        if ('\uffffffff' == ch || '>' == ch) {
                            this.naked(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if (Character.isWhitespace(ch)) {
                            this.naked(attributes, bookmarks);
                            bookmarks[0] = bookmarks[4];
                            state = 0;
                            continue block11;
                        }
                        if (ch != '/' || this.fSource[this.fScannerPosition] != '>') continue block11;
                        this.naked(attributes, bookmarks);
                        bookmarks[0] = bookmarks[4];
                        --this.fScannerPosition;
                        state = 0;
                        continue block11;
                    }
                    case 4: {
                        if ('\uffffffff' == ch) {
                            this.single_quote(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if ('\'' != ch) continue block11;
                        this.single_quote(attributes, bookmarks);
                        bookmarks[0] = bookmarks[5] + 1;
                        state = 0;
                        continue block11;
                    }
                    case 5: {
                        if ('\uffffffff' == ch) {
                            this.double_quote(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if ('\"' != ch) continue block11;
                        this.double_quote(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6] + 1;
                        state = 0;
                        continue block11;
                    }
                    case 6: {
                        if ('\uffffffff' == ch) {
                            this.standalone(attributes, bookmarks);
                            bookmarks[0] = bookmarks[6];
                            --this.fScannerPosition;
                            state = 0;
                            continue block11;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        if ('=' == ch) {
                            bookmarks[2] = bookmarks[6];
                            bookmarks[3] = bookmarks[7];
                            state = 2;
                            continue block11;
                        }
                        this.standalone(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6];
                        --this.fScannerPosition;
                        state = 0;
                        continue block11;
                    }
                }
                throw new IllegalStateException("how did we get in state " + state);
            }
            if (this.fSource[this.fScannerPosition - 1] != '>') {
                this.fScannerPosition = start;
                return null;
            }
            return this.makeTag(start, this.fScannerPosition, attributes);
        }
        catch (IndexOutOfBoundsException e2) {
            if (state == 3) {
                this.naked(attributes, bookmarks);
            }
            this.fScannerPosition = start;
            return null;
        }
    }

    protected List<NodeAttribute> parseAttributes(int start, int end) {
        boolean done = false;
        ArrayList<NodeAttribute> attributes = new ArrayList<NodeAttribute>();
        int state = 0;
        this.fScannerPosition = start;
        int[] bookmarks = new int[8];
        bookmarks[0] = this.fScannerPosition;
        try {
            block11: while (!done && this.fScannerPosition < end) {
                bookmarks[state + 1] = this.fScannerPosition;
                char ch = this.fSource[this.fScannerPosition++];
                switch (state) {
                    case 0: {
                        if ('\uffffffff' == ch || '>' == ch || '<' == ch) {
                            if ('<' == ch) {
                                bookmarks[state + 1] = --this.fScannerPosition;
                            }
                            this.whitespace(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        this.whitespace(attributes, bookmarks);
                        state = 1;
                        continue block11;
                    }
                    case 1: {
                        if ('\uffffffff' == ch || '>' == ch || '<' == ch) {
                            if ('<' == ch) {
                                bookmarks[state + 1] = --this.fScannerPosition;
                            }
                            this.standalone(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if (Character.isWhitespace(ch)) {
                            bookmarks[6] = bookmarks[2];
                            state = 6;
                            continue block11;
                        }
                        if ('=' != ch) continue block11;
                        state = 2;
                        continue block11;
                    }
                    case 2: {
                        if ('\uffffffff' == ch || '>' == ch) {
                            this.empty(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if ('\'' == ch) {
                            state = 4;
                            bookmarks[4] = bookmarks[3];
                            continue block11;
                        }
                        if ('\"' == ch) {
                            state = 5;
                            bookmarks[5] = bookmarks[3];
                            continue block11;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        state = 3;
                        continue block11;
                    }
                    case 3: {
                        if ('\uffffffff' == ch || '>' == ch) {
                            this.naked(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if (!Character.isWhitespace(ch)) continue block11;
                        this.naked(attributes, bookmarks);
                        bookmarks[0] = bookmarks[4];
                        state = 0;
                        continue block11;
                    }
                    case 4: {
                        if ('\uffffffff' == ch) {
                            this.single_quote(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if ('\'' != ch) continue block11;
                        this.single_quote(attributes, bookmarks);
                        bookmarks[0] = bookmarks[5] + 1;
                        state = 0;
                        continue block11;
                    }
                    case 5: {
                        if ('\uffffffff' == ch) {
                            this.double_quote(attributes, bookmarks);
                            done = true;
                            continue block11;
                        }
                        if ('\"' != ch) continue block11;
                        this.double_quote(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6] + 1;
                        state = 0;
                        continue block11;
                    }
                    case 6: {
                        if ('\uffffffff' == ch) {
                            this.standalone(attributes, bookmarks);
                            bookmarks[0] = bookmarks[6];
                            --this.fScannerPosition;
                            state = 0;
                            continue block11;
                        }
                        if (Character.isWhitespace(ch)) continue block11;
                        if ('=' == ch) {
                            bookmarks[2] = bookmarks[6];
                            bookmarks[3] = bookmarks[7];
                            state = 2;
                            continue block11;
                        }
                        this.standalone(attributes, bookmarks);
                        bookmarks[0] = bookmarks[6];
                        --this.fScannerPosition;
                        state = 0;
                        continue block11;
                    }
                }
                throw new IllegalStateException("how did we get in state " + state);
            }
            if (state == 3 || state == 4 || state == 5) {
                bookmarks[state + 1] = this.fScannerPosition;
                this.naked(attributes, bookmarks);
            }
            return attributes;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    protected WikiTagNode makeTag(int start, int end, ArrayList<NodeAttribute> attributes) {
        int length = end - start;
        if (0 != length) {
            if (2 > length) {
                return null;
            }
            return new WikiTagNode(start, end, attributes);
        }
        return null;
    }

    private void whitespace(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
    }

    private void standalone(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], -1, -1, '\u0000'));
    }

    private void empty(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], bookmarks[2] + 1, -1, '\u0000'));
    }

    private void naked(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], bookmarks[3], bookmarks[4], '\u0000'));
    }

    private void single_quote(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], bookmarks[4] + 1, bookmarks[5], '\''));
    }

    private void double_quote(ArrayList<NodeAttribute> attributes, int[] bookmarks) {
        attributes.add(new NodeAttribute(this.fSource, bookmarks[1], bookmarks[2], bookmarks[5] + 1, bookmarks[6], '\"'));
    }

    protected int readSpecialWikiTags(int start) {
        int startPosition = this.fScannerPosition;
        try {
            WikiTagNode tagNode;
            if (this.fSource[start] != '/' && (tagNode = this.parseTag(start)) != null && !tagNode.isEmptyXmlTag()) {
                String tagName = tagNode.getTagName();
                return this.readUntilIgnoreCase(this.fScannerPosition, "</", tagName + ">");
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.fScannerPosition = startPosition;
        return -1;
    }

    protected final int readUntilIgnoreCase(int start, String startString, String endString) {
        int index = Util.indexOfIgnoreCase(this.fStringSource, startString, endString, start);
        if (index != -1) {
            return index + startString.length() + endString.length();
        }
        return -1;
    }

    protected int indexOfUntilNoLetter(char testChar, int fromIndex) {
        int index = fromIndex;
        while (index < this.fSource.length) {
            char ch;
            if ((ch = this.fSource[index++]) == testChar) {
                return index - 1;
            }
            if (Character.isLetter(ch)) {
                if (this.fSource.length > index) continue;
                return -1;
            }
            return -1;
        }
        return -1;
    }
}

