/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.TagNode;
import info.bliki.wiki.filter.WikipediaScanner;
import info.bliki.wiki.tags.util.NodeAttribute;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Util {
    private Util() {
    }

    public static NodeAttribute addAttributes(TagNode node, String attributesString) {
        List<NodeAttribute> attributes;
        if (attributesString != null && (attributes = Util.getNodeAttributes(attributesString)) != null) {
            NodeAttribute attr = null;
            for (int i = 0; i < attributes.size(); ++i) {
                attr = attributes.get(i);
                node.addAttribute(attr.getName(), attr.getValue(), true);
            }
            return attr;
        }
        return null;
    }

    public static List<NodeAttribute> getNodeAttributes(String attributesString) {
        String trimmed;
        List<NodeAttribute> attributes = null;
        if (attributesString != null && (trimmed = attributesString.trim()).length() != 0) {
            WikipediaScanner scanner = new WikipediaScanner(trimmed);
            attributes = scanner.parseAttributes(0, trimmed.length());
        }
        return attributes;
    }

    public static Map<String, String> getAttributes(String attributesString) {
        String trimmed;
        TreeMap<String, String> map2 = null;
        if (attributesString != null && (trimmed = attributesString.trim()).length() != 0) {
            map2 = new TreeMap<String, String>();
            WikipediaScanner scanner = new WikipediaScanner(trimmed);
            List<NodeAttribute> attributes = scanner.parseAttributes(0, trimmed.length());
            for (int i = 0; i < attributes.size(); ++i) {
                NodeAttribute attr = attributes.get(i);
                map2.put(attr.getName(), attr.getValue());
            }
        }
        return map2;
    }

    public static int indexOfIgnoreCase(String searchableString, String startPattern, String endPattern, int fromIndex) {
        int n = endPattern.length();
        int len2 = startPattern.length();
        while (searchableString.length() > fromIndex + n - 1) {
            int index = searchableString.indexOf(startPattern, fromIndex);
            if (index >= 0) {
                fromIndex = index + len2;
                if (searchableString.regionMatches(true, fromIndex, endPattern, 0, n)) {
                    return fromIndex - len2;
                }
            } else {
                return -1;
            }
            ++fromIndex;
        }
        return -1;
    }

    public static int indexOfNestedIgnoreCase(String searchableString, String endPattern, int fromIndex) {
        int n = endPattern.length();
        int level = 0;
        while (searchableString.length() > fromIndex + n - 1) {
            int index = searchableString.indexOf(60, fromIndex);
            if (index < 0) {
                return -1;
            }
            if (searchableString.length() > index + n) {
                if (searchableString.charAt(index + 1) == '/') {
                    fromIndex = index + 2;
                    if (searchableString.regionMatches(true, fromIndex, endPattern, 0, n)) {
                        if (level == 0) {
                            return fromIndex - 2;
                        }
                        --level;
                    }
                } else {
                    fromIndex = index + 1;
                    if (searchableString.regionMatches(true, fromIndex, endPattern, 0, n)) {
                        ++level;
                    }
                }
                fromIndex = index + 1;
                continue;
            }
            return -1;
        }
        return -1;
    }

    public static String trimNewlineRight(String str) {
        int start;
        int end = str.length();
        for (start = 0; start < end && Character.isWhitespace(str.charAt(start)); ++start) {
        }
        while (start < end && Character.isWhitespace(str.charAt(end - 1))) {
            if (str.charAt(end - 1) == '\n') {
                --end;
                break;
            }
            --end;
        }
        if (start < end && str.charAt(end - 1) == '\r') {
            --end;
        }
        return start > 0 || end < str.length() ? str.substring(start, end) : str;
    }

    public static boolean isInvalidTemplateName(CharSequence templateName) {
        boolean noNamespaceCharacter = true;
        for (int i = 0; i < templateName.length(); ++i) {
            if (templateName.charAt(i) == ':') {
                noNamespaceCharacter = false;
                continue;
            }
            if (Character.isISOControl(templateName.charAt(i))) {
                if (!noNamespaceCharacter) continue;
                return true;
            }
            noNamespaceCharacter = true;
        }
        return false;
    }

    public static int indexOfTemplateParsing(CharSequence rawWikitext) {
        int len2 = rawWikitext.length() - 2;
        for (int i = 0; i < len2; ++i) {
            char ch = rawWikitext.charAt(i);
            if (ch == '{') {
                return i;
            }
            if (ch == '<') {
                return i;
            }
            if (ch == '[') {
                return i;
            }
            if (ch != '~') continue;
            return i;
        }
        return -1;
    }
}

