/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.ContentToken;
import info.bliki.htmlcleaner.EndTagToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.TagToken;
import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.model.ImageFormat;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class HTMLConverter
implements ITextConverter {
    private boolean renderLinks;

    public HTMLConverter(boolean renderLinks) {
        this.renderLinks = renderLinks;
    }

    public HTMLConverter() {
        this(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodesToText(List<? extends Object> nodes, Appendable resultBuffer, IWikiModel model) throws IOException {
        if (nodes != null && !nodes.isEmpty()) {
            try {
                int level = model.incrementRecursionLevel();
                if (level > 256) {
                    resultBuffer.append("<span class=\"error\">Error - recursion limit exceeded rendering tags in HTMLConverter#nodesToText().</span>");
                    return;
                }
                for (Object object : nodes) {
                    TagToken node;
                    if (object == null) continue;
                    if (object instanceof List) {
                        List list = (List)object;
                        this.nodesToText(list, resultBuffer, model);
                        continue;
                    }
                    if (object instanceof ContentToken) {
                        ContentToken contentToken = (ContentToken)object;
                        String content = contentToken.getContent();
                        Utils.escapeXmlToBuffer(content, resultBuffer, true, true, true);
                        continue;
                    }
                    if (object instanceof HTMLTag) {
                        ((HTMLTag)object).renderHTML(this, resultBuffer, model);
                        continue;
                    }
                    if (object instanceof TagNode) {
                        node = (TagNode)object;
                        Map<String, Object> map2 = ((TagNode)node).getObjectAttributes();
                        if (map2 != null && map2.size() > 0) {
                            Object attValue = map2.get("wikiobject");
                            if (!(attValue instanceof ImageFormat)) continue;
                            this.imageNodeToText((TagNode)node, (ImageFormat)attValue, resultBuffer, model);
                            continue;
                        }
                        this.nodeToHTML((TagNode)node, resultBuffer, model);
                        continue;
                    }
                    if (!(object instanceof EndTagToken)) continue;
                    node = (EndTagToken)object;
                    resultBuffer.append('<');
                    resultBuffer.append(node.getName());
                    resultBuffer.append(" />");
                }
            }
            finally {
                model.decrementRecursionLevel();
            }
        }
    }

    protected void nodeToHTML(TagNode node, Appendable resultBuffer, IWikiModel model) throws IOException {
        String name = node.getName();
        if (name.equals("div") || name.equals("p") || name.equals("table") || name.equals("ul") || name.equals("ol") || name.equals("li") || name.equals("th") || name.equals("tr") || name.equals("td") || name.equals("pre")) {
            resultBuffer.append('\n');
        }
        resultBuffer.append('<');
        resultBuffer.append(name);
        Map<String, String> tagAtttributes = node.getAttributes();
        for (Map.Entry<String, String> currEntry : tagAtttributes.entrySet()) {
            String attName = currEntry.getKey();
            if (attName.length() < 1 || !Character.isLetter(attName.charAt(0))) continue;
            String attValue = currEntry.getValue();
            resultBuffer.append(" ");
            resultBuffer.append(attName);
            resultBuffer.append("=\"");
            resultBuffer.append(attValue);
            resultBuffer.append("\"");
        }
        List<Object> children = node.getChildren();
        if (children.size() == 0 && !name.equals("a")) {
            resultBuffer.append(" />");
        } else {
            resultBuffer.append('>');
            if (children.size() != 0) {
                this.nodesToText((List<? extends Object>)children, resultBuffer, model);
            }
            resultBuffer.append("</");
            resultBuffer.append(node.getName());
            resultBuffer.append('>');
        }
    }

    @Override
    public void imageNodeToText(TagNode imageTagNode, ImageFormat imageFormat, Appendable resultBuffer, IWikiModel model) throws IOException {
        Map<String, String> map2 = imageTagNode.getAttributes();
        String caption = imageFormat.getCaption();
        String alt = null;
        if (caption != null && caption.length() > 0) {
            alt = imageFormat.getAlt();
            caption = Utils.escapeXml(caption, true, false, true);
        }
        if (alt == null) {
            alt = "";
        }
        String location = imageFormat.getLocation();
        String type2 = imageFormat.getType();
        int pxWidth = imageFormat.getWidth();
        int pxHeight = imageFormat.getHeight();
        if ("thumb".equals(type2) || "frame".equals(type2)) {
            this.imageThumbToHTML(imageTagNode, resultBuffer, model, map2, caption, alt, location, type2, pxWidth, pxHeight);
        } else {
            this.imageSimpleToHTML(imageTagNode, resultBuffer, model, map2, caption, alt, location, type2, pxWidth, pxHeight);
        }
    }

    private void imageThumbToHTML(TagNode imageTagNode, Appendable resultBuffer, IWikiModel model, Map<String, String> map2, String caption, String alt, String location, String type2, int pxWidth, int pxHeight) throws IOException {
        List<Object> children;
        String href;
        boolean hasDimensions;
        resultBuffer.append("\n<div class=\"thumb ");
        if ("left".equals(location)) {
            resultBuffer.append("tleft\"");
        } else if ("right".equals(location)) {
            resultBuffer.append("tright\"");
        } else {
            resultBuffer.append("tright\"");
        }
        resultBuffer.append('>');
        boolean bl = hasDimensions = pxHeight != -1 || pxWidth != -1;
        if (hasDimensions) {
            int pxWidthThumbinner = pxWidth;
            if ("thumb".equals(type2)) {
                pxWidthThumbinner += 2;
                resultBuffer.append("\n<div class=\"thumbinner\" style=\"");
            } else {
                resultBuffer.append("<div style=\"");
            }
            if (pxHeight != -1) {
                resultBuffer.append("height:").append(Integer.toString(pxHeight)).append("px;");
            }
            if (pxWidth != -1) {
                resultBuffer.append("width:").append(Integer.toString(pxWidthThumbinner)).append("px;");
            }
            resultBuffer.append("\">");
        }
        if ((href = map2.get("href")) != null) {
            resultBuffer.append("<a class=\"internal\" href=\"").append(href).append("\" ");
            if (caption != null && caption.length() > 0) {
                resultBuffer.append("title=\"").append(alt.length() == 0 ? caption : alt).append('\"');
            }
            resultBuffer.append('>');
        }
        resultBuffer.append("<img src=\"").append(map2.get("src")).append('\"');
        if (caption != null && caption.length() > 0) {
            if (alt.length() == 0) {
                resultBuffer.append(" alt=\"").append(caption).append('\"').append(" title=\"").append(caption).append('\"');
            } else {
                resultBuffer.append(" alt=\"").append(alt).append('\"').append(" title=\"").append(alt).append('\"');
            }
        }
        StringBuilder clazz = null;
        if (location != null && !location.equalsIgnoreCase("none")) {
            clazz = new StringBuilder(64);
            clazz.append(" class=\"location-");
            clazz.append(location);
        }
        if (type2 != null) {
            if (clazz == null) {
                clazz = new StringBuilder(64);
                clazz.append(" class=\"");
            } else {
                clazz.append(" ");
            }
            clazz.append("type-").append(type2);
        }
        if (clazz != null) {
            resultBuffer.append(clazz).append('\"');
        }
        if (pxHeight != -1) {
            resultBuffer.append(" height=\"").append(Integer.toString(pxHeight)).append('\"');
        }
        if (pxWidth != -1) {
            resultBuffer.append(" width=\"").append(Integer.toString(pxWidth)).append('\"');
        }
        resultBuffer.append(" />\n");
        if (href != null) {
            resultBuffer.append("</a>");
        }
        if ((children = imageTagNode.getChildren()).size() != 0) {
            this.nodesToText((List<? extends Object>)children, resultBuffer, model);
        }
        if (hasDimensions) {
            resultBuffer.append("</div>\n");
        }
        resultBuffer.append("</div>\n");
    }

    private void imageSimpleToHTML(TagNode imageTagNode, Appendable resultBuffer, IWikiModel model, Map<String, String> map2, String caption, String alt, String location, String type2, int pxWidth, int pxHeight) throws IOException {
        List<Object> children;
        String href = map2.get("href");
        if (href != null) {
            resultBuffer.append("<a class=\"image\" href=\"").append(href).append("\" ");
            if (caption != null && caption.length() > 0) {
                resultBuffer.append("title=\"").append(alt.length() == 0 ? caption : alt).append('\"');
            }
            resultBuffer.append('>');
        }
        resultBuffer.append("<img src=\"").append(map2.get("src")).append('\"');
        if (caption != null && caption.length() > 0) {
            if (alt.length() == 0) {
                resultBuffer.append(" alt=\"").append(caption).append('\"');
            } else {
                resultBuffer.append(" alt=\"").append(alt).append('\"');
            }
        }
        StringBuilder clazz = null;
        if (location != null && !location.equalsIgnoreCase("none")) {
            clazz = new StringBuilder(64);
            clazz.append(" class=\"location-");
            clazz.append(location);
        }
        if (type2 != null) {
            if (clazz == null) {
                clazz = new StringBuilder(64);
                clazz.append(" class=\"");
            } else {
                clazz.append(" ");
            }
            clazz.append(" type-").append(type2);
        }
        if (clazz != null) {
            resultBuffer.append(clazz).append('\"');
        }
        if (pxHeight != -1) {
            resultBuffer.append(" height=\"").append(Integer.toString(pxHeight)).append('\"');
        }
        if (pxWidth != -1) {
            resultBuffer.append(" width=\"").append(Integer.toString(pxWidth)).append('\"');
        }
        resultBuffer.append(" />\n");
        if (href != null) {
            resultBuffer.append("</a>");
        }
        if ((children = imageTagNode.getChildren()).size() != 0) {
            this.nodesToText((List<? extends Object>)children, resultBuffer, model);
        }
    }

    @Override
    public boolean renderLinks() {
        return this.renderLinks;
    }
}

