/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.transform.impl;

import club.sk1er.mods.scrollabletooltips.transform.TooltipsTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class GuiUtilsTransformer
implements TooltipsTransformer {
    @Override
    public String[] getClassNames() {
        return new String[]{"net.minecraftforge.fml.client.config.GuiUtils"};
    }

    @Override
    public void transform(ClassNode classNode, String name) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("drawHoveringText")) continue;
            int tooltipYIndex = -1;
            int tooltipHeightIndex = -1;
            for (LocalVariableNode variable : method.localVariables) {
                if (variable.name.equals("tooltipY")) {
                    tooltipYIndex = variable.index;
                    continue;
                }
                if (!variable.name.equals("tooltipHeight")) continue;
                tooltipHeightIndex = variable.index;
            }
            for (AbstractInsnNode next : method.instructions) {
                String methodInsnName;
                if (next instanceof IntInsnNode && ((IntInsnNode)next).operand == 300 && next.getNext().getOpcode() == 54) {
                    method.instructions.insertBefore(next, this.addScrollFunctionality(tooltipYIndex, tooltipHeightIndex));
                    continue;
                }
                if (!(next instanceof MethodInsnNode) || next.getOpcode() != 184 || !(methodInsnName = this.mapMethodNameFromNode(next)).equals("enableRescaleNormal") && !methodInsnName.equals("func_179091_B")) continue;
                method.instructions.insert(next, (AbstractInsnNode)new MethodInsnNode(184, "net/minecraft/client/renderer/GlStateManager", "func_179121_F", "()V", false));
            }
        }
    }

    private InsnList addScrollFunctionality(int tooltipYIndex, int tooltipHeightIndex) {
        InsnList insnList = new InsnList();
        insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
        insnList.add((AbstractInsnNode)new VarInsnNode(21, 4));
        insnList.add((AbstractInsnNode)new VarInsnNode(21, tooltipYIndex));
        insnList.add((AbstractInsnNode)new VarInsnNode(21, tooltipHeightIndex));
        insnList.add((AbstractInsnNode)new MethodInsnNode(184, "club/sk1er/mods/scrollabletooltips/GuiUtilsOverride", "drawHoveringText", "(Ljava/util/List;III)V", false));
        return insnList;
    }
}

