/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.scrollabletooltips.forge;

import club.sk1er.mods.scrollabletooltips.transform.TooltipsTransformer;
import club.sk1er.mods.scrollabletooltips.transform.impl.GuiUtilsTransformer;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public final class ClassTransformer
implements IClassTransformer {
    private final Logger logger = LogManager.getLogger((String)"Tooltips Transformer");
    private final Multimap<String, TooltipsTransformer> transformerMap = ArrayListMultimap.create();
    public final boolean outputBytecode = Boolean.parseBoolean(System.getProperty("debugBytecode", "false"));

    public ClassTransformer() {
        this.registerTransformer(new GuiUtilsTransformer());
    }

    private void registerTransformer(TooltipsTransformer transformer) {
        for (String cls : transformer.getClassNames()) {
            this.transformerMap.put((Object)cls, (Object)transformer);
        }
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Collection transformers = this.transformerMap.get((Object)transformedName);
        if (transformers.isEmpty()) {
            return bytes;
        }
        this.logger.info("Found {} transformers for {}", new Object[]{transformers.size(), transformedName});
        ClassReader classReader = new ClassReader(bytes);
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        for (TooltipsTransformer transformer : transformers) {
            this.logger.info("Applying transformer {} on {}...", new Object[]{transformer.getClass().getName(), transformedName});
            transformer.transform(classNode, transformedName);
        }
        ClassWriter classWriter = new ClassWriter(3);
        try {
            classNode.accept((ClassVisitor)classWriter);
        }
        catch (Throwable e) {
            this.logger.error("Exception when transforming {} : {}", new Object[]{transformedName, e.getClass().getSimpleName(), e});
        }
        if (this.outputBytecode) {
            File bytecodeDirectory = new File("bytecode");
            String transformedClassName = transformedName.contains("$") ? transformedName.replace('$', '.') + ".class" : transformedName + ".class";
            File bytecodeOutput = new File(bytecodeDirectory, transformedClassName);
            try (FileOutputStream os = new FileOutputStream(bytecodeOutput);){
                os.write(classWriter.toByteArray());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return classWriter.toByteArray();
    }
}

