/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.util.Strings;

public class PGPLiteralDataGenerator
implements StreamGenerator {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = PGPLiteralData.NOW;
    private BCPGOutputStream pkOut;
    private boolean oldFormat = false;

    public PGPLiteralDataGenerator() {
    }

    public PGPLiteralDataGenerator(boolean bl) {
        this.oldFormat = bl;
    }

    private void writeHeader(OutputStream outputStream2, char c, byte[] byArray, long l) throws IOException {
        outputStream2.write(c);
        outputStream2.write((byte)byArray.length);
        for (int i = 0; i != byArray.length; ++i) {
            outputStream2.write(byArray[i]);
        }
        long l2 = l / 1000L;
        outputStream2.write((byte)(l2 >> 24));
        outputStream2.write((byte)(l2 >> 16));
        outputStream2.write((byte)(l2 >> 8));
        outputStream2.write((byte)l2);
    }

    public OutputStream open(OutputStream outputStream2, char c, String string, long l, Date date) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        byte[] byArray = Strings.toUTF8ByteArray((String)string);
        this.pkOut = new BCPGOutputStream(outputStream2, 11, l + 2L + (long)byArray.length + 4L, this.oldFormat);
        this.writeHeader(this.pkOut, c, byArray, date.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream outputStream2, char c, String string, Date date, byte[] byArray) throws IOException {
        if (this.pkOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        this.pkOut = new BCPGOutputStream(outputStream2, 11, byArray);
        byte[] byArray2 = Strings.toUTF8ByteArray((String)string);
        this.writeHeader(this.pkOut, c, byArray2, date.getTime());
        return new WrappedGeneratorStream(this.pkOut, this);
    }

    public OutputStream open(OutputStream outputStream2, char c, File file2) throws IOException {
        return this.open(outputStream2, c, file2.getName(), file2.length(), new Date(file2.lastModified()));
    }

    @Override
    public void close() throws IOException {
        if (this.pkOut != null) {
            this.pkOut.finish();
            this.pkOut.flush();
            this.pkOut = null;
        }
    }
}

