/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.LiteralDataPacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.openpgp.Util;

public class PGPLiteralData {
    public static final char BINARY = 'b';
    public static final char TEXT = 't';
    public static final char UTF8 = 'u';
    public static final char MIME = 'm';
    public static final String CONSOLE = "_CONSOLE";
    public static final Date NOW = new Date(0L);
    LiteralDataPacket data;

    public PGPLiteralData(byte[] byArray) throws IOException {
        this(Util.createBCPGInputStream(new ByteArrayInputStream(byArray), 11));
    }

    public PGPLiteralData(InputStream inputStream2) throws IOException {
        this(Util.createBCPGInputStream(inputStream2, 11));
    }

    public PGPLiteralData(BCPGInputStream bCPGInputStream) throws IOException {
        Packet packet2 = bCPGInputStream.readPacket();
        if (!(packet2 instanceof LiteralDataPacket)) {
            throw new IOException("unexpected packet in stream: " + packet2);
        }
        this.data = (LiteralDataPacket)packet2;
    }

    public int getFormat() {
        return this.data.getFormat();
    }

    public String getFileName() {
        return this.data.getFileName();
    }

    public byte[] getRawFileName() {
        return this.data.getRawFileName();
    }

    public Date getModificationTime() {
        return new Date(this.data.getModificationTime());
    }

    public InputStream getInputStream() {
        return this.data.getInputStream();
    }

    public InputStream getDataStream() {
        return this.getInputStream();
    }
}

