/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.vigilance.impl.nightconfig.core.io;

import gg.skytils.vigilance.impl.nightconfig.core.UnmodifiableConfig;
import gg.skytils.vigilance.impl.nightconfig.core.io.CharsWrapper;
import gg.skytils.vigilance.impl.nightconfig.core.io.WritingException;
import gg.skytils.vigilance.impl.nightconfig.core.io.WritingMode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public interface ConfigWriter {
    public void write(UnmodifiableConfig var1, Writer var2);

    default public void write(UnmodifiableConfig config2, OutputStream output2, Charset charset) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output2, charset));
        this.write(config2, writer);
        try {
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new WritingException("Failed to flush the writer", e);
        }
    }

    default public void write(UnmodifiableConfig config2, OutputStream output2) {
        this.write(config2, output2, StandardCharsets.UTF_8);
    }

    default public void write(UnmodifiableConfig config2, Path file2, WritingMode writingMode) {
        this.write(config2, file2, writingMode, StandardCharsets.UTF_8);
    }

    default public void write(UnmodifiableConfig config2, Path file2, WritingMode writingMode, Charset charset) {
        OpenOption[] options2 = writingMode == WritingMode.APPEND ? new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND} : new StandardOpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        try (OutputStream output2 = Files.newOutputStream(file2, options2);){
            this.write(config2, output2, charset);
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    default public void write(UnmodifiableConfig config2, File file2, WritingMode writingMode) {
        this.write(config2, file2, writingMode, StandardCharsets.UTF_8);
    }

    default public void write(UnmodifiableConfig config2, File file2, WritingMode writingMode, Charset charset) {
        this.write(config2, file2.toPath(), writingMode, charset);
    }

    default public void write(UnmodifiableConfig config2, URL url2) {
        URLConnection connection;
        try {
            connection = url2.openConnection();
        }
        catch (IOException e) {
            throw new WritingException("Unable to connect to the URL", e);
        }
        String encoding = connection.getContentEncoding();
        Charset charset = encoding == null ? StandardCharsets.UTF_8 : Charset.forName(encoding);
        try (OutputStream output2 = connection.getOutputStream();){
            this.write(config2, output2, charset);
        }
        catch (IOException e) {
            throw new WritingException("An I/O error occured", e);
        }
    }

    default public String writeToString(UnmodifiableConfig config2) {
        CharsWrapper.Builder builder = new CharsWrapper.Builder(64);
        this.write(config2, builder);
        return builder.toString();
    }
}

