/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils.graphics;

import gg.skytils.skytilsmod.utils.graphics.colors.CommonColors;
import gg.skytils.skytilsmod.utils.graphics.colors.CustomColor;
import gg.skytils.skytilsmod.utils.graphics.colors.MinecraftChatColors;
import java.awt.Color;
import java.util.Random;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001f !B\u0007\u00a2\u0006\u0004\b\u001d\u0010\u001eJ)\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ7\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J7\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011JE\u0010\u0015\u001a\u00020\b2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001c\u00a8\u0006\""}, d2={"Lgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer;", "Lnet/minecraft/client/gui/FontRenderer;", "", "text", "", "color", "Lgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$TextShadow;", "shadow", "", "drawChars", "(Ljava/lang/String;ILgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$TextShadow;)F", "input", "x", "y", "Lgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$TextAlignment;", "alignment", "drawCritText", "(Ljava/lang/String;FFLgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$TextAlignment;Lgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$TextShadow;)F", "drawRainbowText", "Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "customColor", "drawString", "(Ljava/lang/String;FFLgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;Lgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$TextAlignment;Lgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$TextShadow;)F", "", "ch", "", "italic", "renderChar", "(CZ)F", "<init>", "()V", "Companion", "TextAlignment", "TextShadow", "SkytilsMod"})
public final class SmartFontRenderer
extends FontRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int LINE_SPACING = 3;
    public static final int CHAR_SPACING = 0;
    public static final int CHAR_HEIGHT = 9;
    @NotNull
    private static final int[] minecraftColors = MinecraftChatColors.Companion.getSet().asInts();

    public SmartFontRenderer() {
        super(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("textures/font/ascii.png"), Minecraft.func_71410_x().func_110434_K(), false);
    }

    public final float drawString(@Nullable String text2, float x, float y, @NotNull CustomColor customColor, @NotNull TextAlignment alignment, @NotNull TextShadow shadow) {
        float f;
        Intrinsics.checkNotNullParameter(customColor, "customColor");
        Intrinsics.checkNotNullParameter((Object)alignment, "alignment");
        Intrinsics.checkNotNullParameter((Object)shadow, "shadow");
        if (text2 == null) {
            return 0.0f;
        }
        if (customColor == CommonColors.Companion.getRAINBOW()) {
            return this.drawRainbowText(text2, x, y, alignment, shadow);
        }
        if (customColor == CommonColors.Companion.getCRITICAL()) {
            return this.drawCritText(text2, x, y, alignment, shadow);
        }
        CharSequence charSequence = text2;
        Regex regex = new Regex("\u00a7\\[\\d+\\.?\\d*,\\d+\\.?\\d*,\\d+\\.?\\d*]");
        String string = "";
        String drawnText = regex.replace(charSequence, string);
        switch (WhenMappings.$EnumSwitchMapping$0[alignment.ordinal()]) {
            case 1: {
                f = this.drawString(text2, x - (float)this.func_78256_a(drawnText) / 2.0f, y, customColor, TextAlignment.LEFT_RIGHT, shadow);
                break;
            }
            case 2: {
                f = this.drawString(text2, x - (float)this.func_78256_a(drawnText), y, customColor, TextAlignment.LEFT_RIGHT, shadow);
                break;
            }
            default: {
                GlStateManager.func_179098_w();
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
                int colour = customColor.toInt();
                this.field_78295_j = x;
                this.field_78296_k = y;
                f = this.drawChars(text2, colour, shadow);
            }
        }
        return f;
    }

    public static /* synthetic */ float drawString$default(SmartFontRenderer smartFontRenderer, String string, float f, float f2, CustomColor customColor, TextAlignment textAlignment, TextShadow textShadow, int n, Object object) {
        if ((n & 8) != 0) {
            customColor = CommonColors.Companion.getWHITE();
        }
        if ((n & 0x10) != 0) {
            textAlignment = TextAlignment.LEFT_RIGHT;
        }
        if ((n & 0x20) != 0) {
            textShadow = TextShadow.NONE;
        }
        return smartFontRenderer.drawString(string, f, f2, customColor, textAlignment, textShadow);
    }

    private final float drawRainbowText(String input2, float x, float y, TextAlignment alignment, TextShadow shadow) {
        if (alignment == TextAlignment.MIDDLE) {
            return this.drawRainbowText(input2, x - (float)this.func_78256_a(input2) / 2.0f, y, TextAlignment.LEFT_RIGHT, shadow);
        }
        if (alignment == TextAlignment.RIGHT_LEFT) {
            return this.drawRainbowText(input2, x - (float)this.func_78256_a(input2), y, TextAlignment.LEFT_RIGHT, shadow);
        }
        this.field_78295_j = x;
        this.field_78296_k = y;
        char[] cArray = input2.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        for (char c : cArray) {
            long dif = (long)this.field_78295_j * (long)10 - (long)this.field_78296_k * (long)10;
            long time = System.currentTimeMillis() - dif;
            float z = 2000.0f;
            int color = Color.HSBtoRGB((float)(time % (long)((int)z)) / z, 0.8f, 0.8f);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float blue = (float)(color >> 8 & 0xFF) / 255.0f;
            float green = (float)(color & 0xFF) / 255.0f;
            float originPosX = this.field_78295_j;
            float originPosY = this.field_78296_k;
            float offset = this.func_82883_a() ? 0.5f : 1.0f;
            switch (WhenMappings.$EnumSwitchMapping$1[shadow.ordinal()]) {
                case 1: {
                    GlStateManager.func_179131_c((float)(red * 0.19999999f), (float)(green * 0.19999999f), (float)(blue * 0.19999999f), (float)1.0f);
                    this.field_78295_j = originPosX - offset;
                    this.field_78296_k = originPosY;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX + offset;
                    this.field_78296_k = originPosY;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX;
                    this.field_78296_k = originPosY - offset;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX;
                    this.field_78296_k = originPosY + offset;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX;
                    this.field_78296_k = originPosY;
                    break;
                }
                case 2: {
                    GlStateManager.func_179131_c((float)(red * 0.19999999f), (float)(green * 0.19999999f), (float)(blue * 0.19999999f), (float)1.0f);
                    this.field_78295_j = originPosX + offset;
                    this.field_78296_k = originPosY + offset;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX;
                    this.field_78296_k = originPosY;
                }
            }
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
            float charLength = SmartFontRenderer.renderChar$default(this, c, false, 2, null);
            this.field_78295_j += charLength + 0.0f;
        }
        return this.field_78295_j;
    }

    private final float drawCritText(String input2, float x, float y, TextAlignment alignment, TextShadow shadow) {
        if (alignment == TextAlignment.MIDDLE) {
            return this.drawCritText(input2, x - (float)this.func_78256_a(input2) / 2.0f, y, TextAlignment.LEFT_RIGHT, shadow);
        }
        if (alignment == TextAlignment.RIGHT_LEFT) {
            return this.drawCritText(input2, x - (float)this.func_78256_a(input2), y, TextAlignment.LEFT_RIGHT, shadow);
        }
        this.field_78295_j = x;
        this.field_78296_k = y;
        char[] cArray = input2.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        for (char c : cArray) {
            long dif = (long)this.field_78295_j * (long)10 - (long)this.field_78296_k * (long)10;
            long time = System.currentTimeMillis() - dif;
            float red = 1.0f;
            float blue = 0.33333334f;
            float green = (85.0f * (float)Math.cos((double)(time % (long)2000) * Math.PI / (double)1000) + (float)170) / 255.0f;
            float originPosX = this.field_78295_j;
            float originPosY = this.field_78296_k;
            float offset = this.func_82883_a() ? 0.5f : 1.0f;
            switch (WhenMappings.$EnumSwitchMapping$1[shadow.ordinal()]) {
                case 1: {
                    GlStateManager.func_179131_c((float)(red * 0.19999999f), (float)(green * 0.19999999f), (float)(blue * 0.19999999f), (float)1.0f);
                    this.field_78295_j = originPosX - offset;
                    this.field_78296_k = originPosY;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX + offset;
                    this.field_78296_k = originPosY;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX;
                    this.field_78296_k = originPosY - offset;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX;
                    this.field_78296_k = originPosY + offset;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX;
                    this.field_78296_k = originPosY;
                    break;
                }
                case 2: {
                    GlStateManager.func_179131_c((float)(red * 0.19999999f), (float)(green * 0.19999999f), (float)(blue * 0.19999999f), (float)1.0f);
                    this.field_78295_j = originPosX + offset;
                    this.field_78296_k = originPosY + offset;
                    SmartFontRenderer.renderChar$default(this, c, false, 2, null);
                    this.field_78295_j = originPosX;
                    this.field_78296_k = originPosY;
                }
            }
            GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)1.0f);
            float charLength = SmartFontRenderer.renderChar$default(this, c, false, 2, null);
            this.field_78295_j += charLength + 0.0f;
        }
        return this.field_78295_j;
    }

    private final float drawChars(String text2, int color, TextShadow shadow) {
        int color1 = color;
        if (((CharSequence)text2).length() == 0) {
            return 0.0f;
        }
        float textLength = 0.0f;
        boolean obfuscated = false;
        boolean italic = false;
        boolean bold = false;
        int index = 0;
        while (index < text2.length()) {
            String characters;
            if (text2.charAt(index) == '\u00a7' && index + 1 < text2.length()) {
                Integer detectedColor = null;
                detectedColor = SmartFontRenderer.Companion.decodeCommonColor(text2.charAt(index + 1));
                if (detectedColor == null) {
                    char c = text2.charAt(index + 1);
                    if (c == 'k') {
                        obfuscated = true;
                        ++index;
                    } else if (c == 'o') {
                        italic = true;
                        ++index;
                    } else if (c == 'l') {
                        bold = true;
                        ++index;
                    } else if (c == 'r') {
                        obfuscated = false;
                        italic = false;
                        bold = false;
                        detectedColor = 0xFFFFFF;
                        ++index;
                    }
                } else {
                    obfuscated = false;
                    italic = false;
                    bold = false;
                    ++index;
                }
                if (detectedColor != null) {
                    detectedColor = detectedColor & 0xFFFFFF;
                    detectedColor = detectedColor | color1 & 0xFF000000;
                    color1 = detectedColor;
                }
                ++index;
                continue;
            }
            char character = text2.charAt(index);
            if (obfuscated && StringsKt.contains$default((CharSequence)(characters = " !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u00a1\u00a3\u00aa\u00ab\u00ac\u00ae\u00b0\u00b1\u00b2\u00b7\u00ba\u00bb\u00bc\u00bd\u00bf\u00c0\u00c1\u00c2\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cd\u00d1\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00da\u00dc\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00ff\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0192\u0207\u0393\u0398\u03a3\u03a6\u03a9\u03b1\u03b2\u03b4\u03bc\u03c0\u03c3\u03c4\u207f\u2205\u2208\u2219\u221a\u221e\u2229\u2248\u2261\u2264\u2265\u2320\u2321\u2500\u2502\u250c\u2510\u2514\u2518\u251c\u2524\u252c\u2534\u253c\u2550\u2551\u2552\u2553\u2554\u2555\u2556\u2557\u2558\u2559\u255a\u255b\u255c\u255d\u255e\u255f\u2560\u2561\u2562\u2563\u2564\u2565\u2566\u2567\u2568\u2569\u256a\u256b\u256c\u2580\u2584\u2588\u258c\u2590\u2591\u2592\u2593\u25a0"), String.valueOf(character), false, 2, null)) {
                int width = this.func_78263_a(character);
                char newCharacter = '\u0000';
                while (width != this.func_78263_a(newCharacter = characters.charAt(new Random().nextInt(characters.length())))) {
                }
                character = newCharacter;
            }
            float x = this.field_78295_j;
            float y = this.field_78296_k;
            float offset = this.func_82883_a() ? 0.5f : 1.0f;
            float alpha = (float)(color1 >> 24 & 0xFF) / 255.0f;
            this.setColor(0.0f, 0.0f, 0.0f, alpha);
            TextShadow textShadow = shadow;
            switch (textShadow == null ? -1 : WhenMappings.$EnumSwitchMapping$1[textShadow.ordinal()]) {
                case 1: {
                    this.field_78295_j -= offset;
                    SmartFontRenderer.renderChar$default(this, character, false, 2, null);
                    this.field_78295_j += bold ? offset * (float)3 : offset * (float)2;
                    SmartFontRenderer.renderChar$default(this, character, false, 2, null);
                    for (int i = 0; i < (bold ? 2 : 1); ++i) {
                        this.field_78295_j -= offset;
                        this.field_78296_k -= offset;
                        SmartFontRenderer.renderChar$default(this, character, false, 2, null);
                        this.field_78296_k += offset * (float)2;
                        SmartFontRenderer.renderChar$default(this, character, false, 2, null);
                        this.field_78296_k -= offset;
                    }
                    break;
                }
                case 2: {
                    this.field_78296_k = y + offset;
                    for (int i = 0; i < (bold ? 2 : 1); ++i) {
                        this.field_78295_j += offset;
                        SmartFontRenderer.renderChar$default(this, character, false, 2, null);
                    }
                    break;
                }
            }
            this.field_78295_j = x;
            this.field_78296_k = y;
            float red = (float)(color1 >> 16 & 0xFF) / 255.0f;
            float green = (float)(color1 >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color1 & 0xFF) / 255.0f;
            this.setColor(red, green, blue, alpha);
            float charLength = this.renderChar(character, italic);
            if (bold) {
                this.field_78295_j += offset;
                SmartFontRenderer.renderChar$default(this, character, false, 2, null);
                this.field_78295_j -= offset;
                charLength += offset;
            }
            this.field_78295_j += charLength + 0.0f;
            textLength += charLength + 0.0f;
            ++index;
        }
        return textLength - 0.0f;
    }

    private final float renderChar(char ch, boolean italic) {
        int i;
        if (ch == '\u00a0') {
            return 4.0f;
        }
        return ch == ' ' ? 4.0f : ((i = StringsKt.indexOf$default((CharSequence)"\u00c0\u00c1\u00c2\u00c8\u00ca\u00cb\u00cd\u00d3\u00d4\u00d5\u00da\u00df\u00e3\u00f5\u011f\u0130\u0131\u0152\u0153\u015e\u015f\u0174\u0175\u017e\u0207\u0000\u0000\u0000\u0000\u0000\u0000\u0000 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u0000\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u03b2\u0393\u03c0\u03a3\u03c3\u03bc\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u2205\u2208\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u0000", ch, 0, false, 6, null)) != -1 && !this.func_82883_a() ? this.func_78266_a(i, italic) : this.func_78277_a(ch, italic));
    }

    static /* synthetic */ float renderChar$default(SmartFontRenderer smartFontRenderer, char c, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return smartFontRenderer.renderChar(c, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\bR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$Companion;", "", "", "character", "", "decodeCommonColor", "(C)Ljava/lang/Integer;", "CHAR_HEIGHT", "I", "CHAR_SPACING", "LINE_SPACING", "", "minecraftColors", "[I", "<init>", "()V", "SkytilsMod"})
    public static final class Companion {
        private Companion() {
        }

        private final Integer decodeCommonColor(char character) {
            boolean bl = '0' <= character ? character < ':' : false;
            if (bl) {
                return minecraftColors[character - 48];
            }
            boolean bl2 = 'a' <= character ? character < 'g' : false;
            if (bl2) {
                return minecraftColors[character + -87];
            }
            return ('A' <= character ? character < 'G' : false) ? Integer.valueOf(minecraftColors[character + -55]) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$TextAlignment;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT_RIGHT", "MIDDLE", "RIGHT_LEFT", "SkytilsMod"})
    public static final class TextAlignment
    extends Enum<TextAlignment> {
        public static final /* enum */ TextAlignment LEFT_RIGHT = new TextAlignment();
        public static final /* enum */ TextAlignment MIDDLE = new TextAlignment();
        public static final /* enum */ TextAlignment RIGHT_LEFT = new TextAlignment();
        private static final /* synthetic */ TextAlignment[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TextAlignment[] values() {
            return (TextAlignment[])$VALUES.clone();
        }

        public static TextAlignment valueOf(String value) {
            return Enum.valueOf(TextAlignment.class, value);
        }

        @NotNull
        public static EnumEntries<TextAlignment> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = textAlignmentArray = new TextAlignment[]{TextAlignment.LEFT_RIGHT, TextAlignment.MIDDLE, TextAlignment.RIGHT_LEFT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/SmartFontRenderer$TextShadow;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "NORMAL", "OUTLINE", "SkytilsMod"})
    public static final class TextShadow
    extends Enum<TextShadow> {
        public static final /* enum */ TextShadow NONE = new TextShadow();
        public static final /* enum */ TextShadow NORMAL = new TextShadow();
        public static final /* enum */ TextShadow OUTLINE = new TextShadow();
        private static final /* synthetic */ TextShadow[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static TextShadow[] values() {
            return (TextShadow[])$VALUES.clone();
        }

        public static TextShadow valueOf(String value) {
            return Enum.valueOf(TextShadow.class, value);
        }

        @NotNull
        public static EnumEntries<TextShadow> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = textShadowArray = new TextShadow[]{TextShadow.NONE, TextShadow.NORMAL, TextShadow.OUTLINE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TextAlignment.values().length];
            try {
                nArray[TextAlignment.MIDDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAlignment.RIGHT_LEFT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextShadow.values().length];
            try {
                nArray[TextShadow.OUTLINE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextShadow.NORMAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextShadow.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

