/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.utils;

import gg.skytils.mixinextras.lib.gson.Strictness;
import gg.skytils.mixinextras.lib.gson.stream.JsonReader;
import gg.skytils.mixinextras.lib.semver.Version;
import gg.skytils.mixinextras.service.MixinExtrasVersion;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.WeakHashMap;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.service.MixinService;

public class MixinConfigUtils {
    public static final String KEY_MIN_VERSION = "minMixinExtrasVersion";
    private static final Map<IMixinConfig, MixinExtrasVersion> MIN_CACHE = new WeakHashMap<IMixinConfig, MixinExtrasVersion>();

    public static MixinExtrasVersion minVersionFor(IMixinConfig config2) {
        return MIN_CACHE.computeIfAbsent(config2, k -> {
            Version min = MixinConfigUtils.readMin(config2);
            MixinExtrasVersion[] versions = MixinExtrasVersion.values();
            if (min == null) {
                return versions[0];
            }
            if (min.isHigherThan(MixinExtrasVersion.LATEST.getSemver())) {
                throw new IllegalArgumentException(String.format("Mixin Config %s requires MixinExtras >=%s but %s is present!", new Object[]{config2.getName(), min, MixinExtrasVersion.LATEST}));
            }
            MixinExtrasVersion result2 = versions[0];
            for (MixinExtrasVersion version2 : versions) {
                if (version2.getSemver().isHigherThan(min)) break;
                result2 = version2;
            }
            return result2;
        });
    }

    private static Version readMin(IMixinConfig config2) {
        return MixinConfigUtils.readConfig(config2, reader -> {
            reader.beginObject();
            while (reader.hasNext()) {
                String key2 = reader.nextName();
                if (key2.equals(KEY_MIN_VERSION)) {
                    String ver = reader.nextString();
                    return Version.tryParse(ver).orElseThrow(() -> new IllegalArgumentException(String.format("'%s' is not valid SemVer!", ver)));
                }
                reader.skipValue();
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T readConfig(IMixinConfig config2, JsonProcessor<T> compute) {
        try (JsonReader reader = new JsonReader(new InputStreamReader(MixinService.getService().getResourceAsStream(config2.getName())));){
            reader.setStrictness(Strictness.LENIENT);
            T t = compute.process(reader);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read mixin config " + config2.getName(), e);
        }
    }

    @FunctionalInterface
    private static interface JsonProcessor<T> {
        public T process(JsonReader var1) throws IOException;
    }
}

