/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.expression.impl.ast.expressions;

import gg.skytils.mixinextras.expression.impl.ExpressionSource;
import gg.skytils.mixinextras.expression.impl.flow.FlowValue;
import gg.skytils.mixinextras.expression.impl.point.ExpressionContext;
import org.objectweb.asm.tree.AbstractInsnNode;

public abstract class Expression {
    protected final ExpressionSource src;

    public Expression(ExpressionSource src) {
        this.src = src;
    }

    public ExpressionSource getSrc() {
        return this.src;
    }

    public boolean matches(FlowValue node, ExpressionContext ctx) {
        return false;
    }

    protected void capture(FlowValue node, ExpressionContext ctx) {
        ctx.capture(node, this);
    }

    protected static boolean inputsMatch(FlowValue node, ExpressionContext ctx, Expression ... values2) {
        return Expression.inputsMatch(node, ctx, false, values2);
    }

    protected static boolean inputsMatch(FlowValue node, ExpressionContext ctx, boolean allowIncomplete, Expression ... values2) {
        return Expression.inputsMatch(0, node, ctx, allowIncomplete, values2);
    }

    protected static boolean inputsMatch(int start2, FlowValue node, ExpressionContext ctx, Expression ... values2) {
        return Expression.inputsMatch(start2, node, ctx, false, values2);
    }

    protected static boolean inputsMatch(int start2, FlowValue node, ExpressionContext ctx, boolean allowIncomplete, Expression ... values2) {
        int required = node.inputCount() - start2;
        if (!(allowIncomplete && values2.length < required || values2.length == required)) {
            return false;
        }
        for (int i = 0; i < values2.length; ++i) {
            Expression value = values2[i];
            if (value.matches(node.getInput(i + start2), ctx)) continue;
            return false;
        }
        return true;
    }

    public static interface OutputSink {
        public void capture(FlowValue var1, Expression var2, ExpressionContext var3);

        public void decorate(AbstractInsnNode var1, String var2, Object var3);

        public void decorateInjectorSpecific(AbstractInsnNode var1, String var2, Object var3);
    }
}

