/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.protobuf.internal;

import gg.skytils.ktx-serialization.SerializationException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0011\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u001e\u001a\u00020\u000b\u0012\b\b\u0002\u0010\"\u001a\u00020\u0002\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\nJ\u000f\u0010\u0013\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0013\u0010\nJ\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u0014\u0010\"\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010#\u00a8\u0006'"}, d2={"Lgg/skytils/ktx-serialization/protobuf/internal/ByteArrayInput;", "", "", "bytesCount", "", "ensureEnoughBytes", "(I)V", "eof", "()V", "read", "()I", "", "readExactNBytes", "(I)[B", "length", "", "readString", "(I)Ljava/lang/String;", "readVarint32", "readVarint32SlowPath", "", "eofAllowed", "", "readVarint64", "(Z)J", "readVarint64SlowPath", "()J", "size", "slice", "(I)Lgg/skytils/ktx-serialization/protobuf/internal/ByteArrayInput;", "array", "[B", "getAvailableBytes", "availableBytes", "endIndex", "I", "position", "<init>", "([BI)V", "kotlinx-serialization-protobuf"})
public final class ByteArrayInput {
    @NotNull
    private byte[] array;
    private final int endIndex;
    private int position;

    public ByteArrayInput(@NotNull byte[] array, int endIndex) {
        Intrinsics.checkNotNullParameter(array, "array");
        this.array = array;
        this.endIndex = endIndex;
    }

    public /* synthetic */ ByteArrayInput(byte[] byArray, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = byArray.length;
        }
        this(byArray, n);
    }

    public final int getAvailableBytes() {
        return this.endIndex - this.position;
    }

    @NotNull
    public final ByteArrayInput slice(int size2) {
        this.ensureEnoughBytes(size2);
        ByteArrayInput result2 = new ByteArrayInput(this.array, this.position + size2);
        result2.position = this.position;
        this.position += size2;
        return result2;
    }

    public final int read() {
        int n;
        if (this.position < this.endIndex) {
            int n2 = this.position;
            this.position = n2 + 1;
            n = this.array[n2] & 0xFF;
        } else {
            n = -1;
        }
        return n;
    }

    @NotNull
    public final byte[] readExactNBytes(int bytesCount) {
        this.ensureEnoughBytes(bytesCount);
        byte[] b = new byte[bytesCount];
        int length = b.length;
        int copied2 = this.endIndex - this.position < length ? this.endIndex - this.position : length;
        ArraysKt.copyInto(this.array, b, 0, this.position, this.position + copied2);
        this.position += copied2;
        return b;
    }

    private final void ensureEnoughBytes(int bytesCount) {
        if (bytesCount > this.getAvailableBytes()) {
            throw new SerializationException("Unexpected EOF, available " + this.getAvailableBytes() + " bytes, requested: " + bytesCount);
        }
    }

    @NotNull
    public final String readString(int length) {
        String result2 = StringsKt.decodeToString$default(this.array, this.position, this.position + length, false, 4, null);
        this.position += length;
        return result2;
    }

    public final int readVarint32() {
        int result2;
        if (this.position == this.endIndex) {
            this.eof();
        }
        int currentPosition = this.position;
        if ((result2 = this.array[currentPosition++]) >= 0) {
            this.position = currentPosition;
            return result2;
        }
        if (this.endIndex - this.position > 1 && (result2 ^= this.array[currentPosition++] << 7) < 0) {
            this.position = currentPosition;
            return result2 ^ 0xFFFFFF80;
        }
        return this.readVarint32SlowPath();
    }

    public final long readVarint64(boolean eofAllowed) {
        long result2;
        if (this.position == this.endIndex) {
            if (eofAllowed) {
                return -1L;
            }
            this.eof();
        }
        int currentPosition = this.position;
        if ((result2 = (long)this.array[currentPosition++]) >= 0L) {
            this.position = currentPosition;
            return result2;
        }
        if (this.endIndex - this.position > 1 && (result2 ^= (long)this.array[currentPosition++] << 7) < 0L) {
            this.position = currentPosition;
            return result2 ^ 0xFFFFFFFFFFFFFF80L;
        }
        return this.readVarint64SlowPath();
    }

    private final void eof() {
        throw new SerializationException("Unexpected EOF");
    }

    private final long readVarint64SlowPath() {
        long result2 = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            int n = this.read();
            result2 |= (long)(n & 0x7F) << shift;
            if ((n & 0x80) != 0) continue;
            return result2;
        }
        throw new SerializationException("Input stream is malformed: Varint too long (exceeded 64 bits)");
    }

    private final int readVarint32SlowPath() {
        int result2 = 0;
        for (int shift = 0; shift < 32; shift += 7) {
            int n = this.read();
            result2 |= (n & 0x7F) << shift;
            if ((n & 0x80) != 0) continue;
            return result2;
        }
        throw new SerializationException("Input stream is malformed: Varint too long (exceeded 32 bits)");
    }
}

