/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.sessions;

import gg.skytils.ktor.server.sessions.SessionTransportTransformer;
import gg.skytils.ktor.util.CryptoKt;
import java.nio.charset.Charset;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 62\u00020\u0001:\u00016BR\b\u0016\u0012\u0006\u00101\u001a\u00020\u0002\u0012\u0006\u00102\u001a\u00020\u0002\u0012#\b\u0002\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u00020%\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0011\u0012\b\b\u0002\u0010-\u001a\u00020\u0011\u00a2\u0006\u0004\b3\u00104BP\u0012\u0006\u0010!\u001a\u00020 \u0012\u0006\u0010/\u001a\u00020 \u0012#\b\u0002\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u00020%\u0012\b\b\u0002\u0010\u0019\u001a\u00020\u0011\u0012\b\b\u0002\u0010-\u001a\u00020\u0011\u00a2\u0006\u0004\b3\u00105J\u001f\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\b\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\u0006J'\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0017\u0010!\u001a\u00020 8\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R2\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b&\u0012\b\b'\u0012\u0004\b\b((\u0012\u0004\u0012\u00020\u00020%8\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R\u0017\u0010-\u001a\u00020\u00118\u0006\u00a2\u0006\f\n\u0004\b-\u0010\u001a\u001a\u0004\b.\u0010\u001cR\u0017\u0010/\u001a\u00020 8\u0006\u00a2\u0006\f\n\u0004\b/\u0010\"\u001a\u0004\b0\u0010$\u00a8\u00067"}, d2={"Lgg/skytils/ktor/server/sessions/SessionTransportTransformerEncrypt;", "Lgg/skytils/ktor/server/sessions/SessionTransportTransformer;", "", "initVector", "encrypted", "decrypt", "([B[B)[B", "decrypted", "encrypt", "", "mode", "input", "encryptDecrypt", "(I[B[B)[B", "value", "mac", "([B)[B", "", "transportValue", "transformRead", "(Ljava/lang/String;)Ljava/lang/String;", "transformWrite", "Ljava/nio/charset/Charset;", "charset", "Ljava/nio/charset/Charset;", "encryptAlgorithm", "Ljava/lang/String;", "getEncryptAlgorithm", "()Ljava/lang/String;", "getEncryptionKeySize", "()I", "encryptionKeySize", "Ljavax/crypto/spec/SecretKeySpec;", "encryptionKeySpec", "Ljavax/crypto/spec/SecretKeySpec;", "getEncryptionKeySpec", "()Ljavax/crypto/spec/SecretKeySpec;", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "size", "ivGenerator", "Lkotlin/jvm/functions/Function1;", "getIvGenerator", "()Lkotlin/jvm/functions/Function1;", "signAlgorithm", "getSignAlgorithm", "signKeySpec", "getSignKeySpec", "encryptionKey", "signKey", "<init>", "([B[BLkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;)V", "(Ljavax/crypto/spec/SecretKeySpec;Ljavax/crypto/spec/SecretKeySpec;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;)V", "Companion", "ktor-server-sessions"})
public final class SessionTransportTransformerEncrypt
implements SessionTransportTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SecretKeySpec encryptionKeySpec;
    @NotNull
    private final SecretKeySpec signKeySpec;
    @NotNull
    private final Function1<Integer, byte[]> ivGenerator;
    @NotNull
    private final String encryptAlgorithm;
    @NotNull
    private final String signAlgorithm;
    @NotNull
    private final Charset charset;
    private static final Logger log = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(SessionTransportTransformerEncrypt.class).getQualifiedName());

    public SessionTransportTransformerEncrypt(@NotNull SecretKeySpec encryptionKeySpec, @NotNull SecretKeySpec signKeySpec, @NotNull Function1<? super Integer, byte[]> ivGenerator, @NotNull String encryptAlgorithm, @NotNull String signAlgorithm) {
        Intrinsics.checkNotNullParameter(encryptionKeySpec, "encryptionKeySpec");
        Intrinsics.checkNotNullParameter(signKeySpec, "signKeySpec");
        Intrinsics.checkNotNullParameter(ivGenerator, "ivGenerator");
        Intrinsics.checkNotNullParameter(encryptAlgorithm, "encryptAlgorithm");
        Intrinsics.checkNotNullParameter(signAlgorithm, "signAlgorithm");
        this.encryptionKeySpec = encryptionKeySpec;
        this.signKeySpec = signKeySpec;
        this.ivGenerator = ivGenerator;
        this.encryptAlgorithm = encryptAlgorithm;
        this.signAlgorithm = signAlgorithm;
        this.charset = Charsets.UTF_8;
        this.encrypt(this.ivGenerator.invoke(this.getEncryptionKeySize()), new byte[0]);
        this.mac(new byte[0]);
    }

    public /* synthetic */ SessionTransportTransformerEncrypt(SecretKeySpec secretKeySpec, SecretKeySpec secretKeySpec2, Function1 function1, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        if ((n & 8) != 0) {
            String string3 = secretKeySpec.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue(string3, "encryptionKeySpec.algorithm");
            string = string3;
        }
        if ((n & 0x10) != 0) {
            String string4 = secretKeySpec2.getAlgorithm();
            Intrinsics.checkNotNullExpressionValue(string4, "signKeySpec.algorithm");
            string2 = string4;
        }
        this(secretKeySpec, secretKeySpec2, (Function1<? super Integer, byte[]>)function1, string, string2);
    }

    @NotNull
    public final SecretKeySpec getEncryptionKeySpec() {
        return this.encryptionKeySpec;
    }

    @NotNull
    public final SecretKeySpec getSignKeySpec() {
        return this.signKeySpec;
    }

    @NotNull
    public final Function1<Integer, byte[]> getIvGenerator() {
        return this.ivGenerator;
    }

    @NotNull
    public final String getEncryptAlgorithm() {
        return this.encryptAlgorithm;
    }

    @NotNull
    public final String getSignAlgorithm() {
        return this.signAlgorithm;
    }

    public final int getEncryptionKeySize() {
        return this.encryptionKeySpec.getEncoded().length;
    }

    public SessionTransportTransformerEncrypt(@NotNull byte[] encryptionKey, @NotNull byte[] signKey, @NotNull Function1<? super Integer, byte[]> ivGenerator, @NotNull String encryptAlgorithm, @NotNull String signAlgorithm) {
        Intrinsics.checkNotNullParameter(encryptionKey, "encryptionKey");
        Intrinsics.checkNotNullParameter(signKey, "signKey");
        Intrinsics.checkNotNullParameter(ivGenerator, "ivGenerator");
        Intrinsics.checkNotNullParameter(encryptAlgorithm, "encryptAlgorithm");
        Intrinsics.checkNotNullParameter(signAlgorithm, "signAlgorithm");
        this(new SecretKeySpec(encryptionKey, encryptAlgorithm), new SecretKeySpec(signKey, signAlgorithm), ivGenerator, null, null, 24, null);
    }

    public /* synthetic */ SessionTransportTransformerEncrypt(byte[] byArray, byte[] byArray2, Function1 function1, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 2.INSTANCE;
        }
        if ((n & 8) != 0) {
            string = "AES";
        }
        if ((n & 0x10) != 0) {
            string2 = "HmacSHA256";
        }
        this(byArray, byArray2, (Function1<? super Integer, byte[]>)function1, string, string2);
    }

    @Override
    @Nullable
    public String transformRead(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter(transportValue, "transportValue");
        try {
            String encryptedMac = StringsKt.substringAfterLast(transportValue, '/', "");
            byte[] iv = CryptoKt.hex(StringsKt.substringBeforeLast$default(transportValue, '/', null, 2, null));
            byte[] encrypted = CryptoKt.hex(StringsKt.substringBeforeLast$default(encryptedMac, ':', null, 2, null));
            String macHex = StringsKt.substringAfterLast(encryptedMac, ':', "");
            byte[] decrypted = this.decrypt(iv, encrypted);
            if (!Intrinsics.areEqual(CryptoKt.hex(this.mac(decrypted)), macHex)) {
                return null;
            }
            return new String(decrypted, this.charset);
        }
        catch (Throwable e) {
            if (log.isDebugEnabled()) {
                log.debug(e.toString());
            }
            return null;
        }
    }

    @Override
    @NotNull
    public String transformWrite(@NotNull String transportValue) {
        Intrinsics.checkNotNullParameter(transportValue, "transportValue");
        byte[] iv = this.ivGenerator.invoke(this.getEncryptionKeySize());
        byte[] byArray = transportValue.getBytes(this.charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] decrypted = byArray;
        byte[] encrypted = this.encrypt(iv, decrypted);
        byte[] mac = this.mac(decrypted);
        return CryptoKt.hex(iv) + '/' + CryptoKt.hex(encrypted) + ':' + CryptoKt.hex(mac);
    }

    private final byte[] encrypt(byte[] initVector, byte[] decrypted) {
        return this.encryptDecrypt(1, initVector, decrypted);
    }

    private final byte[] decrypt(byte[] initVector, byte[] encrypted) {
        return this.encryptDecrypt(2, initVector, encrypted);
    }

    private final byte[] encryptDecrypt(int mode, byte[] initVector, byte[] input2) {
        IvParameterSpec iv = new IvParameterSpec(initVector);
        Cipher cipher2 = Cipher.getInstance(this.encryptAlgorithm + "/CBC/PKCS5PADDING");
        cipher2.init(mode, (Key)this.encryptionKeySpec, iv);
        byte[] byArray = cipher2.doFinal(input2);
        Intrinsics.checkNotNullExpressionValue(byArray, "cipher.doFinal(input)");
        return byArray;
    }

    private final byte[] mac(byte[] value) {
        Mac $this$mac_u24lambda_u240 = Mac.getInstance(this.signAlgorithm);
        boolean bl = false;
        $this$mac_u24lambda_u240.init(this.signKeySpec);
        byte[] byArray = $this$mac_u24lambda_u240.doFinal(value);
        Intrinsics.checkNotNullExpressionValue(byArray, "getInstance(signAlgorith\u2026     doFinal(value)\n    }");
        return byArray;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001c\u0010\u0004\u001a\n \u0003*\u0004\u0018\u00010\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0005\u00a8\u0006\b"}, d2={"Lgg/skytils/ktor/server/sessions/SessionTransportTransformerEncrypt$Companion;", "", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "log", "Lorg/slf4j/Logger;", "<init>", "()V", "ktor-server-sessions"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

