/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.sessions;

import gg.skytils.ktor.server.application.ApplicationCall;
import gg.skytils.ktor.server.application.ApplicationKt;
import gg.skytils.ktor.server.sessions.SessionSerializer;
import gg.skytils.ktor.server.sessions.SessionTracker;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B#\u0012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019\u0012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001b\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u000b\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00028\u0000H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00198\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006 "}, d2={"Lgg/skytils/ktor/server/sessions/SessionTrackerByValue;", "", "S", "Lgg/skytils/ktor/server/sessions/SessionTracker;", "Lgg/skytils/ktor/server/application/ApplicationCall;", "call", "", "clear", "(Lio/ktor/server/application/ApplicationCall;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "transport", "load", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "value", "store", "(Lio/ktor/server/application/ApplicationCall;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "()Ljava/lang/String;", "validate", "(Ljava/lang/Object;)V", "Lgg/skytils/ktor/server/sessions/SessionSerializer;", "serializer", "Lgg/skytils/ktor/server/sessions/SessionSerializer;", "getSerializer", "()Lio/ktor/server/sessions/SessionSerializer;", "Lkotlin/reflect/KClass;", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "<init>", "(Lkotlin/reflect/KClass;Lio/ktor/server/sessions/SessionSerializer;)V", "ktor-server-sessions"})
public final class SessionTrackerByValue<S>
implements SessionTracker<S> {
    @NotNull
    private final KClass<S> type;
    @NotNull
    private final SessionSerializer<S> serializer;

    public SessionTrackerByValue(@NotNull KClass<S> type2, @NotNull SessionSerializer<S> serializer2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(serializer2, "serializer");
        this.type = type2;
        this.serializer = serializer2;
    }

    @NotNull
    public final KClass<S> getType() {
        return this.type;
    }

    @NotNull
    public final SessionSerializer<S> getSerializer() {
        return this.serializer;
    }

    @Override
    @Nullable
    public Object load(@NotNull ApplicationCall call, @Nullable String transport, @NotNull Continuation<? super S> $completion) {
        Object v1;
        String string = transport;
        if (string != null) {
            S s;
            String serialized = string;
            boolean bl = false;
            try {
                s = this.serializer.deserialize(serialized);
            }
            catch (Throwable t) {
                ApplicationKt.getLog(call.getApplication()).debug("Failed to deserialize session: " + serialized, t);
                s = null;
            }
            v1 = s;
        } else {
            v1 = null;
        }
        return v1;
    }

    @Override
    @Nullable
    public Object store(@NotNull ApplicationCall call, @NotNull S value, @NotNull Continuation<? super String> $completion) {
        return this.serializer.serialize(value);
    }

    @Override
    public void validate(@NotNull S value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (!this.type.isInstance(value)) {
            throw new IllegalArgumentException("Value for this session tracker expected to be of type " + this.type + " but was " + value);
        }
    }

    @Override
    @Nullable
    public Object clear(@NotNull ApplicationCall call, @NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @NotNull
    public String toString() {
        return "SessionTrackerByValue";
    }
}

