/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.routing;

import gg.skytils.ktor.http.ContentType;
import gg.skytils.ktor.http.HeaderValue;
import gg.skytils.ktor.http.HttpHeaderValueParserKt;
import gg.skytils.ktor.http.HttpHeaders;
import gg.skytils.ktor.http.HttpStatusCode;
import gg.skytils.ktor.server.request.ApplicationRequestPropertiesKt;
import gg.skytils.ktor.server.routing.RouteSelector;
import gg.skytils.ktor.server.routing.RouteSelectorEvaluation;
import gg.skytils.ktor.server.routing.RoutingResolveContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0006\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000b\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u00d6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001d\u001a\u00020\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Lgg/skytils/ktor/server/routing/ContentTypeHeaderRouteSelector;", "Lgg/skytils/ktor/server/routing/RouteSelector;", "Lgg/skytils/ktor/http/ContentType;", "component1", "()Lgg/skytils/ktor/http/ContentType;", "contentType", "copy", "(Lgg/skytils/ktor/http/ContentType;)Lgg/skytils/ktor/server/routing/ContentTypeHeaderRouteSelector;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "Lgg/skytils/ktor/server/routing/RoutingResolveContext;", "context", "", "segmentIndex", "Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation;", "evaluate", "(Lgg/skytils/ktor/server/routing/RoutingResolveContext;I)Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation;", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lgg/skytils/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation$Failure;", "failedEvaluation", "Lgg/skytils/ktor/server/routing/RouteSelectorEvaluation$Failure;", "<init>", "(Lio/ktor/http/ContentType;)V", "ktor-server-core"})
@SourceDebugExtension(value={"SMAP\nRouteSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/ContentTypeHeaderRouteSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,700:1\n288#2,2:701\n*S KotlinDebug\n*F\n+ 1 RouteSelector.kt\nio/ktor/server/routing/ContentTypeHeaderRouteSelector\n*L\n595#1:701,2\n*E\n"})
public final class ContentTypeHeaderRouteSelector
extends RouteSelector {
    @NotNull
    private final ContentType contentType;
    @NotNull
    private final RouteSelectorEvaluation.Failure failedEvaluation;

    public ContentTypeHeaderRouteSelector(@NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        this.contentType = contentType2;
        this.failedEvaluation = new RouteSelectorEvaluation.Failure(0.01, HttpStatusCode.Companion.getUnsupportedMediaType());
    }

    @NotNull
    public final ContentType getContentType() {
        return this.contentType;
    }

    @Override
    @NotNull
    public RouteSelectorEvaluation evaluate(@NotNull RoutingResolveContext context, int segmentIndex) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter(context, "context");
            String headers2 = ApplicationRequestPropertiesKt.header(context.getCall().getRequest(), HttpHeaders.INSTANCE.getContentType());
            List<HeaderValue> parsedHeaders = HttpHeaderValueParserKt.parseAndSortContentTypeHeader(headers2);
            Iterable $this$firstOrNull$iv = parsedHeaders;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HeaderValue it = (HeaderValue)element$iv;
                boolean bl = false;
                if (!ContentType.Companion.parse(it.getValue()).match(this.contentType)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        HeaderValue headerValue = v0;
        if (headerValue == null) {
            return this.failedEvaluation;
        }
        HeaderValue header = headerValue;
        return new RouteSelectorEvaluation.Success(header.getQuality(), null, 0, 6, null);
    }

    @NotNull
    public String toString() {
        return "(contentType = " + this.contentType + ')';
    }

    @NotNull
    public final ContentType component1() {
        return this.contentType;
    }

    @NotNull
    public final ContentTypeHeaderRouteSelector copy(@NotNull ContentType contentType2) {
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        return new ContentTypeHeaderRouteSelector(contentType2);
    }

    public static /* synthetic */ ContentTypeHeaderRouteSelector copy$default(ContentTypeHeaderRouteSelector contentTypeHeaderRouteSelector, ContentType contentType2, int n, Object object) {
        if ((n & 1) != 0) {
            contentType2 = contentTypeHeaderRouteSelector.contentType;
        }
        return contentTypeHeaderRouteSelector.copy(contentType2);
    }

    public int hashCode() {
        return this.contentType.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentTypeHeaderRouteSelector)) {
            return false;
        }
        ContentTypeHeaderRouteSelector contentTypeHeaderRouteSelector = (ContentTypeHeaderRouteSelector)other;
        return Intrinsics.areEqual(this.contentType, contentTypeHeaderRouteSelector.contentType);
    }
}

