/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.asmhelper.dsl.writers;

import gg.skytils.asmhelper.AsmHelper;
import gg.skytils.asmhelper.dsl.AsmWriter;
import gg.skytils.asmhelper.dsl.code.CodeBlock;
import gg.skytils.asmhelper.dsl.instructions.InsnListBuilder;
import gg.skytils.asmhelper.remapping.Remapper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0001\u001eBl\u0012\u0006\u0010\u001b\u001a\u00020\t\u0012\u0006\u0010\u001a\u001a\u00020\t\u0012\u0006\u0010\u0018\u001a\u00020\t\u0012\u0019\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0013\u00a2\u0006\u0002\b\u0015\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\t\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010\u0012\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R'\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0013\u00a2\u0006\u0002\b\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u000fR \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0012R\u0014\u0010\u001a\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lgg/skytils/asmhelper/dsl/writers/OverwriteWriter;", "Lgg/skytils/asmhelper/dsl/AsmWriter;", "Lorg/objectweb/asm/tree/MethodNode;", "method", "Lorg/objectweb/asm/tree/ClassNode;", "classNode", "", "overwriteMethod", "(Lorg/objectweb/asm/tree/MethodNode;Lorg/objectweb/asm/tree/ClassNode;)V", "", "toString", "()Ljava/lang/String;", "transform", "(Lorg/objectweb/asm/tree/ClassNode;)V", "codeBlockClassName", "Ljava/lang/String;", "", "fieldMaps", "Ljava/util/Map;", "Lkotlin/Function1;", "Lgg/skytils/asmhelper/dsl/instructions/InsnListBuilder;", "Lkotlin/ExtensionFunctionType;", "insnListBuilder", "Lkotlin/jvm/functions/Function1;", "methodDesc", "methodMaps", "methodName", "className", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;)V", "Builder", "AsmHelper1.8.9"})
public final class OverwriteWriter
extends AsmWriter {
    @NotNull
    private final String methodName;
    @NotNull
    private final String methodDesc;
    @Nullable
    private final Function1<InsnListBuilder, Unit> insnListBuilder;
    @Nullable
    private final String codeBlockClassName;
    @NotNull
    private final Map<String, String> fieldMaps;
    @NotNull
    private final Map<String, String> methodMaps;

    public OverwriteWriter(@NotNull String className, @NotNull String methodName, @NotNull String methodDesc, @Nullable Function1<? super InsnListBuilder, Unit> insnListBuilder, @Nullable String codeBlockClassName, @NotNull Map<String, String> fieldMaps, @NotNull Map<String, String> methodMaps) {
        Intrinsics.checkNotNullParameter(className, "className");
        Intrinsics.checkNotNullParameter(methodName, "methodName");
        Intrinsics.checkNotNullParameter(methodDesc, "methodDesc");
        Intrinsics.checkNotNullParameter(fieldMaps, "fieldMaps");
        Intrinsics.checkNotNullParameter(methodMaps, "methodMaps");
        super(className);
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.insnListBuilder = insnListBuilder;
        this.codeBlockClassName = codeBlockClassName;
        this.fieldMaps = fieldMaps;
        this.methodMaps = methodMaps;
    }

    @Override
    public void transform(@NotNull ClassNode classNode) {
        Object v4;
        boolean bl;
        Iterable iterable;
        block2: {
            Intrinsics.checkNotNullParameter(classNode, "classNode");
            AsmHelper.INSTANCE.setFieldMaps$AsmHelper1_8_9(this.fieldMaps);
            AsmHelper.INSTANCE.setMethodMaps$AsmHelper1_8_9(this.methodMaps);
            iterable = classNode.methods;
            Intrinsics.checkNotNullExpressionValue(iterable, "classNode.methods");
            iterable = iterable;
            bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object e : iterable2) {
                MethodNode it = (MethodNode)e;
                boolean bl3 = false;
                Remapper remapper = AsmHelper.INSTANCE.getRemapper();
                String string = classNode.name;
                Intrinsics.checkNotNullExpressionValue(string, "classNode.name");
                String string2 = string;
                string = it.name;
                Intrinsics.checkNotNullExpressionValue(string, "it.name");
                String string3 = string;
                string = it.desc;
                Intrinsics.checkNotNullExpressionValue(string, "it.desc");
                String remapped = remapper.remapMethodName(string2, string3, string);
                Remapper remapper2 = AsmHelper.INSTANCE.getRemapper();
                String string4 = it.desc;
                Intrinsics.checkNotNullExpressionValue(string4, "it.desc");
                String remappedDesc = remapper2.remapDesc(string4);
                if (!(Intrinsics.areEqual(remappedDesc, this.methodDesc) && (Intrinsics.areEqual(remapped, this.methodName) || Intrinsics.areEqual(this.methodMaps.get(remapped), this.methodName)))) continue;
                v4 = e;
                break block2;
            }
            v4 = null;
        }
        MethodNode methodNode = v4;
        if (methodNode != null) {
            iterable = methodNode;
            bl = false;
            boolean bl4 = false;
            Iterable it = iterable;
            boolean bl5 = false;
            this.overwriteMethod((MethodNode)it, classNode);
        }
    }

    private final void overwriteMethod(MethodNode method2, ClassNode classNode) {
        method2.instructions.clear();
        method2.exceptions.clear();
        method2.tryCatchBlocks.clear();
        InsnList insnList = this.transformToInstructions(this.insnListBuilder, this.codeBlockClassName, method2, classNode);
        if (insnList == null) {
            return;
        }
        InsnList instructions = insnList;
        method2.maxLocals = Type.getArgumentTypes((String)method2.desc).length + ((method2.access & 8) == 0 ? 1 : 0);
        method2.instructions.add(instructions);
    }

    @NotNull
    public String toString() {
        return "OverwriteWriter{className=" + this.getClassName() + ", methodName=" + this.methodName + '}';
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0014\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b)\u0010*J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J&\u0010\n\u001a\u00020\u00072\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\n\u0010\u000bJ&\u0010\u000e\u001a\u00020\u00072\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\u000e\u0010\u000bR\"\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0011R.\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR)\u0010\u001e\u001a\u0015\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u00a2\u0006\u0002\b\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\u000f8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b \u0010\u0011\u001a\u0004\b!\u0010\u0013\"\u0004\b\"\u0010\u0015R.\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u0019\u001a\u0004\b$\u0010\u001b\"\u0004\b%\u0010\u001dR\"\u0010&\u001a\u00020\u000f8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b&\u0010\u0011\u001a\u0004\b'\u0010\u0013\"\u0004\b(\u0010\u0015\u00a8\u0006+"}, d2={"Lgg/skytils/asmhelper/dsl/writers/OverwriteWriter$Builder;", "Lgg/skytils/asmhelper/dsl/AsmWriter$AsmWriterBuilder;", "Lgg/skytils/asmhelper/dsl/AsmWriter;", "build", "()Lgg/skytils/asmhelper/dsl/AsmWriter;", "Lkotlin/Function1;", "Lgg/skytils/asmhelper/dsl/code/CodeBlock;", "", "Lkotlin/ExtensionFunctionType;", "code", "codeBlock", "(Lkotlin/jvm/functions/Function1;)V", "Lgg/skytils/asmhelper/dsl/instructions/InsnListBuilder;", "config", "insnList", "", "className", "Ljava/lang/String;", "getClassName", "()Ljava/lang/String;", "setClassName", "(Ljava/lang/String;)V", "codeBlockClassName", "", "fieldMaps", "Ljava/util/Map;", "getFieldMaps", "()Ljava/util/Map;", "setFieldMaps", "(Ljava/util/Map;)V", "insnListBuilder", "Lkotlin/jvm/functions/Function1;", "methodDesc", "getMethodDesc", "setMethodDesc", "methodMaps", "getMethodMaps", "setMethodMaps", "methodName", "getMethodName", "setMethodName", "<init>", "()V", "AsmHelper1.8.9"})
    public static final class Builder
    extends AsmWriter.AsmWriterBuilder {
        public String className;
        public String methodName;
        public String methodDesc;
        @Nullable
        private Function1<? super InsnListBuilder, Unit> insnListBuilder;
        @Nullable
        private String codeBlockClassName;
        @NotNull
        private Map<String, String> fieldMaps;
        @NotNull
        private Map<String, String> methodMaps;

        public Builder() {
            boolean bl = false;
            this.fieldMaps = MapsKt.emptyMap();
            bl = false;
            this.methodMaps = MapsKt.emptyMap();
        }

        @NotNull
        public final String getClassName() {
            String string = this.className;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("className");
            throw null;
        }

        public final void setClassName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.className = string;
        }

        @NotNull
        public final String getMethodName() {
            String string = this.methodName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("methodName");
            throw null;
        }

        public final void setMethodName(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.methodName = string;
        }

        @NotNull
        public final String getMethodDesc() {
            String string = this.methodDesc;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException("methodDesc");
            throw null;
        }

        public final void setMethodDesc(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.methodDesc = string;
        }

        @NotNull
        public final Map<String, String> getFieldMaps() {
            return this.fieldMaps;
        }

        public final void setFieldMaps(@NotNull Map<String, String> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.fieldMaps = map2;
        }

        @NotNull
        public final Map<String, String> getMethodMaps() {
            return this.methodMaps;
        }

        public final void setMethodMaps(@NotNull Map<String, String> map2) {
            Intrinsics.checkNotNullParameter(map2, "<set-?>");
            this.methodMaps = map2;
        }

        @NotNull
        public final AsmWriter build() throws IllegalStateException {
            return new OverwriteWriter(this.getClassName(), this.getMethodName(), this.getMethodDesc(), this.insnListBuilder, this.codeBlockClassName, this.fieldMaps, this.methodMaps);
        }

        public final void insnList(@NotNull Function1<? super InsnListBuilder, Unit> config2) {
            Intrinsics.checkNotNullParameter(config2, "config");
            this.insnListBuilder = config2;
        }

        public final void codeBlock(@NotNull Function1<? super CodeBlock, Unit> code) {
            Intrinsics.checkNotNullParameter(code, "code");
            this.codeBlockClassName = Intrinsics.stringPlus(code.getClass().getName(), "$1");
        }
    }
}

