/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.vanillaforge;

import java.util.HashMap;
import java.util.Map;
import net.labymod.vanillaforge.ClassEditor;
import net.labymod.vanillaforge.Names;
import net.labymod.vanillaforge.editors.AbstractClientPlayerEditor;
import net.labymod.vanillaforge.editors.EntityRendererEditor;
import net.labymod.vanillaforge.editors.FOVUpdateEventEditor;
import net.labymod.vanillaforge.editors.GuiIngameEditor;
import net.labymod.vanillaforge.editors.GuiOpenEventEditor;
import net.labymod.vanillaforge.editors.GuiScreenDrawScreenEventEditor;
import net.labymod.vanillaforge.editors.GuiScreenDrawScreenPostEventEditor;
import net.labymod.vanillaforge.editors.GuiScreenEditor;
import net.labymod.vanillaforge.editors.GuiScreenEventEditor;
import net.labymod.vanillaforge.editors.MinecraftEditor;
import net.labymod.vanillaforge.editors.RenderGameOverlayEventEditor;
import net.labymod.vanillaforge.editors.RenderManagerEditor;
import net.labymod.vanillaforge.editors.RenderWorldLastEventEditor;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class LabyModTransformer
implements IClassTransformer {
    private Map<String, ClassEditor> editors = new HashMap<String, ClassEditor>();

    public LabyModTransformer() {
        this.editors.put(Names.MINECRAFT_CLASS.getName(false), new MinecraftEditor());
        this.editors.put(GuiOpenEvent.class.getName(), new GuiOpenEventEditor());
        this.editors.put(RenderGameOverlayEvent.class.getName(), new RenderGameOverlayEventEditor());
        this.editors.put(FOVUpdateEvent.class.getName(), new FOVUpdateEventEditor());
        this.editors.put(Names.ABSTRACT_CLIENT_PLAYER.getName(false), new AbstractClientPlayerEditor());
        this.editors.put(Names.GUI_INGAME.getName(false), new GuiIngameEditor());
        this.editors.put(Names.RENDER_MANAGER.getName(false), new RenderManagerEditor());
        this.editors.put(Names.GUI_SCREEN.getName(false), new GuiScreenEditor());
        this.editors.put(GuiScreenEvent.class.getName(), new GuiScreenEventEditor());
        this.editors.put(GuiScreenEvent.DrawScreenEvent.class.getName(), new GuiScreenDrawScreenEventEditor());
        this.editors.put(GuiScreenEvent.DrawScreenEvent.Post.class.getName(), new GuiScreenDrawScreenPostEventEditor());
        this.editors.put(Names.ENTITY_RENDERER.getName(false), new EntityRendererEditor());
        this.editors.put(RenderWorldLastEvent.class.getName(), new RenderWorldLastEventEditor());
    }

    public byte[] transform(String name, String transformed, byte[] bytes) {
        if (this.editors.containsKey(name)) {
            System.out.println("[LabyMod-Vanilla] Transforming class " + name);
            ClassEditor editor = this.editors.get(name);
            switch (editor.getType()) {
                case CLASS_NODE: {
                    ClassNode node = new ClassNode();
                    ClassReader reader = new ClassReader(bytes);
                    reader.accept((ClassVisitor)node, 0);
                    editor.accept(name, node);
                    ClassWriter writer = new ClassWriter(3);
                    node.accept((ClassVisitor)writer);
                    byte[] returnedBytes = writer.toByteArray();
                    return returnedBytes;
                }
                case CLASS_VISITOR: {
                    ClassReader classReader = new ClassReader(bytes);
                    ClassWriter classWriter = new ClassWriter(classReader, 3);
                    editor.accept(name, (ClassVisitor)classWriter);
                    classReader.accept((ClassVisitor)editor, 0);
                    byte[] retBytes = classWriter.toByteArray();
                    return retBytes;
                }
            }
            return bytes;
        }
        return bytes;
    }
}

