/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.texture.async;

import java.awt.image.BufferedImage;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import org.lwjgl.opengl.GL11;

public class AsyncTextureUtil {
    private static final ThreadLocal<IntBuffer> DATA_BUFFER = ThreadLocal.withInitial(new Supplier<IntBuffer>(){

        @Override
        public IntBuffer get() {
            return avd.f((int)0x400000);
        }
    });

    public static int uploadTextureImage(int id, BufferedImage image) {
        AsyncTextureUtil.allocateTexture(id, image.getWidth(), image.getHeight());
        return AsyncTextureUtil.uploadTextureImageSub(id, image);
    }

    public static int uploadTextureImageSub(int textureId, BufferedImage image) {
        bfl.i((int)textureId);
        AsyncTextureUtil.uploadTextureImageSubImpl(image);
        return textureId;
    }

    public static void allocateTexture(int id, int width, int height) {
        bfl.i((int)id);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)null);
    }

    private static void uploadTextureImageSubImpl(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int k = 0x400000 / width;
        int[] pixels = new int[k * width];
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        IntBuffer dataBuffer = DATA_BUFFER.get();
        for (int l = 0; l < width * height; l += width * k) {
            int i1 = l / width;
            int j1 = Math.min(k, height - i1);
            int k1 = width * j1;
            image.getRGB(0, i1, width, j1, pixels, 0, width);
            AsyncTextureUtil.copyToBufferPos(dataBuffer, pixels, 0, k1);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)i1, (int)width, (int)j1, (int)32993, (int)33639, (IntBuffer)dataBuffer);
        }
    }

    private static void copyToBufferPos(IntBuffer dataBuffer, int[] pixels, int start, int length) {
        int[] aint = pixels;
        if (ave.A().t.e) {
            aint = AsyncTextureUtil.updateAnaglyph(pixels);
        }
        dataBuffer.clear();
        dataBuffer.put(aint, start, length);
        dataBuffer.position(0).limit(length);
    }

    public static int[] updateAnaglyph(int[] p_110985_0_) {
        int[] aint = new int[p_110985_0_.length];
        for (int i = 0; i < p_110985_0_.length; ++i) {
            aint[i] = AsyncTextureUtil.anaglyphColor(p_110985_0_[i]);
        }
        return aint;
    }

    public static int anaglyphColor(int pixels) {
        int a2 = pixels >> 24 & 0xFF;
        int b2 = pixels >> 16 & 0xFF;
        int g2 = pixels >> 8 & 0xFF;
        int r = pixels & 0xFF;
        int i1 = (b2 * 30 + g2 * 59 + r * 11) / 100;
        int j1 = (b2 * 30 + g2 * 70) / 100;
        int k1 = (b2 * 30 + r * 70) / 100;
        return a2 << 24 | i1 << 16 | j1 << 8 | k1;
    }
}

