/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.texture.async;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.labymod.main.LabyMod;
import net.labymod.utils.OSUtil;
import net.labymod.utils.texture.async.BulkTask;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.SharedDrawable;

public class AsyncTextureLoader
extends Thread {
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final List<BulkTask> bulkTasks = new ArrayList<BulkTask>();
    private Drawable drawable;

    public AsyncTextureLoader() {
        if (OSUtil.getOS() == OSUtil.WIN_32) {
            return;
        }
        try {
            this.drawable = new SharedDrawable(Display.getDrawable());
            this.start();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public boolean isAsyncAvailable() {
        return this.drawable != null && LabyMod.getSettings().loadTexturesAsync;
    }

    public void runTaskAsync(Runnable runnable) {
        if (this.isAsyncAvailable()) {
            this.queue.add(runnable);
        } else {
            ave.A().a(runnable);
        }
    }

    public void runBulkTask(BulkTask task) {
        this.bulkTasks.add(task);
    }

    public void processBulkTasks() {
        try {
            BulkTask task;
            BulkTask bulkTask = task = this.bulkTasks.isEmpty() ? null : this.bulkTasks.get(0);
            if (task != null) {
                Runnable runnable = task.remove();
                if (runnable == null) {
                    task.completed();
                    this.bulkTasks.remove(task);
                } else {
                    runnable.run();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.bulkTasks.clear();
        }
    }

    public void uploadTextureAsync(jy resourceLocation, bly texture) {
        this.runTaskAsync(() -> this.uploadTexture(resourceLocation, texture));
    }

    public void uploadTexture(jy resourceLocation, bly texture) {
        try {
            texture.a(ave.A().Q());
            ave.A().a(() -> LabyMod.getInstance().getDynamicTextureManager().getMapTextureObjects().put(resourceLocation, (bmk)texture));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            this.drawable.makeCurrent();
            while (!Thread.interrupted()) {
                try {
                    this.uploadNextTextureInQueue();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                GL11.glFlush();
            }
        }
        catch (Throwable e1) {
            e1.printStackTrace();
        }
        if (this.isAsyncAvailable()) {
            this.drawable.destroy();
            this.drawable = null;
        }
    }

    private void uploadNextTextureInQueue() throws InterruptedException {
        this.queue.take().run();
    }
}

