/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.request;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.net.ssl.HttpsURLConnection;
import net.labymod.accountmanager.utils.CertificateLoader;
import net.labymod.main.Source;
import net.labymod.support.util.Debug;
import net.labymod.utils.request.InputStreamOutput;
import net.labymod.utils.request.RequestException;
import net.labymod.utils.request.ServerInputStream;
import net.labymod.utils.request.ServerResponse;
import net.labymod.utils.request.ServerStatus;
import sun.net.www.protocol.http.HttpURLConnection;

public class DownloadServerRequest {
    private static final Executor EXECUTOR = Executors.newFixedThreadPool(5);
    private static final JsonParser JSON_PARSER = new JsonParser();

    public static void getJsonObjectAsync(String url, final ServerResponse<JsonElement> response) {
        DownloadServerRequest.getStringAsync(url, new ServerResponse<String>(){

            @Override
            public void success(String json) {
                response.success(JSON_PARSER.parse(json));
            }

            @Override
            public void failed(RequestException exception) {
                response.failed(exception);
            }
        });
    }

    public static void getStringAsync(String url, final ServerResponse<String> response) {
        DownloadServerRequest.getBytesAsync(url, new ServerResponse<byte[]>(){

            @Override
            public void success(byte[] bytes) {
                response.success(new String(bytes, StandardCharsets.UTF_8));
            }

            @Override
            public void failed(RequestException exception) {
                response.failed(exception);
            }
        });
    }

    public static void getBytesAsync(final String url, final ServerResponse<byte[]> response) {
        EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    response.success(DownloadServerRequest.getBytes(url));
                }
                catch (RequestException exception) {
                    response.failed(exception);
                }
            }
        });
    }

    public static String getString(String url) throws Exception {
        return new String(DownloadServerRequest.getBytes(url), StandardCharsets.UTF_8);
    }

    public static JsonElement getJsonObject(String url) throws Exception {
        return JSON_PARSER.parse(DownloadServerRequest.getString(url));
    }

    public static void writeBytesAsync(final String url, final OutputStream outputStream, final ServerStatus status) {
        EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    DownloadServerRequest.writeBytes(url, outputStream);
                    try {
                        status.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    status.success();
                }
                catch (RequestException exception) {
                    try {
                        status.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    status.failed(exception);
                }
            }
        });
    }

    public static byte[] getBytes(String url) throws RequestException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DownloadServerRequest.writeBytes(url, buffer);
        return buffer.toByteArray();
    }

    public static void writeBytes(String url, OutputStream outputStream) throws RequestException {
        try {
            int num;
            InputStream inputStream = DownloadServerRequest.getInputStream(url).getInputStream();
            byte[] data = new byte[1024];
            while ((num = inputStream.read(data, 0, data.length)) != -1) {
                outputStream.write(data, 0, num);
            }
            outputStream.flush();
        }
        catch (Exception ex) {
            throw new RequestException(ex);
        }
    }

    public static InputStreamOutput getInputStream(String url) throws RequestException {
        try {
            URL urlObject = new URL(url);
            boolean isEncrypted = urlObject.getProtocol().equals("https");
            for (int i = 0; i < (isEncrypted ? 2 : 1); ++i) {
                boolean isUsingHttpNow;
                boolean bl = isUsingHttpNow = i == 1 || !isEncrypted;
                if (isUsingHttpNow && isEncrypted) {
                    urlObject = new URL("http", urlObject.getHost(), urlObject.getPort(), urlObject.getFile());
                }
                try {
                    int responseCode;
                    URLConnection connection = urlObject.openConnection();
                    connection.setRequestProperty("User-Agent", Source.getUserAgent());
                    connection.setReadTimeout(5000);
                    connection.setConnectTimeout(2000);
                    if (connection instanceof HttpsURLConnection) {
                        ((HttpsURLConnection)connection).setSSLSocketFactory(CertificateLoader.getSocketFactory());
                    }
                    connection.connect();
                    int n = responseCode = connection instanceof HttpsURLConnection ? ((HttpsURLConnection)connection).getResponseCode() : ((HttpURLConnection)connection).getResponseCode();
                    if (responseCode / 100 == 2) {
                        InputStream inputStream = connection.getInputStream();
                        int contentLength = connection.getContentLength();
                        return new InputStreamOutput(inputStream, contentLength);
                    }
                    if (isUsingHttpNow) {
                        throw new RequestException(responseCode);
                    }
                    Debug.log(Debug.EnumDebugMode.GENERAL, "Failed to request " + url + " because error code " + responseCode);
                    continue;
                }
                catch (Exception ex) {
                    if (isUsingHttpNow) {
                        throw new RequestException(ex);
                    }
                    Debug.log(Debug.EnumDebugMode.GENERAL, "Failed to request " + url + " because " + ex.getMessage());
                }
            }
            throw new RequestException(-1);
        }
        catch (Exception e) {
            throw new RequestException(e);
        }
    }

    public static void getInputStreamAsync(final String url, final ServerInputStream serverInputStream) {
        EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    InputStreamOutput output = DownloadServerRequest.getInputStream(url);
                    serverInputStream.opened(output.getInputStream(), output.getContentLength());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (exception instanceof RequestException) {
                        serverInputStream.failed((RequestException)exception);
                    }
                    serverInputStream.failed(new RequestException(exception));
                }
            }
        });
    }
}

