/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils.manager;

import java.io.DataInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import javax.imageio.ImageIO;
import net.labymod.core.asm.LabyModTransformer;
import net.labymod.main.ModTextures;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;

public class CustomLoadingScreen {
    private static CustomLoadingScreen instance;
    private ave mc;
    private jy resourceMojangLogo;
    private jy resourceLabymodBanner;
    private bmj textureManager;
    private DrawUtils drawUtils;
    private int renderedFrames = 0;
    private String[] steps;

    public static void renderInstance() {
        if (instance == null) {
            instance = new CustomLoadingScreen(ave.A(), ave.A().P());
        }
        instance.drawSplashScreen();
    }

    public CustomLoadingScreen(ave mc, bmj textureManager) {
        this.mc = mc;
        this.textureManager = textureManager;
        this.drawUtils = new DrawUtils();
        avn fontRenderer = new avn(mc.t, new jy("textures/font/ascii.png"), textureManager, false);
        fontRenderer.a(mc.d());
        fontRenderer.b(mc.S().b());
        ((bng)mc.Q()).a((bnj)fontRenderer);
        this.drawUtils.setFontRenderer(fontRenderer);
        this.loadResource();
    }

    private void loadResource() {
        try {
            Class<?> clazz = this.mc.getClass();
            Field field = clazz.getDeclaredField(LabyModTransformer.getMappingImplementation().getMCDefaultResourcePack());
            field.setAccessible(true);
            bna mcDefaultResourcePack = (bna)field.get(this.mc);
            InputStream inputstreamMojang = mcDefaultResourcePack.a(ModTextures.TITLE_MOJANG_BANNER);
            this.resourceMojangLogo = this.textureManager.a("logo", new blz(ImageIO.read(inputstreamMojang)));
            InputStream inputstreamLabyModBanner = mcDefaultResourcePack.a(ModTextures.TITLE_LABYMOD_BANNER_SPLASH);
            this.resourceLabymodBanner = this.textureManager.a("logo_lm_banner", new blz(ImageIO.read(inputstreamLabyModBanner)));
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("assets/minecraft/labymod/data/steps.titles");
            DataInputStream dis = new DataInputStream(inputStream);
            this.steps = new String[dis.readInt()];
            for (int i = 0; i < this.steps.length; ++i) {
                byte[] bytes = new byte[dis.readInt()];
                dis.read(bytes);
                this.steps[i] = new String(bytes);
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void drawSplashScreen() {
        ++this.renderedFrames;
        if (this.steps == null) {
            return;
        }
        int width = this.drawUtils.getWidth();
        int height = this.drawUtils.getHeight();
        bfl.n((int)5889);
        bfl.D();
        bfl.a((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        bfl.n((int)5888);
        bfl.D();
        bfl.b((float)0.0f, (float)0.0f, (float)-2000.0f);
        bfl.f();
        bfl.n();
        bfl.i();
        bfl.w();
        bfl.d();
        bfl.l();
        this.drawUtils.drawRectangle(0, 0, width, height, -1);
        this.textureManager.a(this.resourceMojangLogo);
        avp.a((int)((width - 256) / 2), (int)((height - 256) / 2), (float)0.0f, (float)0.0f, (int)256, (int)256, (float)256.0f, (float)256.0f);
        double percent = 100.0 / (double)this.steps.length * (double)this.renderedFrames;
        this.drawProgressbar((double)width / 2.0 - 100.0, height / 2 + 30, 200.0, 12.0, percent);
        this.textureManager.a(this.resourceLabymodBanner);
        double bannerWidth = 140.0;
        double bannerHeight = bannerWidth / 4.0;
        avp.a((int)((int)((double)width / 2.0 - bannerWidth / 2.0)), (int)((int)((double)height / 2.0 + 45.0 + 10.0)), (float)0.0f, (float)0.0f, (int)((int)bannerWidth), (int)((int)bannerHeight), (float)((int)bannerWidth), (float)((int)bannerHeight));
        String text = this.renderedFrames < this.steps.length ? this.steps[this.renderedFrames] : "";
        this.drawUtils.getFontRenderer().a(text, (width - this.drawUtils.getStringWidth(text)) / 2, height / 2 + 45, ModColor.toRGB(0, 0, 0, 255));
        try {
            this.mc.h();
        }
        catch (NullPointerException error) {
            error.printStackTrace();
        }
        bfl.l();
        bfl.d();
    }

    private void drawProgressbar(double x, double y, double width, double height, double percent) {
        if (percent > 100.0) {
            percent = 100.0;
        }
        this.drawRect(x - 1.0, y - 1.0, x + width + 1.0, y + height + 1.0, ModColor.toRGB(0, 0, 0, 255));
        this.drawRect(x, y, x + width, y + height, ModColor.toRGB(200, 200, 200, 255));
        this.drawRect(x, y, (int)(x + width / 100.0 * percent), y + height, ModColor.toRGB(0, 143, 232, 255));
        this.drawUtils.drawCenteredString(ModColor.cl("f") + (int)percent + "%", x + width / 2.0, y + height / 2.0 - 4.0);
    }

    private void drawRect(double left, double top, double right, double bottom, int color) {
        avp.a((int)((int)left), (int)((int)top), (int)((int)right), (int)((int)bottom), (int)color);
    }
}

