/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.utils;

import com.google.gson.JsonObject;
import java.text.DecimalFormat;
import net.labymod.main.LabyMod;

public class Economy {
    private boolean visible;
    private int balance;
    private int prevBalance;
    private long lastBalanceUpdated;
    private String icon;
    private int divisor = 0;
    private DecimalFormat decimalFormat;

    public void update(JsonObject object, String key) {
        if (object.has(key)) {
            JsonObject economy = object.get(key).getAsJsonObject();
            if (economy.has("visible")) {
                this.visible = economy.get("visible").getAsBoolean();
            }
            if (economy.has("balance")) {
                this.updateBalance(economy.get("balance").getAsInt());
            }
            if (economy.has("icon")) {
                this.icon = economy.get("icon").getAsString();
            }
            if (economy.has("decimal")) {
                JsonObject decimal = economy.get("decimal").getAsJsonObject();
                try {
                    this.divisor = decimal.get("divisor").getAsInt();
                    this.decimalFormat = new DecimalFormat(decimal.get("format").getAsString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void updateBalance(int value) {
        this.prevBalance = this.balance;
        this.balance = value;
        this.lastBalanceUpdated = System.currentTimeMillis();
    }

    public jy getIcon(jy fallback) {
        return this.icon == null ? fallback : LabyMod.getInstance().getDynamicTextureManager().getTexture("economy_icon_" + this.icon.hashCode(), this.icon);
    }

    public String getDisplayValue() {
        int balance = this.getInterpolatedBalance();
        if (this.divisor <= 0 || this.decimalFormat == null) {
            return String.valueOf(balance);
        }
        return this.decimalFormat.format((double)balance / (double)this.divisor);
    }

    private int getInterpolatedBalance() {
        long duration;
        long timePassed = System.currentTimeMillis() - this.lastBalanceUpdated;
        if (timePassed > (duration = 2000L)) {
            return this.balance;
        }
        double input = (double)Math.min(duration, timePassed) / (double)duration * 4.0;
        double sigmoid = 1.0 / (1.0 + Math.exp(-input * 2.0 + 4.0));
        int economyDifference = this.prevBalance - this.balance;
        return (int)Math.round((double)this.prevBalance - (double)economyDifference * sigmoid);
    }

    public void reset() {
        this.visible = false;
        this.balance = 0;
        this.prevBalance = 0;
        this.lastBalanceUpdated = 0L;
        this.icon = null;
        this.divisor = 0;
        this.decimalFormat = null;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getBalance() {
        return this.balance;
    }

    public String getIcon() {
        return this.icon;
    }
}

