/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.gui;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.labymod.api.EventManager;
import net.labymod.api.events.ServerMessageEvent;
import net.labymod.api.permissions.Permissions;
import net.labymod.core.LabyModCore;
import net.labymod.ingamechat.GuiChatCustom;
import net.labymod.ingamechat.tabs.GuiChatNameHistory;
import net.labymod.ingamechat.tools.playermenu.PlayerMenu;
import net.labymod.labyconnect.LabyConnect;
import net.labymod.labyconnect.gui.GuiFriendsAddFriend;
import net.labymod.labyconnect.user.ChatUser;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.main.lang.LanguageManager;
import net.labymod.main.listeners.CapeReportCommand;
import net.labymod.support.util.Debug;
import net.labymod.user.User;
import net.labymod.user.UserManager;
import net.labymod.user.util.UserActionEntry;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class UserActionGui
extends avp
implements ServerMessageEvent {
    private static Field fieldLeftClickCounter;
    private List<UserActionEntry> defaultEntries = new ArrayList<UserActionEntry>();
    private List<UserActionEntry> serverEntries = new ArrayList<UserActionEntry>();
    private wn selectedPlayer = null;
    private User selectedUser = null;
    private bdc networkPlayerInfo;
    private List<UserActionEntry> actionEntries;
    private float lockedYaw = 0.0f;
    private float lockedPitch = 0.0f;
    private boolean prevCrosshairState;
    private boolean middleMousePressed = false;
    private UserActionEntry actionToExecute = null;
    private long selectionStarted;

    public UserActionGui(UserManager userManager) {
        this.defaultEntries.add(new UserActionEntry(LanguageManager.translate("labynet_profile"), UserActionEntry.EnumActionType.OPEN_BROWSER, String.format("https://laby.net/@%s", "{name}"), null));
        this.defaultEntries.add(new UserActionEntry(LanguageManager.translate("playermenu_entry_copyname"), UserActionEntry.EnumActionType.CLIPBOARD, "{name}", null));
        this.defaultEntries.add(new UserActionEntry(LanguageManager.translate("playermenu_entry_addfriend"), UserActionEntry.EnumActionType.NONE, null, new UserActionEntry.ActionExecutor(){

            @Override
            public boolean canAppear(User user, wn entityPlayer, bdc networkPlayerInfo) {
                LabyConnect labyConnect = LabyMod.getInstance().getLabyConnect();
                if (!labyConnect.isOnline()) {
                    return false;
                }
                ArrayList<ChatUser> list = new ArrayList<ChatUser>(LabyMod.getInstance().getLabyConnect().getFriends());
                for (ChatUser p : list) {
                    if (!p.getGameProfile().getId().equals(user.getUuid())) continue;
                    return false;
                }
                return true;
            }

            @Override
            public void execute(User user, wn entityPlayer, bdc networkPlayerInfo) {
                ave.A().a((axu)new GuiFriendsAddFriend(null, entityPlayer.e_()));
            }
        }));
        this.defaultEntries.add(new UserActionEntry(LanguageManager.translate("ingame_chat_tab_namehistory"), UserActionEntry.EnumActionType.NONE, null, new UserActionEntry.ActionExecutor(){

            @Override
            public boolean canAppear(User user, wn entityPlayer, bdc networkPlayerInfo) {
                return true;
            }

            @Override
            public void execute(User user, wn entityPlayer, bdc networkPlayerInfo) {
                GuiChatCustom.activeTab = 5;
                ave.A().a((axu)new GuiChatNameHistory("", entityPlayer.e_()));
            }
        }));
        this.defaultEntries.add(new UserActionEntry(LanguageManager.translate("playermenu_entry_capereport"), UserActionEntry.EnumActionType.NONE, null, new UserActionEntry.ActionExecutor(){

            @Override
            public boolean canAppear(User user, wn entityPlayer, bdc networkPlayerInfo) {
                return true;
            }

            @Override
            public void execute(User user, wn entityPlayer, bdc networkPlayerInfo) {
                if (entityPlayer != null && entityPlayer.e_() != null) {
                    CapeReportCommand.report(entityPlayer.e_());
                }
            }
        }));
        EventManager eventManager = LabyMod.getInstance().getEventManager();
        eventManager.register(this);
    }

    @Override
    public void onServerMessage(String messageKey, JsonElement serverMessage) {
        if (!messageKey.equals("user_menu_actions")) {
            return;
        }
        ArrayList<UserActionEntry> serverEntries = new ArrayList<UserActionEntry>();
        JsonArray array = serverMessage.getAsJsonArray();
        for (int i = 0; i < array.size(); ++i) {
            try {
                JsonObject obj = array.get(i).getAsJsonObject();
                String displayName = obj.get("displayName").getAsString();
                UserActionEntry.EnumActionType type = UserActionEntry.EnumActionType.valueOf(obj.get("type").getAsString());
                String value = obj.get("value").getAsString();
                UserActionEntry entry = new UserActionEntry(displayName, type, value, null);
                serverEntries.add(entry);
                continue;
            }
            catch (Exception error) {
                Debug.log(Debug.EnumDebugMode.API, "Could not parse user menu action entry: " + error.getMessage());
            }
        }
        this.serverEntries = serverEntries;
    }

    public void open(wn entityPlayer) {
        if (this.selectedPlayer != null || entityPlayer == null) {
            return;
        }
        bdc networkPlayerInfo = LabyModCore.getMinecraft().getConnection().a(entityPlayer.aK());
        if (networkPlayerInfo == null) {
            return;
        }
        if (fieldLeftClickCounter == null) {
            try {
                fieldLeftClickCounter = ReflectionHelper.findField(ave.class, LabyModCore.getMappingAdapter().getLeftClickCounterMappings());
                fieldLeftClickCounter.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.networkPlayerInfo = networkPlayerInfo;
        this.selectedPlayer = entityPlayer;
        this.selectedUser = LabyMod.getInstance().getUserManager().getUser(entityPlayer.aK());
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null) {
            return;
        }
        ArrayList<UserActionEntry> entries = new ArrayList<UserActionEntry>();
        entries.addAll(this.defaultEntries);
        for (PlayerMenu.PlayerMenuEntry entry : LabyMod.getInstance().getChatToolManager().getPlayerMenu()) {
            entries.add(new UserActionEntry(entry.getDisplayName(), entry.isSendInstantly() ? UserActionEntry.EnumActionType.RUN_COMMAND : UserActionEntry.EnumActionType.SUGGEST_COMMAND, entry.getCommand(), null));
        }
        entries.addAll(this.serverEntries);
        LabyMod.getInstance().getEventManager().callCreateUserMenuActions(this.selectedUser, entityPlayer, networkPlayerInfo, entries);
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            UserActionEntry next = (UserActionEntry)iterator.next();
            if (next.getExecutor() == null || next.getExecutor().canAppear(this.selectedUser, (wn)player, this.networkPlayerInfo)) continue;
            iterator.remove();
        }
        this.actionEntries = entries;
        this.lockedYaw = player.y;
        this.lockedPitch = player.z;
        this.selectionStarted = System.currentTimeMillis();
        this.prevCrosshairState = LabyMod.getInstance().getLabyModAPI().isCrosshairHidden();
        LabyMod.getInstance().getLabyModAPI().setCrosshairHidden(true);
    }

    public void close() {
        if (this.selectedPlayer == null) {
            return;
        }
        this.selectedPlayer = null;
        this.selectedUser = null;
        LabyMod.getInstance().getLabyModAPI().setCrosshairHidden(this.prevCrosshairState);
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null) {
            return;
        }
        player.y = this.lockedYaw;
        player.z = this.lockedPitch;
    }

    public void render() {
        if (this.selectedPlayer == null) {
            return;
        }
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null || player.aK() == null || player.au != 0) {
            this.close();
            return;
        }
        try {
            if (fieldLeftClickCounter != null) {
                fieldLeftClickCounter.setInt(ave.A(), 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double radiusMouseBorder = (double)LabyMod.getInstance().getDrawUtils().getHeight() / 4.0 / 3.0;
        double midX = (double)draw.getWidth() / 2.0;
        double midY = (double)draw.getHeight() / 2.0;
        double lockedX = this.lockedYaw;
        double lockedY = this.lockedPitch;
        if (lockedY + radiusMouseBorder > 90.0) {
            lockedY = (float)(90.0 - radiusMouseBorder);
        }
        if (lockedY - radiusMouseBorder < -90.0) {
            lockedY = (float)(-90.0 + radiusMouseBorder);
        }
        double radius = (double)draw.getHeight() / 4.0;
        double offsetX = lockedX - (double)player.y;
        double offsetY = lockedY - (double)player.z;
        double distance = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
        double cursorX = midX - offsetX * 1.5;
        double cursorY = midY - offsetY * 1.5;
        String playerDisplayName = this.networkPlayerInfo == null || this.networkPlayerInfo.k() == null ? this.selectedPlayer.e_() : this.networkPlayerInfo.k().d();
        draw.drawCenteredString(playerDisplayName, midX += offsetX, (midY += offsetY) - radius / 2.5, radius / 70.0);
        bfl.E();
        bfl.d();
        bfl.l();
        long timePassed = System.currentTimeMillis() - this.selectionStarted;
        float animation = (float)((float)timePassed > 270.0f ? 1.0 : Math.sin((float)timePassed * 10.0f / 2000.0f));
        if (!LabyMod.getSettings().playerMenuAnimation) {
            animation = 1.0f;
        }
        float skullScale = (20.0f + (float)radius / 2.0f) * animation;
        bfl.b((float)((float)midX), (float)((float)midY), (float)0.0f);
        bfl.a((float)skullScale, (float)skullScale, (float)skullScale);
        bfl.b((float)((float)(cursorY - midY)), (float)-1.0f, (float)0.0f, (float)0.0f);
        bfl.b((float)((float)(cursorX - midX)), (float)0.0f, (float)1.0f, (float)0.0f);
        bfl.f();
        draw.renderSkull(this.selectedPlayer.cd());
        bfl.c();
        bfl.k();
        bfl.F();
        bfl.E();
        bfl.d();
        bfl.l();
        int index = 0;
        int amount = this.actionEntries.size();
        this.actionToExecute = null;
        if (amount != 0) {
            for (UserActionEntry entry : this.actionEntries) {
                this.drawUnit(entry, midX, midY, radius, amount, index, cursorX, cursorY, distance);
                ++index;
            }
        }
        bfl.c();
        bfl.k();
        bfl.F();
        if (offsetX == 0.0 && offsetY == 0.0) {
            cursorX = (int)cursorX;
            cursorY = (int)cursorY;
        }
        draw.drawRect(cursorX, cursorY - 4.0, cursorX + 1.0, cursorY + 5.0, Integer.MAX_VALUE);
        draw.drawRect(cursorX - 4.0, cursorY, cursorX + 5.0, cursorY + 1.0, Integer.MAX_VALUE);
    }

    private void drawUnit(UserActionEntry entry, double midX, double midY, double radius, int amount, int index, double cursorX, double cursorY, double distance) {
        double buttonWidth;
        boolean insideOfTwo;
        long timePassed = System.currentTimeMillis() - (this.selectionStarted - 1072L);
        float animation = (float)(timePassed < 1572L ? Math.sin((float)timePassed / 1000.0f) : 1.0);
        if (!LabyMod.getSettings().playerMenuAnimation) {
            animation = 1.0f;
        }
        double tau = Math.PI * 2;
        double destinationShift = 3.0707963267948966;
        double shift = destinationShift / (double)(animation * animation);
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        double xNext = midX + radius * 2.0 * Math.cos((double)(index + 1) * tau / (double)amount + shift);
        double yNext = midY + radius * 2.0 * Math.sin((double)(index + 1) * tau / (double)amount + shift);
        double xAfterNext = midX + radius * 2.0 * Math.cos((double)(index + 2) * tau / (double)amount + shift);
        double yAfterNext = midY + radius * 2.0 * Math.sin((double)(index + 2) * tau / (double)amount + shift);
        double x = midX + radius * Math.cos(((double)index + 1.5) * tau / (double)amount + shift);
        double y = midY + radius * Math.sin(((double)index + 1.5) * tau / (double)amount + shift);
        double finalDestX = midX + radius * Math.cos(((double)index + 1.5) * tau / (double)amount + destinationShift);
        double finalDestY = midY + radius * Math.sin(((double)index + 1.5) * tau / (double)amount + destinationShift);
        boolean bl = insideOfTwo = cursorY > midY && index == 0 || cursorY < midY && index != 0;
        boolean inside = amount > 2 ? this.isInside(cursorX, cursorY, xAfterNext, yAfterNext, midX, midY, xNext, yNext) : (amount == 1 ? true : insideOfTwo);
        boolean hover = distance > 10.0 && inside && timePassed > 1500L;
        double buttonHeight = buttonWidth = 256.0;
        double textureWidth = 9.0;
        double textureHeight = 9.0;
        double size = radius / 70.0;
        if (size < 3.0) {
            size = 1.0;
        }
        textureWidth *= size;
        textureHeight *= size;
        ave.A().P().a(ModTextures.MISC_MENU_POINT);
        if (hover) {
            GL11.glColor4f((float)0.2f, (float)1.0f, (float)0.2f, (float)1.0f);
        } else {
            GL11.glColor4f((float)0.23f, (float)0.7f, (float)1.0f, (float)1.0f);
        }
        if (finalDestX - midX > -10.0 && finalDestX - midX < 10.0) {
            if (finalDestY > midY) {
                draw.drawTexture(x - (double)((int)(textureWidth / 2.0)), y - 13.0, buttonWidth, buttonHeight, textureWidth, textureHeight);
            } else {
                draw.drawTexture(x - (double)((int)(textureWidth / 2.0)), y + 13.0, buttonWidth, buttonHeight, textureWidth, textureHeight);
            }
            this.drawOptionTag(entry, x, y, hover, radius, 0);
        } else if (finalDestX > midX) {
            if (finalDestY > midY) {
                draw.drawTexture(x - 13.0 * size, y, buttonWidth, buttonHeight, textureWidth, textureHeight);
            } else {
                draw.drawTexture(x - 13.0 * size, y, buttonWidth, buttonHeight, textureWidth, textureHeight);
            }
            this.drawOptionTag(entry, x, y, hover, radius, 1);
        } else {
            if (finalDestY > midY) {
                draw.drawTexture(x + 4.0, y, buttonWidth, buttonHeight, textureWidth, textureHeight);
            } else {
                draw.drawTexture(x + 4.0, y, buttonWidth, buttonHeight, textureWidth, textureHeight);
            }
            this.drawOptionTag(entry, x, y, hover, radius, -1);
        }
        GL11.glLineWidth((float)2.0f);
        ave.A().P().a(ModTextures.VOID);
        bfl.d();
        bfl.l();
    }

    private void drawOptionTag(UserActionEntry entry, double x, double y, boolean hover, double radius, int alignment) {
        String displayName = entry.getDisplayName();
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        int stringWidth = draw.getStringWidth(displayName);
        int tagPadding = hover ? 3 : 2;
        int tagHeight = 9;
        int backgroundColor = ModColor.toRGB(20, 20, 20, 100);
        int outlineColor = hover ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        double size = radius / 70.0;
        if (size < 3.0) {
            size = 1.0;
        }
        tagHeight = (int)((double)tagHeight * size);
        stringWidth = (int)((double)stringWidth * size);
        double tagX = x;
        double tagY = y + (double)tagHeight;
        if (alignment < 0) {
            tagX = x - (double)stringWidth;
        } else if (alignment == 0) {
            tagX = x - (double)stringWidth / 2.0;
        }
        draw.drawRect(tagX - (double)tagPadding, tagY - (double)tagHeight - (double)tagPadding, tagX + (double)stringWidth + (double)tagPadding, tagY + (double)tagPadding, backgroundColor);
        draw.drawRectBorder(tagX - (double)tagPadding - 1.0, tagY - (double)tagHeight - (double)tagPadding - 1.0, tagX + (double)stringWidth + (double)tagPadding + 1.0, tagY + (double)tagPadding + 1.0, outlineColor, 1.0);
        switch (alignment) {
            case -1: {
                draw.drawRightString(displayName, x, y, size);
                break;
            }
            case 0: {
                draw.drawCenteredString(displayName, x, y, size);
                break;
            }
            case 1: {
                draw.drawString(displayName, x, y, size);
            }
        }
        if (hover) {
            this.actionToExecute = entry;
        }
    }

    private double sign(double px1, double py1, double px2, double py2, double px3, double py3) {
        return (px1 - px3) * (py2 - py3) - (px2 - px3) * (py1 - py3);
    }

    private boolean isInside(double pointX, double pointY, double px1, double py1, double px2, double py2, double px3, double py3) {
        boolean b1 = this.sign(pointX, pointY, px1, py1, px2, py2) < 0.0;
        boolean b2 = this.sign(pointX, pointY, px2, py2, px3, py3) < 0.0;
        boolean b3 = this.sign(pointX, pointY, px3, py3, px1, py1) < 0.0;
        return b1 == b2 && b2 == b3;
    }

    public void tick() {
        boolean pressed;
        if (!LabyMod.getSettings().playerMenu) {
            return;
        }
        boolean inGame = LabyMod.getInstance().isInGame();
        if (!inGame) {
            if (this.serverEntries.size() != 0) {
                this.serverEntries.clear();
            }
            return;
        }
        boolean alternativeKeyPressed = this.isPressed(LabyMod.getSettings().keyPlayerMenu);
        boolean middleMouseButtonpressed = LabyMod.getSettings().keyPlayerMenu == -1 && Mouse.isButtonDown((int)2);
        boolean bl = pressed = (middleMouseButtonpressed || alternativeKeyPressed) && ave.A().t.aB == 0;
        if (pressed && ave.A().m == null) {
            if (!this.middleMousePressed) {
                this.middleMousePressed = true;
                pk entity = LabyModCore.getMinecraft().getEntityMouseOver();
                if (entity != null && entity instanceof wn && LabyMod.getInstance().getServerManager().isAllowed(Permissions.Permission.CHAT)) {
                    this.open((wn)entity);
                }
            }
        } else if (this.middleMousePressed) {
            this.middleMousePressed = false;
            if (this.actionToExecute != null && this.selectedUser != null && this.selectedPlayer != null && this.networkPlayerInfo != null) {
                this.actionToExecute.execute(this.selectedUser, this.selectedPlayer, this.networkPlayerInfo);
            }
            this.close();
        }
    }

    private boolean isPressed(int key) {
        return key != -1 && (key < 0 ? Mouse.isButtonDown((int)(key + 100)) : Keyboard.isKeyDown((int)key));
    }

    public void lockMouseMovementInCircle() {
        float newY;
        double distanceY;
        float newX;
        double distanceX;
        double distance;
        if (this.selectedPlayer == null) {
            return;
        }
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null) {
            return;
        }
        double radius = (double)LabyMod.getInstance().getDrawUtils().getHeight() / 4.0 / 3.0;
        float centerX = this.lockedYaw;
        float centerY = this.lockedPitch;
        if ((double)centerY + radius > 90.0) {
            centerY = (float)(90.0 - radius);
        }
        if ((double)centerY - radius < -90.0) {
            centerY = (float)(-90.0 + radius);
        }
        if ((distance = Math.sqrt((distanceX = (double)(centerX - (newX = player.y))) * distanceX + (distanceY = (double)(centerY - (newY = player.z))) * distanceY)) > radius) {
            double fromOriginToObjectX = newX - centerX;
            double fromOriginToObjectY = newY - centerY;
            double multiplier = radius / distance;
            centerX = (float)((double)centerX + (fromOriginToObjectX *= multiplier));
            centerY = (float)((double)centerY + (fromOriginToObjectY *= multiplier));
            player.y = centerX;
            player.A = centerX;
            player.z = centerY;
            player.B = centerY;
        }
    }

    public boolean isOpen() {
        return this.selectedPlayer != null;
    }
}

