/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.gui;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.labymod.core.LabyModCore;
import net.labymod.gui.elements.ModTextField;
import net.labymod.main.LabyMod;
import net.labymod.main.ModSettings;
import net.labymod.main.ModTextures;
import net.labymod.main.Source;
import net.labymod.main.lang.LanguageManager;
import net.labymod.user.User;
import net.labymod.user.UserManager;
import net.labymod.user.cosmetic.custom.AnimatedResourceLocation;
import net.labymod.user.cosmetic.custom.UserTextureContainer;
import net.labymod.user.cosmetic.custom.handler.StickerImageHandler;
import net.labymod.user.sticker.StickerRegistry;
import net.labymod.user.sticker.data.Sticker;
import net.labymod.user.sticker.data.StickerPack;
import net.labymod.utils.DrawUtils;
import net.labymod.utils.ModColor;
import net.labymod.utils.manager.TooltipHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class StickerSelectorGui
extends avp {
    private static final jy POP_SOUND = new jy(Source.ABOUT_MC_VERSION.startsWith("1.8") ? "random.pop" : "entity.chicken.egg");
    private static final int ANIMATION_SPEED = 100;
    private static Field fieldPressTime;
    private static Field fieldLeftClickCounter;
    private boolean open = false;
    private long lastOpened;
    private int selectedItemIndex;
    private ModTextField fieldSearch;
    private boolean hoverSearchBar;
    private float lockedYaw = 0.0f;
    private float lockedPitch = 0.0f;
    private boolean prevCrosshairState;
    private short lastHoveredStickerId = (short)-1;
    private int hotkeySelectedSticker = -1;
    private short lastAcceptedHoveredStickerId = (short)-1;
    private long lastHoveredStickerChanged;
    private int hoverStickerIndex = -1;
    private double lastSelectorWidth;
    private double lastSelectorHeight;
    private List<Sticker> filteredStickers;
    private boolean searchOpened = false;
    private List<String> packTitles;
    private int searchMouseX;
    private int searchMouseY;
    private int page = 0;
    private int acceptedPage = 0;
    private int animationState = 0;
    private long pageAnimation = 0L;

    public void open() {
        if (this.open) {
            return;
        }
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null) {
            return;
        }
        this.open = true;
        this.page = 0;
        this.selectedItemIndex = LabyModCore.getMinecraft().getPlayer().bi.c;
        this.hotkeySelectedSticker = -1;
        this.lastAcceptedHoveredStickerId = (short)-1;
        this.lockedYaw = player.y;
        this.lockedPitch = player.z;
        this.fieldSearch = new ModTextField(0, LabyModCore.getMinecraft().getFontRenderer(), 0, 0, 0, 20);
        this.fieldSearch.setBlackBox(false);
        this.fieldSearch.setEnableBackgroundDrawing(false);
        this.searchOpened = false;
        this.prevCrosshairState = LabyMod.getInstance().getLabyModAPI().isCrosshairHidden();
        LabyMod.getInstance().getLabyModAPI().setCrosshairHidden(true);
        if (fieldLeftClickCounter == null) {
            try {
                fieldLeftClickCounter = ReflectionHelper.findField(ave.class, LabyModCore.getMappingAdapter().getLeftClickCounterMappings());
                fieldLeftClickCounter.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (fieldPressTime == null) {
            try {
                fieldPressTime = ReflectionHelper.findField(avb.class, LabyModCore.getMappingAdapter().getPressTimeMappings());
                fieldPressTime.setAccessible(true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.filter("");
        if (System.currentTimeMillis() - this.lastOpened < 300L) {
            ave.A().a((axu)new SearchGui(this, this.fieldSearch));
            this.searchOpened = true;
            this.animationState = 0;
        } else {
            this.searchOpened = false;
        }
        this.lastOpened = System.currentTimeMillis();
    }

    public void close() {
        if (!this.open) {
            return;
        }
        if (!this.searchOpened && this.hoverSearchBar) {
            this.searchOpened = true;
            ave.A().a((axu)new SearchGui(this, this.fieldSearch));
            return;
        }
        this.searchOpened = false;
        this.open = false;
        LabyMod.getInstance().getLabyModAPI().setCrosshairHidden(this.prevCrosshairState);
        this.updateScrollLock(false);
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null) {
            return;
        }
        player.y = this.lockedYaw;
        player.z = this.lockedPitch;
        if (this.lastHoveredStickerId != -1) {
            LabyModCore.getMinecraft().playSound(POP_SOUND, 1.0f);
            LabyMod.getInstance().getStickerRegistry().playSticker(LabyMod.getInstance().getUserManager().getUser(player.aK()), this.lastHoveredStickerId);
            ModSettings settings = LabyMod.getSettings();
            try {
                int i;
                boolean swap = false;
                for (i = 0; i < settings.stickerHistory.length; ++i) {
                    if (settings.stickerHistory[i] != this.lastHoveredStickerId) continue;
                    swap = true;
                }
                if (!swap) {
                    settings.stickerHistory[settings.stickerHistory.length - 1] = -1;
                    for (i = settings.stickerHistory.length - 2; i >= 0; --i) {
                        if (settings.stickerHistory[i + 1] != -1) continue;
                        settings.stickerHistory[i + 1] = settings.stickerHistory[i];
                        settings.stickerHistory[i] = -1;
                    }
                    settings.stickerHistory[0] = this.lastHoveredStickerId;
                    LabyMod.getMainConfig().save();
                }
            }
            catch (Exception error) {
                error.printStackTrace();
                settings.stickerHistory = new short[]{-1, -1, -1, -1, -1};
                LabyMod.getMainConfig().save();
            }
        }
    }

    private void updateScrollLock(boolean locked) {
        avh gameSettings = ave.A().t;
        if (gameSettings == null) {
            return;
        }
        avb keyBinding = gameSettings.aw[this.selectedItemIndex];
        if (keyBinding == null) {
            return;
        }
        int keyCode = keyBinding.i();
        avb.a((int)keyCode, (boolean)locked);
        if (locked) {
            avb.a((int)keyCode);
        } else {
            try {
                if (fieldPressTime != null) {
                    fieldPressTime.setInt(keyBinding, 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void filter(String searchString) {
        bew player = LabyModCore.getMinecraft().getPlayer();
        User user = LabyMod.getInstance().getUserManager().getUser(player.aK());
        List<Short> stickerPacks = user.getStickerPacks();
        ArrayList<Sticker> filteredStickers = new ArrayList<Sticker>();
        StickerRegistry stickerRegistry = LabyMod.getInstance().getStickerRegistry();
        if (stickerRegistry.getStickerData() != null && stickerRegistry.getStickerData().getPacks() != null) {
            if (searchString.isEmpty()) {
                ArrayList<String> packTitles = new ArrayList<String>();
                ModSettings settings = LabyMod.getSettings();
                for (int i = 0; i < settings.stickerHistory.length; ++i) {
                    int id = settings.stickerHistory[i];
                    if (id == -1 && packTitles.isEmpty()) continue;
                    filteredStickers.add(id == -1 ? null : stickerRegistry.getSticker((short)id));
                    if (!packTitles.isEmpty()) continue;
                    packTitles.add(LanguageManager.translate("sticker_history"));
                }
                for (StickerPack stickerPack : stickerRegistry.getStickerData().getPacks()) {
                    if (!stickerPacks.contains(stickerPack.getId())) continue;
                    for (Sticker sticker : stickerPack.getStickers()) {
                        filteredStickers.add(sticker);
                    }
                    packTitles.add(stickerPack.getName());
                }
                this.packTitles = packTitles;
                this.filteredStickers = filteredStickers;
            } else {
                searchString = searchString.toLowerCase();
                for (StickerPack stickerPack : stickerRegistry.getStickerData().getPacks()) {
                    if (!stickerPacks.contains(stickerPack.getId())) continue;
                    if (stickerPack.getName().toLowerCase().contains(searchString)) {
                        for (Sticker sticker : stickerPack.getStickers()) {
                            filteredStickers.add(sticker);
                        }
                        continue;
                    }
                    for (Sticker sticker : stickerPack.getStickers()) {
                        if (sticker.getName().toLowerCase().contains(searchString)) {
                            filteredStickers.add(sticker);
                            continue;
                        }
                        for (String tag : sticker.getTags()) {
                            if (!tag.toLowerCase().contains(searchString)) continue;
                            filteredStickers.add(sticker);
                        }
                    }
                }
            }
        }
        this.filteredStickers = filteredStickers;
    }

    public void render() {
        if (!this.open) {
            return;
        }
        bew player = LabyModCore.getMinecraft().getPlayer();
        UserManager userManager = LabyMod.getInstance().getUserManager();
        User user = userManager.getUser(player.aK());
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        try {
            if (fieldLeftClickCounter != null) {
                fieldLeftClickCounter.setInt(ave.A(), 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long timePassed = System.currentTimeMillis() - this.lastOpened;
        if (timePassed > 2000L) {
            timePassed = 2000L;
        }
        double stickerSize = (double)draw.getHeight() / 8.0 - Math.exp((double)(-timePassed) / 100.0) * 10.0;
        double padding = 2.0;
        double midX = (double)draw.getWidth() / 2.0;
        double midY = (double)draw.getHeight() / 2.0 - (stickerSize / 2.0 + padding);
        double lockedX = this.lockedYaw;
        double lockedY = this.lockedPitch;
        double radiusY = this.lastSelectorHeight / 3.0;
        if (lockedY + radiusY > 90.0) {
            lockedY = (float)(90.0 - radiusY);
        }
        if (lockedY - radiusY < -90.0) {
            lockedY = (float)(-90.0 + radiusY);
        }
        double offsetX = lockedX - (double)player.y;
        double offsetY = lockedY - (double)player.z;
        if (ave.A().t.aB == 0) {
            midX += offsetX;
            midY += offsetY;
        }
        int stickerPerPage = 5;
        int totalSticker = this.filteredStickers.size();
        int maxPages = (int)Math.ceil((double)totalSticker / (double)stickerPerPage);
        int stickerIndex = this.page * stickerPerPage;
        int acceptedStickerIndex = this.acceptedPage * stickerPerPage;
        double selectorWidth = (double)stickerPerPage * (stickerSize + 1.0) - 1.0;
        draw.drawRect(midX - selectorWidth / 2.0 - padding, midY - stickerSize / 2.0 - padding, midX + selectorWidth / 2.0 + padding, midY + stickerSize / 2.0 + padding, Integer.MIN_VALUE);
        double cursorX = midX - offsetX * 1.5;
        double cursorY = midY - offsetY * 1.5 + stickerSize / 2.0 + padding;
        if (this.searchOpened) {
            cursorX = this.searchMouseX;
            cursorY = this.searchMouseY;
            offsetX = this.searchMouseX - draw.getWidth() / 2;
            offsetY = this.searchMouseY - draw.getHeight() / 2;
        }
        int searchFieldHeight = 10;
        boolean searchAreaGap = true;
        draw.drawRect(midX - selectorWidth / 2.0 - padding, midY + stickerSize / 2.0 + padding + (double)searchAreaGap, midX + selectorWidth / 2.0 + padding, midY + stickerSize / 2.0 + padding + (double)searchFieldHeight + padding * 2.0 + (double)searchAreaGap + 2.0, Integer.MIN_VALUE);
        double fieldX = midX - selectorWidth / 2.0 + 1.0;
        double fieldY = midY + stickerSize / 2.0 + padding + (double)searchAreaGap + padding + 1.0;
        this.fieldSearch.width = (int)selectorWidth - 2;
        this.fieldSearch.height = searchFieldHeight;
        this.fieldSearch.xPosition = (int)fieldX + 1;
        this.fieldSearch.yPosition = (int)fieldY + 2;
        this.hoverSearchBar = cursorX > fieldX - 1.0 && cursorX < fieldX + selectorWidth - 1.0 && cursorY > fieldY - 1.0 && cursorY < fieldY + (double)this.fieldSearch.height + 1.0;
        draw.drawRect(fieldX - 1.0, fieldY - 1.0, fieldX + selectorWidth - 1.0, fieldY + (double)this.fieldSearch.height + 1.0, this.hoverSearchBar ? ModColor.toRGB(255, 255, 170, 100) : Integer.MAX_VALUE);
        if (!this.fieldSearch.isFocused()) {
            draw.drawString(LanguageManager.translate("search_textbox_placeholder"), fieldX + 1.0, fieldY + 1.0);
        }
        this.drawStickerRow(midX, midY, cursorX, cursorY, stickerPerPage, totalSticker, stickerIndex, stickerSize, selectorWidth, user, this.filteredStickers, 0);
        this.drawStickerRow(midX, midY, cursorX, cursorY, stickerPerPage, totalSticker, stickerIndex, stickerSize, selectorWidth, user, this.filteredStickers, -1);
        this.drawStickerRow(midX, midY, cursorX, cursorY, stickerPerPage, totalSticker, acceptedStickerIndex, stickerSize, selectorWidth, user, this.filteredStickers, 1);
        double pageDisplayX = midX + selectorWidth / 2.0 + padding + 1.0;
        double pageDisplayY = midY - stickerSize / 2.0 - padding;
        for (int i = 0; i < maxPages; ++i) {
            boolean selected = this.page == i;
            bfl.E();
            bfl.d();
            GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            ave.A().P().a(ModTextures.MISC_MENU_POINT);
            draw.drawTexture(pageDisplayX, pageDisplayY, 255.0, 255.0, 3.0, 3.0, selected ? 1.1f : 0.2f);
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
            bfl.F();
            pageDisplayY += 4.0;
            if (!(pageDisplayY > midY + stickerSize / 2.0 + padding)) continue;
            pageDisplayY = midY - stickerSize / 2.0 - padding;
            pageDisplayX += 4.0;
        }
        String title = this.packTitles == null || this.packTitles.isEmpty() ? LanguageManager.translate("sticker_title") : this.packTitles.get(this.page);
        double titleWidth = draw.getStringWidth(title);
        double titleOffsetY = -15.0;
        double titlePadding = 3.0;
        draw.drawRect(midX - titleWidth / 2.0 - titlePadding, midY - stickerSize / 2.0 + titleOffsetY - titlePadding, midX + titleWidth / 2.0 + titlePadding, midY - stickerSize / 2.0 + titleOffsetY + 7.0 + titlePadding, Integer.MIN_VALUE);
        draw.drawCenteredString(title, midX, midY - stickerSize / 2.0 + titleOffsetY);
        if (this.filteredStickers.isEmpty() && !this.searchOpened) {
            double statusY = midY + stickerSize / 2.0 + padding * 5.0 + (double)searchAreaGap + (double)searchFieldHeight;
            draw.drawCenteredString(LanguageManager.translate("sticker_status_no_stickers"), midX, statusY, 0.8);
        } else if (maxPages > 1 && this.page == 0) {
            double statusY = midY + stickerSize / 2.0 + padding * 5.0 + (double)searchAreaGap + (double)searchFieldHeight;
            draw.drawCenteredString(ModColor.cl('7') + LanguageManager.translate("sticker_info_scroll"), midX, statusY, 0.8);
        }
        if (offsetX == 0.0 && offsetY == 0.0) {
            cursorX = (int)cursorX;
            cursorY = (int)cursorY;
        }
        if (!this.searchOpened) {
            draw.drawRect(cursorX, cursorY - 4.0, cursorX + 1.0, cursorY + 5.0, Integer.MAX_VALUE);
            draw.drawRect(cursorX - 4.0, cursorY, cursorX + 5.0, cursorY + 1.0, Integer.MAX_VALUE);
        }
        this.lastSelectorWidth = selectorWidth + padding * 2.0;
        this.lastSelectorHeight = padding + stickerSize + padding + (double)searchAreaGap + padding + (double)searchFieldHeight + padding;
        this.handleMouseInput(maxPages - 1);
    }

    private void handleMouseInput(int maxPages) {
        boolean moveDown;
        double scroll = Mouse.getDWheel();
        boolean moveUp = scroll > 0.0;
        boolean bl = moveDown = scroll < 0.0;
        if (!(this.hoverStickerIndex != -1 || !moveUp && !moveDown || moveDown && this.acceptedPage == maxPages && this.hotkeySelectedSticker == 0 || moveUp && this.acceptedPage == 0 && this.hotkeySelectedSticker == 4)) {
            int value = this.hotkeySelectedSticker + (moveUp ? 1 : -1);
            int n = this.hotkeySelectedSticker = value < 0 ? 4 : value % 5;
            if (!(!moveUp && value == -1 || moveUp && value == 5)) {
                moveDown = false;
                moveUp = false;
            }
        }
        try {
            int stickerPerPage = 5;
            for (int i = 0; i < stickerPerPage; ++i) {
                int code = ave.A().t.aw[i].i();
                if (code < 0 || !Keyboard.isKeyDown((int)code)) continue;
                this.hotkeySelectedSticker = stickerPerPage - 1 - i;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        if (Mouse.isButtonDown((int)0)) {
            moveUp = true;
        }
        if (Mouse.isButtonDown((int)1)) {
            moveDown = true;
        }
        if (this.acceptedPage == this.page && this.animationState == 0) {
            if (moveUp && this.page > 0) {
                --this.page;
                this.animationState = -1;
                this.pageAnimation = System.currentTimeMillis();
            }
            if (moveDown && this.page < maxPages) {
                ++this.page;
                this.animationState = 1;
                this.pageAnimation = System.currentTimeMillis();
            }
        } else if (!moveUp && !moveDown && this.animationState != -1 && this.animationState != 1) {
            this.acceptedPage = this.page;
        }
        if ((this.animationState == -1 || this.animationState == 1) && this.pageAnimation + 100L < System.currentTimeMillis()) {
            this.animationState *= 2;
        }
        if ((this.animationState == -2 || this.animationState == 2) && this.pageAnimation + 100L < System.currentTimeMillis()) {
            this.animationState = 0;
        }
    }

    private void drawStickerRow(double midX, double midY, double cursorX, double cursorY, int stickerPerPage, int totalSticker, int stickerIndex, double stickerSize, double selectorWidth, User user, List<Sticker> stickers, int animationChannel) {
        DrawUtils draw = LabyMod.getInstance().getDrawUtils();
        long timePassed = System.currentTimeMillis() - this.pageAnimation;
        double percentage = 0.01 * (double)timePassed;
        double animation = this.animationState == 0 ? 1.0 : Math.min(percentage, 1.0);
        boolean increased = this.page < this.acceptedPage;
        boolean lowBound = animationChannel == (increased ? 1 : -1);
        this.lastHoveredStickerId = (short)-1;
        this.hoverStickerIndex = -1;
        if (animationChannel == 1) {
            animation = 1.0 - animation;
        }
        double lowOffset = (stickerSize - 2.0) * (1.0 - animation);
        for (int index = stickerPerPage - 1; index >= 0; --index) {
            Short id;
            double x = midX - selectorWidth / 2.0 + (double)(stickerPerPage - index - 1) * (stickerSize + 1.0);
            double y = midY - stickerSize / 2.0;
            boolean hover = cursorX > x && cursorX < x + stickerSize && cursorY > y && cursorY < y + stickerSize;
            Sticker sticker = stickerIndex >= totalSticker ? null : stickers.get(stickerIndex);
            Short s = id = sticker == null ? null : Short.valueOf(sticker.getId());
            if (hover) {
                this.hoverStickerIndex = index;
            }
            if (hover && id != null) {
                this.hotkeySelectedSticker = -1;
            }
            if (this.hotkeySelectedSticker != -1 && this.hotkeySelectedSticker == index) {
                hover = true;
            }
            double brightness = 0.0;
            if (hover && id != null) {
                brightness = 185.0 + 185.0 * -Math.exp((double)(-(System.currentTimeMillis() - this.lastHoveredStickerChanged)) / 500.0);
            }
            if (animationChannel == 0) {
                draw.drawRect(x, y, x + stickerSize, y + stickerSize, ModColor.toRGB((int)brightness, (int)brightness, (int)brightness, 50));
                continue;
            }
            double currentStickerSize = stickerSize - 2.0;
            double hoverOffset = 0.0;
            if (hover && id != null) {
                this.lastHoveredStickerId = id;
                if (this.lastAcceptedHoveredStickerId != id) {
                    this.lastAcceptedHoveredStickerId = id;
                    this.lastHoveredStickerChanged = System.currentTimeMillis();
                }
            }
            if (hover) {
                double popUp = 10.0 + 10.0 * -Math.exp((double)(-(System.currentTimeMillis() - this.lastHoveredStickerChanged)) / 100.0);
                hoverOffset = popUp / 2.0;
                currentStickerSize += popUp;
            }
            bfl.E();
            bfl.a((double)1.0, (double)animation, (double)1.0);
            this.drawSticker(x + 1.0 - hoverOffset, (y + 1.0 - hoverOffset + (lowBound ? lowOffset : 0.0)) / animation, currentStickerSize, id, user);
            bfl.F();
            ++stickerIndex;
        }
    }

    private void drawSticker(double x, double y, double size, Short stickerId, User user) {
        UserTextureContainer container;
        UserManager userManager = LabyMod.getInstance().getUserManager();
        StickerImageHandler stickerHandler = userManager.getCosmeticImageManager().getStickerImageHandler();
        if (stickerHandler != null && stickerId != null && stickerId != -1 && (container = stickerHandler.getContainer(user, stickerId)) != null) {
            container.validateTexture(stickerHandler);
            AnimatedResourceLocation resourceLocation = stickerHandler.getResourceLocations().get(container.getFileName());
            if (resourceLocation != null) {
                double scale = size / 20.0;
                double textureSizeX = 115.90909090909092;
                double textureSizeY = 231.81818181818184;
                double textureOffsetX = 11.590909090909092;
                double textureOffsetY = 23.181818181818183;
                bfl.E();
                bfl.c((float)1.0f, (float)1.1f, (float)1.0f, (float)1.0f);
                bfl.a((double)scale, (double)scale, (double)1.0);
                ave.A().P().a(resourceLocation.getDefault());
                LabyMod.getInstance().getDrawUtils().drawTexture(x / scale, y / scale, textureOffsetX, textureOffsetY, textureSizeX, textureSizeY, 20.0, 20.0);
                bfl.F();
            }
        }
    }

    public void pointSearchMouse(int mouseX, int mouseY) {
        Sticker sticker;
        this.searchMouseX = mouseX;
        this.searchMouseY = mouseY;
        if (this.lastHoveredStickerId != -1 && (sticker = LabyMod.getInstance().getStickerRegistry().getSticker(this.lastHoveredStickerId)) != null) {
            TooltipHelper.getHelper().pointTooltip(mouseX, mouseY, sticker.getName());
        }
    }

    public void lockMouseMovementInCircle() {
        double multiplier;
        if (!this.open) {
            return;
        }
        bew player = LabyModCore.getMinecraft().getPlayer();
        if (player == null) {
            return;
        }
        double radiusX = this.lastSelectorWidth / 3.0;
        double radiusY = this.lastSelectorHeight / 3.0;
        float centerX = this.lockedYaw;
        float centerY = this.lockedPitch + 5.0f - 16.0f;
        if ((double)centerY + radiusY > 90.0) {
            centerY = (float)(90.0 - radiusY);
        }
        if ((double)centerY - radiusY < -90.0) {
            centerY = (float)(-90.0 + radiusY);
        }
        float newX = player.y;
        float newY = player.z;
        double distanceX = Math.abs(centerX - newX);
        double distanceY = Math.abs(centerY - newY);
        if (distanceX > radiusX) {
            double fromOriginToObjectX = newX - centerX;
            multiplier = radiusX / distanceX;
            player.y = centerX = (float)((double)centerX + (fromOriginToObjectX *= multiplier));
            player.A = centerX;
        }
        if (distanceY > radiusY) {
            double fromOriginToObjectY = newY - centerY;
            multiplier = radiusY / distanceY;
            player.z = centerY = (float)((double)centerY + (fromOriginToObjectY *= multiplier));
            player.B = centerY;
        }
        this.updateScrollLock(true);
    }

    public boolean isOpen() {
        return this.open;
    }

    public static class SearchGui
    extends axu {
        private StickerSelectorGui stickerSelectorGui;
        private ModTextField textField;

        public SearchGui(StickerSelectorGui stickerSelectorGui, ModTextField textField) {
            this.stickerSelectorGui = stickerSelectorGui;
            this.textField = textField;
        }

        public void b() {
            super.b();
            this.textField.setFocused(true);
        }

        public void m() {
            super.m();
            this.stickerSelectorGui.close();
        }

        public void a(int mouseX, int mouseY, float partialTicks) {
            super.a(mouseX, mouseY, partialTicks);
            this.stickerSelectorGui.pointSearchMouse(mouseX, mouseY);
            this.textField.drawTextBox();
        }

        public void e() {
            super.e();
            this.textField.updateCursorCounter();
        }

        protected void a(char typedChar, int keyCode) throws IOException {
            super.a(typedChar, keyCode);
            if (this.textField.textboxKeyTyped(typedChar, keyCode)) {
                this.stickerSelectorGui.filter(this.textField.getText());
            }
        }

        protected void a(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.a(mouseX, mouseY, mouseButton);
            if (this.textField.mouseClicked(mouseX, mouseY, mouseButton)) {
                return;
            }
            this.stickerSelectorGui.pointSearchMouse(mouseX, mouseY);
            ave.A().a(null);
            this.stickerSelectorGui.close();
        }

        protected void a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
            super.a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
            this.stickerSelectorGui.pointSearchMouse(mouseX, mouseY);
        }
    }
}

