/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.emote;

import java.util.UUID;
import net.labymod.core.LabyModCore;
import net.labymod.main.LabyMod;
import net.labymod.main.Source;
import net.labymod.user.emote.keys.EmoteBodyPart;
import net.labymod.user.emote.keys.EmotePose;
import net.labymod.user.emote.keys.PoseAtTime;
import net.labymod.user.emote.keys.provider.EmoteProvider;

public class EmoteRenderer {
    private UUID uuid;
    private short emoteId;
    private long timeout;
    private boolean stream;
    private EmoteProvider emoteProvider;
    private long startTime = System.currentTimeMillis();
    private PoseAtTime[] emotePosesAtTime = new PoseAtTime[7];
    private boolean aborted = false;
    private long resetKeyframeEnd = -1L;
    private EmoteBodyPart[] bodyParts;
    private float fadedYaw;
    private float fadedPitch;
    private boolean visible = true;
    private boolean mc18 = Source.ABOUT_MC_VERSION.startsWith("1.8");

    public EmoteRenderer(UUID uuid, short emoteId, long timeout, boolean stream, EmoteProvider emoteProvider, EmoteRenderer prevRenderer) {
        this.uuid = uuid;
        this.emoteId = emoteId;
        this.timeout = timeout;
        this.stream = stream;
        this.emoteProvider = emoteProvider;
        this.bodyParts = new EmoteBodyPart[7];
        for (int i = 0; i < this.bodyParts.length; ++i) {
            this.bodyParts[i] = new EmoteBodyPart(i);
        }
        if (prevRenderer != null) {
            for (EmoteBodyPart bodyPart : this.bodyParts = prevRenderer.getBodyParts()) {
                bodyPart.cancel();
            }
        }
    }

    public void checkForNextFrame() {
        int bodyPartId;
        long currentTick = System.currentTimeMillis() - this.startTime;
        if (this.emoteProvider.isWaiting()) {
            return;
        }
        boolean shouldReset = true;
        if (this.resetKeyframeEnd == -1L) {
            for (bodyPartId = 0; bodyPartId < this.emotePosesAtTime.length; ++bodyPartId) {
                PoseAtTime nextPose;
                PoseAtTime emotePose = this.emotePosesAtTime[bodyPartId];
                if (emotePose != null && emotePose.getOffset() >= currentTick || this.emoteProvider.hasNext(bodyPartId)) {
                    shouldReset = false;
                }
                if (emotePose != null && emotePose.getOffset() >= currentTick || !this.emoteProvider.hasNext(bodyPartId)) continue;
                this.emotePosesAtTime[bodyPartId] = nextPose = this.emoteProvider.next(bodyPartId);
                this.bindNextPose(nextPose);
            }
        }
        if (shouldReset) {
            if (this.resetKeyframeEnd == -1L) {
                this.resetKeyframeEnd = currentTick + this.timeout;
                for (bodyPartId = 0; bodyPartId < this.emotePosesAtTime.length; ++bodyPartId) {
                    EmotePose pose = new EmotePose(bodyPartId, 0.0f, 0.0f, 0.0f, false);
                    for (EmoteBodyPart bodyPart : this.bodyParts) {
                        if (bodyPart.getId() != pose.getBodyPart()) continue;
                        bodyPart.cancel();
                        bodyPart.applyPose(pose, this.timeout);
                    }
                }
            } else if (this.resetKeyframeEnd < currentTick && !this.aborted) {
                this.aborted = true;
                if (this.aborted) {
                    LabyMod.getInstance().getEmoteRegistry().setCleanPlayingMap(true);
                }
            }
        }
    }

    public void bindNextPose(PoseAtTime poseAtTime) {
        for (EmoteBodyPart bodyPart : this.bodyParts) {
            if (bodyPart.getId() != poseAtTime.getPose().getBodyPart()) continue;
            bodyPart.applyPose(poseAtTime.getPose(), poseAtTime.isAnimate() ? poseAtTime.getOffset() : 0L);
        }
    }

    public void animate() {
        for (EmoteBodyPart bodyPart : this.bodyParts) {
            bodyPart.animateOnTime();
        }
    }

    public void transformEntity(pk entity, boolean firstPerson, float yaw, float pitch) {
        if (this.aborted || !this.visible) {
            return;
        }
        if (!this.mc18 && ave.A().t.aB == 0) {
            this.checkForNextFrame();
            this.animate();
        }
        this.fadedYaw = yaw;
        this.fadedPitch = pitch;
        for (EmoteBodyPart bodyPart : this.bodyParts) {
            block6: for (PoseAtTime pose : this.emotePosesAtTime) {
                if (pose == null || pose.getPose().getBodyPart() != bodyPart.getId()) continue;
                switch (bodyPart.getId()) {
                    case 0: {
                        float diff;
                        float maxFade;
                        float emoteYaw = bodyPart.getX() * 57.295776f / 2.0f;
                        float emotePitch = bodyPart.getY() * 57.295776f / 2.0f;
                        if (this.stream || this.timeout == 0L) {
                            this.fadedYaw = emoteYaw;
                            this.fadedPitch = emotePitch;
                            continue block6;
                        }
                        long currentTick = System.currentTimeMillis() - this.startTime;
                        long keyframeEnd = this.resetKeyframeEnd;
                        float fadeIn = maxFade - ((float)currentTick > (maxFade = (float)this.timeout) ? maxFade : (float)currentTick);
                        float fadeOut = this.timeout - (currentTick > keyframeEnd ? 0L : keyframeEnd - currentTick);
                        float fade = fadeIn;
                        if (keyframeEnd != -1L) {
                            fade = fadeOut;
                        }
                        float rangeYaw = (diff = (yaw - emoteYaw + 180.0f) % 360.0f - 180.0f) < -180.0f ? diff + 360.0f : diff;
                        this.fadedYaw = emoteYaw + rangeYaw / maxFade * fade;
                        float rangePitch = pitch - emotePitch;
                        this.fadedPitch = emotePitch + rangePitch / maxFade * fade;
                        continue block6;
                    }
                    case 5: {
                        bfl.b((float)0.0f, (float)(firstPerson ? 1.0f : 0.4f), (float)0.0f);
                        int modifier = firstPerson ? -1 : 1;
                        bfl.b((float)(bodyPart.getX() * 57.295776f * (float)modifier), (float)1.0f, (float)0.0f, (float)0.0f);
                        bfl.b((float)(bodyPart.getY() * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                        bfl.b((float)(bodyPart.getZ() * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                        bfl.b((float)0.0f, (float)(firstPerson ? -1.0f : -0.4f), (float)0.0f);
                        continue block6;
                    }
                    case 6: {
                        bfl.b((double)((double)bodyPart.getX() / 10.0), (double)((double)bodyPart.getY() / 10.0), (double)((double)bodyPart.getZ() / 10.0));
                    }
                }
            }
        }
        if (Math.abs(entity.p - entity.s) > 0.04 || Math.abs(entity.q - entity.t) > 0.04 || Math.abs(entity.r - entity.u) > 0.04) {
            for (PoseAtTime poseAtTime : this.emotePosesAtTime) {
                if (poseAtTime == null || !poseAtTime.getPose().isBlockMovement()) continue;
                this.abort();
                break;
            }
        }
        if (entity instanceof wn && ((wn)entity).au != 0) {
            this.abort();
        }
        if (LabyModCore.getMinecraft().isElytraFlying(entity)) {
            this.abort();
        }
    }

    public void transformModel(bbj model) {
        if (ave.A().t.aB == 0) {
            this.checkForNextFrame();
            this.animate();
            ave.A().g.m();
        }
        if (model == null || this.aborted || !this.visible) {
            return;
        }
        for (EmoteBodyPart bodyPart : this.bodyParts) {
            for (PoseAtTime pose : this.emotePosesAtTime) {
                if (pose != null && pose.getPose().getBodyPart() == bodyPart.getId()) {
                    switch (bodyPart.getId()) {
                        case 0: {
                            model.e.g = this.getFadedYaw() / 57.295776f;
                            model.e.f = this.getFadedPitch() / 57.295776f;
                            break;
                        }
                        case 1: {
                            model.h.f = bodyPart.getX();
                            model.h.g = bodyPart.getY();
                            model.h.h = bodyPart.getZ();
                            break;
                        }
                        case 2: {
                            model.i.f = bodyPart.getX();
                            model.i.g = bodyPart.getY();
                            model.i.h = bodyPart.getZ();
                            break;
                        }
                        case 3: {
                            model.k.f = bodyPart.getX();
                            model.k.g = bodyPart.getY();
                            model.k.h = bodyPart.getZ();
                            break;
                        }
                        case 4: {
                            model.j.f = bodyPart.getX();
                            model.j.g = bodyPart.getY();
                            model.j.h = bodyPart.getZ();
                        }
                    }
                }
                if (!(model instanceof bbr)) continue;
                EmoteRenderer.copyToSecondLayer((bbr)model);
            }
        }
    }

    public static void resetModel(bbj model) {
        EmoteRenderer.resetModelRenderer(model.h);
        EmoteRenderer.resetModelRenderer(model.i);
        EmoteRenderer.resetModelRenderer(model.k);
        EmoteRenderer.resetModelRenderer(model.j);
        EmoteRenderer.resetModelRenderer(model.g);
        if (model instanceof bbr) {
            EmoteRenderer.copyToSecondLayer((bbr)model);
        }
    }

    private static void resetModelRenderer(bct modelRenderer) {
        modelRenderer.f = 0.0f;
        modelRenderer.g = 0.0f;
        modelRenderer.h = 0.0f;
    }

    private static void copyToSecondLayer(bbr model) {
        bbj.a((bct)model.e, (bct)model.f);
        bbj.a((bct)model.g, (bct)model.v);
        bbj.a((bct)model.h, (bct)model.b);
        bbj.a((bct)model.i, (bct)model.a);
        bbj.a((bct)model.k, (bct)model.c);
        bbj.a((bct)model.j, (bct)model.d);
    }

    public void abort() {
        for (EmoteBodyPart bodyPart : this.bodyParts) {
            bodyPart.cancel();
        }
        this.emoteProvider.clear();
        this.resetKeyframeEnd = 0L;
        this.checkForNextFrame();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public short getEmoteId() {
        return this.emoteId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public boolean isStream() {
        return this.stream;
    }

    public EmoteProvider getEmoteProvider() {
        return this.emoteProvider;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public PoseAtTime[] getEmotePosesAtTime() {
        return this.emotePosesAtTime;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public long getResetKeyframeEnd() {
        return this.resetKeyframeEnd;
    }

    public EmoteBodyPart[] getBodyParts() {
        return this.bodyParts;
    }

    public float getFadedYaw() {
        return this.fadedYaw;
    }

    public float getFadedPitch() {
        return this.fadedPitch;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isMc18() {
        return this.mc18;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

