/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.remote.objects.data;

import java.awt.Color;
import java.util.Arrays;
import java.util.UUID;
import net.labymod.main.LabyMod;
import net.labymod.user.User;
import net.labymod.user.cosmetic.custom.DepthMap;
import net.labymod.user.cosmetic.remote.model.RemoteObject;
import net.labymod.user.cosmetic.util.CosmeticData;

public class RemoteData
extends CosmeticData {
    private RemoteObject object;
    public OffsetVector offset;
    public boolean rightSide;
    public UUID textureUUID;
    public Color[] colors = new Color[0];
    public DepthMap depthMap;
    public boolean depthMapChangedInThisFrame = false;
    public int depthMapCode = -1;

    @Override
    public void init(int id, User user) {
        this.object = LabyMod.getInstance().getUserManager().getRemoteCosmeticLoader().getObject(id);
    }

    @Override
    public void loadData(String[] data) throws Exception {
        int min = Math.min(this.object.options.length, data.length);
        block14: for (int i = 0; i < min; ++i) {
            String key = this.object.options[i];
            String value = data[i];
            switch (key) {
                case "offset": {
                    String[] vectorString = value.split(";");
                    this.offset = new OffsetVector(Double.parseDouble(vectorString[0]), Double.parseDouble(vectorString[1]), Double.parseDouble(vectorString[2]));
                    continue block14;
                }
                case "shoulder_side": 
                case "side": {
                    this.rightSide = Integer.parseInt(value) == 1;
                    continue block14;
                }
                case "texture": 
                case "mojang_uuid": {
                    this.textureUUID = UUID.fromString(value);
                    continue block14;
                }
                case "rgb": {
                    int n = this.colors.length;
                    this.colors = Arrays.copyOf(this.colors, n + 1);
                    this.colors[n] = Color.decode("#" + value);
                }
            }
        }
    }

    public void updateDepthMap(DepthMap depthMap) {
        if (this.depthMap != depthMap) {
            this.depthMapChangedInThisFrame = true;
        }
        this.depthMap = depthMap;
    }

    @Override
    public boolean isDraft() {
        return this.object.draft;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public static class OffsetVector {
        public double x;
        public double y;
        public double z;

        public OffsetVector(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

