/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.pet;

import java.util.List;
import net.labymod.core.BoundingBox;
import net.labymod.core.LabyModCore;
import net.labymod.user.cosmetic.animation.AnimationController;
import net.labymod.user.cosmetic.pet.util.Vector;

public class PetStorage<T> {
    public T cosmetic;
    private boolean moving = false;
    public boolean attached = true;
    public boolean standingUp = false;
    public boolean onGround = false;
    public boolean collision = false;
    public Vector position = new Vector();
    public Vector offset = new Vector();
    public Vector rotation = new Vector();
    public Vector motion = new Vector();
    public Vector prevPosition = new Vector();
    public Vector prevRotation = new Vector();
    public Vector ownerPosition = new Vector();
    public BoundingBox boundingBox = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public AnimationController animationController = new AnimationController();
    public long lastTimeMoved;
    public long lastTimeFlyingChanged;
    public long lastTimeAboveShoulderChanged;
    public boolean isAboveShoulder;
    public float lastTicks;
    public boolean lastSneaking;
    public boolean rightShoulder;
    public boolean fakeIdle;

    public void teleport(double x, double y, double z, double rotationX, double rotationY, double rotationZ) {
        this.prevPosition.setX(this.position.x).setY(this.position.y).setZ(this.position.z);
        this.prevRotation.setX(this.rotation.x).setY(this.rotation.y).setZ(this.rotation.z);
        this.position.x = x;
        this.position.y = y;
        this.position.z = z;
        this.rotation.x = rotationX;
        this.rotation.y = rotationY;
        this.rotation.z = rotationZ;
        this.motion.x = 0.0;
        this.motion.y = 0.0;
        this.motion.z = 0.0;
        float width = 0.1f;
        float height = 0.25f;
        this.boundingBox = new BoundingBox(x - (double)width, y - (double)height, z - (double)width, x + (double)width, y + (double)height, z + (double)width);
    }

    public boolean moveCollide(adm world, double x, double y, double z) {
        double prevX = x;
        double prevY = y;
        double prevZ = z;
        List<BoundingBox> aABBs = LabyModCore.getMinecraft().getCollisionBoxes(world, this.boundingBox.expand(x, y, z));
        for (BoundingBox abb : aABBs) {
            y = abb.clipYCollide(this.boundingBox, y);
        }
        this.boundingBox.move(0.0, y, 0.0);
        for (BoundingBox aABB : aABBs) {
            x = aABB.clipXCollide(this.boundingBox, x);
        }
        this.boundingBox.move(x, 0.0, 0.0);
        for (BoundingBox aABB : aABBs) {
            z = aABB.clipZCollide(this.boundingBox, z);
        }
        this.boundingBox.move(0.0, 0.0, z);
        boolean bl = this.onGround = prevY != y && prevY < 0.0;
        if (prevX != x) {
            this.motion.x = 0.0;
        }
        if (prevY != y) {
            this.motion.y = 0.0;
        }
        if (prevZ != z) {
            this.motion.z = 0.0;
        }
        this.position.x = (this.boundingBox.minX + this.boundingBox.maxX) / 2.0;
        this.position.y = this.boundingBox.minY;
        this.position.z = (this.boundingBox.minZ + this.boundingBox.maxZ) / 2.0;
        return prevX != x || prevZ != z;
    }

    public void setRotation(double x, double y, double z) {
        this.rotation.x = x;
        this.rotation.y = y;
        this.rotation.z = z;
    }

    public void moveRelative(double forward, double up, double strafe, double friction) {
        double distance = strafe * strafe + up * up + forward * forward;
        if (distance >= (double)1.0E-4f) {
            if ((distance = Math.sqrt(distance)) < 1.0) {
                distance = 1.0;
            }
            distance = friction / distance;
            double yawRadians = Math.toRadians(this.rotation.y);
            double sin = Math.sin(yawRadians);
            double cos = Math.cos(yawRadians);
            this.motion.x += (strafe *= distance) * cos - (forward *= distance) * sin;
            this.motion.y += (up *= distance);
            this.motion.z += forward * cos + strafe * sin;
        }
    }

    public void travel(adm world, float forward, float vertical, float strafe) {
        float prevSlipperiness = (this.onGround ? 0.6f : 1.0f) * 0.91f;
        float value = 0.16277136f / (prevSlipperiness * prevSlipperiness * prevSlipperiness);
        float friction = this.onGround ? 0.1f * value : 0.02f;
        this.moveRelative(forward, vertical, strafe, friction);
        float slipperiness = (this.onGround ? 0.6f : 1.0f) * 0.91f;
        this.collision = this.moveCollide(world, -this.motion.x, this.motion.y, -this.motion.z);
        this.motion.y -= (double)0.08f;
        this.motion.x *= (double)slipperiness;
        this.motion.y *= (double)0.98f;
        this.motion.z *= (double)slipperiness;
    }

    public boolean isAttachedToOwner(float currentTick) {
        return !this.moving && !this.animationController.isPlaying(currentTick) || this.attached && this.animationController.isPlaying(currentTick);
    }

    public boolean isPlayingAnimation(float currentTick) {
        return this.animationController.isPlaying(currentTick);
    }

    public void setMovingState(boolean moving) {
        this.moving = moving;
        this.lastTimeFlyingChanged = System.currentTimeMillis();
    }

    public void stopAnimation() {
        this.animationController.stop();
    }

    public boolean isMoving() {
        return this.moving;
    }
}

