/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.pet;

import net.labymod.user.cosmetic.animation.model.Animation;
import net.labymod.user.cosmetic.animation.model.BoneAnimation;
import net.labymod.user.cosmetic.animation.model.KeyframeVector;

public abstract class PetCodeAnimator {
    private final Animation animation = new Animation("");

    public PetCodeAnimator() {
        this.create();
    }

    public abstract void create();

    public void keyframe(long time, int id, KeyframeVector rotation, KeyframeVector position) {
        BoneAnimation boneAnimation = this.animation.getBoneAnimation(String.valueOf(id));
        if (position != null) {
            boneAnimation.position.add(time, position);
        }
        if (rotation != null) {
            boneAnimation.rotation.add(time, rotation);
        }
    }

    public void keyframe(long time, int id, float x, float y, float z, float posX, float posY, float posZ, boolean interpolation) {
        this.keyframe(time, id, new KeyframeVector(time, x, y, z, interpolation), new KeyframeVector(time, posX, posY, posZ, interpolation));
    }

    public void keyframe(long time, int id, float x, float y, float z, float posX, float posY, float posZ) {
        this.keyframe(time, id, new KeyframeVector(time, x, y, z, false), new KeyframeVector(time, posX, posY, posZ, false));
    }

    public void keyframe(long time, int id, float x, float y, float z) {
        this.keyframe(time, id, new KeyframeVector(time, x, y, z, false), null);
    }

    public void keyframe(long time, int id, float x, float y, float z, boolean interpolate) {
        this.keyframe(time, id, new KeyframeVector(time, x, y, z, false), null);
    }

    public Animation getAnimation() {
        return this.animation;
    }
}

