/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.geometry.render;

import net.labymod.user.cosmetic.custom.DepthMap;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryExtrude;

public class Extruded {
    private final GeometryExtrude geometryExtrude;
    private final DepthMap depthMap;

    public Extruded(GeometryExtrude geometryExtrude, DepthMap depthMap) {
        this.geometryExtrude = geometryExtrude;
        this.depthMap = depthMap;
    }

    public boolean isVisible(int cubeIndex, int quadIndex) {
        int x = cubeIndex % this.geometryExtrude.getWidth() + this.geometryExtrude.getX();
        int y = cubeIndex / this.geometryExtrude.getWidth() + this.geometryExtrude.getY();
        return this.depthMap == null || this.depthMap.shouldRenderFace(this.geometryExtrude, x, y, quadIndex);
    }

    public boolean hasChanged(DepthMap depthMap) {
        return this.depthMap != null && !this.depthMap.equals(depthMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extruded extruded = (Extruded)o;
        return this.depthMap.equals(extruded.depthMap);
    }

    public int hashCode() {
        return this.depthMap.hashCode();
    }
}

