/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.geometry.effect.effects;

import net.labymod.user.cosmetic.animation.MetaEffectFrameParameter;
import net.labymod.user.cosmetic.geometry.effect.GeometryEffect;
import net.labymod.user.cosmetic.geometry.render.GeometryModelRenderer;
import net.labymod.user.cosmetic.remote.objects.data.RemoteData;

public class GeometryOrientation
extends GeometryEffect {
    private OrientationTarget target;

    public GeometryOrientation(String name, GeometryModelRenderer model) {
        super(name, model);
    }

    @Override
    protected boolean parse() {
        this.target = OrientationTarget.getById(this.getParameter(0));
        return true;
    }

    @Override
    protected int getParametersAmount() {
        return 1;
    }

    @Override
    public void apply(RemoteData remoteData, MetaEffectFrameParameter meta) {
        biu renderManager = ave.A().af();
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        if (this.target == OrientationTarget.CAMERA) {
            x = renderManager.f * (float)(ave.A().t.aB == 2 ? -1 : 1);
            y = renderManager.e - meta.renderYawOffset;
        }
        if (this.target == OrientationTarget.NORTH) {
            y = -meta.renderYawOffset;
        }
        GeometryModelRenderer target = this.model.parent;
        while (target != null) {
            x = (float)((double)x - Math.toDegrees(target.rotateAngleX));
            y = (float)((double)y - Math.toDegrees(target.rotateAngleY));
            z = (float)((double)z - Math.toDegrees(target.rotateAngleZ));
            target = target.parent;
        }
        this.model.rotateAngleX = (float)Math.toRadians(x += 180.0f);
        this.model.rotateAngleY = (float)Math.toRadians(y);
        this.model.rotateAngleZ = (float)Math.toRadians(z);
    }

    public static enum OrientationTarget {
        CAMERA,
        NORTH;


        public static OrientationTarget getById(String id) {
            for (OrientationTarget target : OrientationTarget.values()) {
                if (!target.name().equalsIgnoreCase(id)) continue;
                return target;
            }
            return null;
        }
    }
}

