/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.geometry.effect.effects;

import net.labymod.user.cosmetic.animation.MetaEffectFrameParameter;
import net.labymod.user.cosmetic.geometry.effect.GeometryEffect;
import net.labymod.user.cosmetic.geometry.render.Extruded;
import net.labymod.user.cosmetic.geometry.render.GeometryModelRenderer;
import net.labymod.user.cosmetic.remote.objects.data.RemoteData;

public class GeometryExtrude
extends GeometryEffect {
    private int x = 0;
    private int y = 0;
    private int width = 1;
    private int height = 1;
    private boolean hasCube = false;

    public GeometryExtrude(String name, GeometryModelRenderer model) {
        super(name, model);
    }

    @Override
    protected boolean parse() {
        return true;
    }

    @Override
    protected int getParametersAmount() {
        return 0;
    }

    @Override
    public boolean onCubeAdd(GeometryModelRenderer target, float x, float y, float z, int sizeX, int sizeY, int sizeZ, float inflate, boolean mirror) {
        int originOffsetX = target.textureOffsetX;
        int originOffsetY = target.textureOffsetY;
        for (int relY = 0; relY < sizeY; ++relY) {
            for (int relX = 0; relX < sizeX; ++relX) {
                target.setTextureOffset(originOffsetX + relX, originOffsetY + relY);
                target.addBox(x + (float)relX + 0.5f, y + (float)relY + 0.5f, z, 0.01f, 0.01f, 0.01f, 0.5f, mirror);
            }
        }
        this.x = originOffsetX;
        this.y = originOffsetY;
        this.width = sizeX;
        this.height = sizeY;
        this.hasCube = true;
        return false;
    }

    @Override
    public void apply(RemoteData remoteData, MetaEffectFrameParameter meta) {
        if (!this.hasCube) {
            this.model.extruded = null;
            return;
        }
        this.model.extruded = new Extruded(this, remoteData.depthMap);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }
}

