/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.geometry;

import net.labymod.user.cosmetic.animation.AnimationController;
import net.labymod.user.cosmetic.animation.AnimationLoader;
import net.labymod.user.cosmetic.animation.EnumAnimationMetaType;
import net.labymod.user.cosmetic.animation.EnumTrigger;
import net.labymod.user.cosmetic.animation.model.Animation;

public interface TriggerHandler {
    public AnimationLoader getLoader();

    default public Animation handleTrigger(EnumTrigger trigger, AnimationController animationController, float currentTick, pk entity, Object data) {
        AnimationLoader loader = this.getLoader();
        if (loader != null) {
            Animation animation = loader.getAnimationByTrigger(trigger, entity);
            if (animation != null) {
                boolean sameAnimation;
                String forceString = animation.getMetaValue(EnumAnimationMetaType.FORCE);
                String queueString = animation.getMetaValue(EnumAnimationMetaType.QUEUE);
                boolean force = Boolean.parseBoolean(forceString);
                boolean queue = Boolean.parseBoolean(queueString);
                boolean isPlaying = animationController.isPlaying(currentTick);
                boolean bl = sameAnimation = animationController.getCurrentAnimation() == animation || animationController.hasAnimationInQueue(animation) || animationController.getCurrentAnimation() != null && animationController.getCurrentAnimation().hasTrigger(trigger);
                if (force) {
                    animationController.play(animation, currentTick);
                } else if (isPlaying) {
                    if (!sameAnimation) {
                        if (queue) {
                            animationController.addToPlayQueue(animation);
                            Animation currentAnimation = animationController.getCurrentAnimation();
                            String currentSpeedString = currentAnimation.getMetaValue(EnumAnimationMetaType.SPEED);
                            if (currentSpeedString != null && animationController.getSpeed() == 1.0f) {
                                float currentSpeed = Float.parseFloat(currentSpeedString);
                                animationController.setSpeed(currentSpeed, currentTick);
                            }
                        } else {
                            animationController.play(animation, currentTick);
                        }
                    }
                } else {
                    animationController.play(animation, currentTick);
                }
            }
            return animation;
        }
        return null;
    }
}

