/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.custom.handler;

import java.util.Map;
import net.labymod.user.User;
import net.labymod.user.cosmetic.custom.CosmeticImageHandler;
import net.labymod.user.cosmetic.custom.UserTextureContainer;
import net.labymod.user.cosmetic.remote.model.Ratio;
import net.labymod.utils.texture.ThreadDownloadTextureImage;

public class RemoteImageHandler
extends CosmeticImageHandler {
    public final int id;
    private final boolean hideCape;
    private boolean userBound;
    private final String textureDirectory;
    private boolean forceClear = false;

    public RemoteImageHandler(int id, String userAgent, boolean userBound, String textureDirectory, Ratio ratio, boolean canUnload, boolean hideCape) {
        super(userAgent, "remote_" + id, canUnload, ratio);
        this.id = id;
        this.userBound = userBound;
        this.textureDirectory = textureDirectory;
        this.hideCape = hideCape;
    }

    @Override
    public UserTextureContainer getContainer(User user) {
        Map<Integer, UserTextureContainer> containerMap = user.getRemoteContainer();
        if (containerMap.containsKey(this.id)) {
            if (this.forceClear) {
                this.forceClear = false;
                for (UserTextureContainer value : containerMap.values()) {
                    value.unload();
                }
            }
        } else {
            UserTextureContainer container = this.userBound ? new UserTextureContainer(this.id, this.textureDirectory, user.getUuid()) : new UserTextureContainer(this.id, this.textureDirectory);
            containerMap.put(this.id, container);
        }
        return containerMap.get(this.id);
    }

    @Override
    public void unload() {
    }

    @Override
    public ThreadDownloadTextureImage.TextureImageParser getTextureImageParser() {
        return null;
    }

    public boolean isHideCape() {
        return this.hideCape;
    }
}

