/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.custom;

import java.util.UUID;
import net.labymod.user.cosmetic.custom.CosmeticImageHandler;

public class UserTextureContainer {
    private final int cosmeticId;
    private String directory;
    private UUID fileName;
    private String resolvedURL = null;
    private boolean loaded = false;

    public UserTextureContainer(String directory) {
        this(-1, directory, null);
    }

    public UserTextureContainer(int cosmeticId, String directory) {
        this(cosmeticId, directory, null);
    }

    public UserTextureContainer(String directory, UUID fileName) {
        this.cosmeticId = -1;
        this.directory = directory;
        this.fileName = fileName;
    }

    public UserTextureContainer(int cosmeticId, String directory, UUID fileName) {
        this.cosmeticId = cosmeticId;
        this.directory = directory;
        this.fileName = fileName;
    }

    public void validateTexture(CosmeticImageHandler handler) {
        if (this.loaded || this.resolvedURL == null) {
            return;
        }
        this.loaded = true;
        handler.loadUserTexture(this.fileName, this.resolvedURL);
    }

    public void unload() {
        this.loaded = false;
    }

    public void resolved() {
        if (this.fileName != null) {
            this.resolvedURL = this.directory == null ? String.format("https://dl.labymod.net/cosmetics/%s/textures/%s.png", this.cosmeticId, this.fileName.toString()) : String.format("https://dl.labymod.net/textures/%s", this.directory + "/" + this.fileName.toString());
            this.unload();
        }
    }

    public void setFileName(UUID fileName) {
        this.fileName = fileName;
    }

    public UUID getFileName() {
        return this.fileName;
    }

    public String getResolvedURL() {
        return this.resolvedURL;
    }

    public boolean isLoaded() {
        return this.loaded;
    }
}

