/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.custom;

import java.awt.image.BufferedImage;
import java.util.Objects;
import net.labymod.user.cosmetic.geometry.effect.effects.GeometryExtrude;

public class DepthMap {
    private final boolean[][] map;
    private final long creationTime = System.currentTimeMillis();
    private final long hashCode;

    public DepthMap(BufferedImage bufferedImage) {
        this.map = new boolean[bufferedImage.getWidth()][bufferedImage.getHeight()];
        for (int x = 0; x < bufferedImage.getWidth(); ++x) {
            for (int y = 0; y < bufferedImage.getHeight(); ++y) {
                this.map[x][y] = this.hasDepth(bufferedImage.getRGB(x, y));
            }
        }
        this.hashCode = super.hashCode();
    }

    public boolean shouldRenderFace(GeometryExtrude bounds, int x, int y, int face) {
        return this.hasDepthAt(bounds, x, y) && !this.hasDepthInFacing(bounds, x, y, face);
    }

    public boolean hasDepthInFacing(GeometryExtrude bounds, int x, int y, int face) {
        switch (face) {
            case 0: {
                return this.hasDepthAt(bounds, x + 1, y);
            }
            case 1: {
                return this.hasDepthAt(bounds, x - 1, y);
            }
            case 2: {
                return this.hasDepthAt(bounds, x, y - 1);
            }
            case 3: {
                return this.hasDepthAt(bounds, x, y + 1);
            }
        }
        return false;
    }

    public boolean hasDepthAt(GeometryExtrude bounds, int x, int y) {
        return x >= bounds.getX() && y >= bounds.getY() && x < bounds.getX() + bounds.getWidth() && y < bounds.getY() + bounds.getHeight() && this.map[x][y];
    }

    public int getWidth() {
        return this.map.length;
    }

    public int getHeight() {
        return this.map[0].length;
    }

    private boolean hasDepth(int color) {
        return (color >> 24 & 0xFF) > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepthMap depthMap = (DepthMap)o;
        return this.creationTime == depthMap.creationTime && this.hashCode == depthMap.hashCode;
    }

    public int hashCode() {
        return Objects.hash(this.creationTime) + Objects.hash(this.hashCode);
    }
}

