/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.custom;

import net.labymod.user.cosmetic.custom.DepthMap;

public class AnimatedResourceLocation {
    private final String path;
    private final long delay;
    private final jy[] resourceLocations;
    private DepthMap depthMap = null;

    public AnimatedResourceLocation(String path) {
        this(path, 1, 50L);
    }

    public AnimatedResourceLocation(String path, int frames, long delay) {
        this.path = path;
        this.delay = Math.max(1L, Math.min(5000L, delay));
        this.resourceLocations = new jy[frames];
        for (int i = 0; i < frames; ++i) {
            this.resourceLocations[i] = new jy(path + "_" + i);
        }
    }

    public jy getDefault() {
        return this.get(0);
    }

    public jy get(int frame) {
        return frame < 0 || frame > this.resourceLocations.length - 1 ? (this.resourceLocations.length == 0 ? null : this.resourceLocations[0]) : this.resourceLocations[frame];
    }

    public String getPath() {
        return this.getDefault().a();
    }

    public jy[] getAllFrames() {
        return this.resourceLocations;
    }

    public int getFrameAmount() {
        return this.resourceLocations.length;
    }

    public jy getFrameAtCurrentTime() {
        return this.getFrameAtTime(System.currentTimeMillis());
    }

    public DepthMap getDepthMap() {
        return this.depthMap;
    }

    public void setDepthMap(DepthMap depthMap) {
        this.depthMap = depthMap;
    }

    public jy getFrameAtTime(long timestamp) {
        long ticks = timestamp / this.delay;
        int frame = (int)(ticks % (long)this.getFrameAmount());
        return this.get(frame);
    }
}

