/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.cosmetics.shop.body;

import java.awt.Color;
import net.labymod.core.LabyModCore;
import net.labymod.main.ModTextures;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.cosmetic.util.EnumLegacyCosmeticType;
import net.labymod.user.cosmetic.util.ModelRendererHook;
import org.lwjgl.opengl.GL11;

public class CosmeticWolfTail
extends CosmeticRenderer<CosmeticWolfData> {
    public static final int ID = 1;
    private bct wolfTail;
    private bct wolfTailPlayerSkin;

    @Override
    public void addModels(ModelCosmetics modelCosmetics, float modelSize) {
        for (int i = 0; i <= 1; ++i) {
            boolean playerSkin = i != 0;
            ModelRendererHook target = new ModelRendererHook((bbo)modelCosmetics);
            if (playerSkin) {
                target.a(56, 30);
            } else {
                target.b(8, 10);
                target.a(0, 0);
            }
            target.a(-1.0f, 0.0f, -1.0f, 2, 8, 2, modelSize);
            target.a(-0.2f, 10.0f, 3.0f);
            if (i == 0) {
                this.wolfTail = target;
                continue;
            }
            this.wolfTailPlayerSkin = target;
        }
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.wolfTail.j = invisible;
        this.wolfTailPlayerSkin.j = invisible;
    }

    @Override
    public void render(ModelCosmetics modelCosmetics, pk entityIn, CosmeticWolfData cosmeticData, float scale, float movementFactor, float walkingSpeed, float tickValue, float firstRotationX, float secondRotationX, float partialTicks) {
        float health;
        bfl.E();
        bct targetModel = this.bindTextureAndColor(cosmeticData.getColor(), cosmeticData.isUseSkinTexture() ? null : ModTextures.COSMETIC_TAIL_WOLF, cosmeticData.isUseSkinTexture() ? this.wolfTailPlayerSkin : this.wolfTail);
        if (entityIn.av()) {
            bfl.b((float)0.0f, (float)0.2f, (float)-0.25f);
            bfl.b((float)45.0f, (float)45.0f, (float)0.0f, (float)0.0f);
        } else {
            bfl.b((float)0.0f, (float)0.1f, (float)-0.25f);
            bfl.b((float)15.0f, (float)15.0f, (float)0.0f, (float)0.0f);
        }
        if (cosmeticData.isUseSkinTexture()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        if ((health = ((bet)entityIn).bn()) > 20.0f || Float.isNaN(health)) {
            health = 20.0f;
        }
        if (health < 0.0f) {
            health = 0.0f;
        }
        bfl.b((float)0.0f, (float)(health / 80.0f), (float)(health / 50.0f * -1.0f));
        bfl.b((float)(health * 2.0f), (float)(health * 2.0f), (float)0.0f, (float)0.0f);
        targetModel.b(scale);
        bfl.F();
    }

    @Override
    public void setRotationAngles(ModelCosmetics modelCosmetics, float movementFactor, float walkingSpeed, float tickValue, float var4, float var5, float var6, pk entityIn) {
        this.wolfTail.g = LabyModCore.getMath().cos(movementFactor * 0.6662f) * 1.4f * walkingSpeed;
        this.wolfTail.f = walkingSpeed;
        this.wolfTailPlayerSkin.g = LabyModCore.getMath().cos(movementFactor * 0.6662f) * 1.4f * walkingSpeed;
        this.wolfTailPlayerSkin.f = walkingSpeed;
    }

    @Override
    public int getCosmeticId() {
        return 1;
    }

    @Override
    public String getCosmeticName() {
        return "Wolf tail";
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    public static class CosmeticWolfData
    extends CosmeticData {
        private Color color = Color.WHITE;
        private boolean useSkinTexture = false;

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void loadData(String[] data) throws Exception {
            this.color = Color.decode("#" + data[0]);
            this.useSkinTexture = Integer.parseInt(data[1]) == 1;
        }

        @Override
        public EnumLegacyCosmeticType getType() {
            return EnumLegacyCosmeticType.BODY;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isUseSkinTexture() {
            return this.useSkinTexture;
        }
    }
}

