/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.cosmetics.shop.body;

import java.awt.Color;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.user.User;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.custom.UserTextureContainer;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.cosmetic.util.EnumLegacyCosmeticType;
import net.labymod.user.cosmetic.util.ModelRendererHook;
import org.lwjgl.opengl.GL11;

public class CosmeticWatch
extends CosmeticRenderer<CosmeticWatchData> {
    public static final int ID = 33;
    private bct watchCase;
    private bct numberField;
    private bct band;
    private bct pointerHourMinute;
    private bct pointerSeconds;
    private Calendar calendar = Calendar.getInstance();

    @Override
    public void addModels(ModelCosmetics modelCosmetics, float modelSize) {
        int widthCase = 36;
        int heightCase = 19;
        int widthDesign = 20;
        int heightDesign = 21;
        boolean isSlim = ((bcr)modelCosmetics.i.l.get((int)0)).d == 2.0f;
        float caseDepth = isSlim ? 0.0f : 4.6f;
        this.band = new ModelRendererHook((bbo)modelCosmetics).b(widthDesign, heightDesign).a(0, isSlim ? 6 : 0);
        this.band.a(isSlim ? -1.5f : -1.4f, 8.7f, -2.5f, isSlim ? 4 : 5, 1, 5, modelSize);
        this.watchCase = new ModelRendererHook((bbo)modelCosmetics).b(widthCase, heightCase).a(0, 0);
        this.watchCase.a(-3.0f, -4.0f, caseDepth, 6, 8, 1, modelSize);
        this.watchCase.g = (float)Math.toRadians(90.0);
        bct model = new ModelRendererHook((bbo)modelCosmetics).b(widthCase, heightCase).a(16, 0);
        model.a(-4.0f, -3.0f, caseDepth, 1, 6, 1, modelSize);
        model.a(3.0f, -3.0f, caseDepth, 1, 6, 1, modelSize);
        this.watchCase.a(model);
        this.numberField = new ModelRendererHook((bbo)modelCosmetics).b(widthDesign, heightDesign).a(0, 12);
        this.numberField.a(-3.0f, -4.0f, caseDepth - 0.1f, 6, 8, 1, modelSize);
        this.numberField.g = (float)Math.toRadians(90.0);
        float depht = caseDepth + 0.3f;
        float addedScale = 0.01f;
        model = new ModelRendererHook((bbo)modelCosmetics).b(widthCase, heightCase).a(0, 9);
        model.a(-2.0f, -4.0f, depht, 4, 1, 1, modelSize + addedScale);
        model.a(-2.0f, 3.0f, depht, 4, 1, 1, modelSize + addedScale);
        this.watchCase.a(model);
        model = new ModelRendererHook((bbo)modelCosmetics).b(widthCase, heightCase).a(0, 9);
        model.a(-2.0f, -4.0f, depht, 4, 1, 1, modelSize + addedScale);
        model.a(-2.0f, 3.0f, depht, 4, 1, 1, modelSize + addedScale);
        model.h = (float)Math.toRadians(90.0);
        this.watchCase.a(model);
        model = new ModelRendererHook((bbo)modelCosmetics).b(widthCase, heightCase).a(14, 9);
        model.a(2.0f, -3.0f, depht, 1, 1, 1, modelSize + addedScale);
        model.a(-3.0f, -3.0f, depht, 1, 1, 1, modelSize + addedScale);
        model.a(2.0f, 2.0f, depht, 1, 1, 1, modelSize + addedScale);
        model.a(-3.0f, 2.0f, depht, 1, 1, 1, modelSize + addedScale);
        model.a(-0.5f, -0.5f, caseDepth + 0.6f, 1, 1, 1, -0.2f);
        this.watchCase.a(model);
        this.pointerHourMinute = new ModelRendererHook((bbo)modelCosmetics);
        bct pointerHour = new ModelRendererHook((bbo)modelCosmetics).b(widthCase, heightCase).a(24, 0);
        pointerHour.a(6.0f * caseDepth, 0.0f, -1.0f, 1, 12, 2, modelSize);
        this.pointerHourMinute.a(pointerHour);
        bct pointerMinute = new ModelRendererHook((bbo)modelCosmetics).b(widthCase, heightCase).a(30, 0);
        pointerMinute.a(6.0f * caseDepth + 0.2f, 0.0f, -1.0f, 1, 17, 2, modelSize);
        this.pointerHourMinute.a(pointerMinute);
        this.pointerSeconds = new ModelRendererHook((bbo)modelCosmetics).b(widthCase, heightCase).a(20, 0);
        this.pointerSeconds.a(6.0f * caseDepth + 0.3f, 0.0f, -0.5f, 1, 16, 1, modelSize);
    }

    @Override
    public void setInvisible(boolean invisible) {
        this.watchCase.j = invisible;
        this.band.j = invisible;
        this.pointerHourMinute.j = invisible;
        this.pointerSeconds.j = invisible;
        this.numberField.j = invisible;
    }

    @Override
    public void render(ModelCosmetics modelCosmetics, pk entityIn, CosmeticWatchData cosmeticData, float scale, float movementFactor, float walkingSpeed, float tickValue, float firstRotationX, float secondRotationX, float partialTicks) {
        jy textureDesign = LabyMod.getInstance().getUserManager().getCosmeticImageManager().getWatchImageHandler().getResourceLocation((bet)entityIn);
        if (textureDesign == null) {
            return;
        }
        Color caseColor = cosmeticData.getColor();
        boolean useRightHand = cosmeticData.isUseRightHand();
        bct model = useRightHand ? modelCosmetics.h : modelCosmetics.i;
        bfl.E();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ave.A().P().a(textureDesign);
        bfl.b((float)(model.c * scale), (float)(model.d * scale), (float)(model.e * scale));
        bfl.b((float)(model.h * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
        bfl.b((float)(model.g * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
        bfl.b((float)(model.f * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
        if (useRightHand) {
            bfl.b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        bfl.b((float)(scale * -1.0f), (float)(scale * -2.0f), (float)(scale * -2.0f));
        bfl.b((float)0.0f, (float)(scale * (float)(-cosmeticData.getPositionY()) * 0.5f), (float)0.0f);
        double bandScale = 0.825f;
        double watchScale = 0.2f;
        double pointerScale = 0.032f;
        bfl.E();
        bfl.b((float)(scale * 1.0f), (float)(scale * 2.0f), (float)(scale * 2.0f));
        bfl.E();
        bfl.a((double)bandScale, (double)bandScale, (double)bandScale);
        bfl.b((float)(scale * 0.1f), (float)(scale * 1.7f), (float)0.0f);
        this.band.a(scale);
        bfl.F();
        bfl.E();
        bfl.b((float)(scale * 2.1f), (float)(scale * 9.0f), (float)0.0f);
        bfl.a((double)watchScale, (double)watchScale, (double)watchScale);
        bfl.b((float)(useRightHand ? -90.0f : 90.0f), (float)-1.0f, (float)0.0f, (float)0.0f);
        this.bindTextureAndColor(caseColor, ModTextures.COSMETIC_WATCH_CASE, this.watchCase).a(scale);
        this.bindTextureAndColor(Color.white, textureDesign, this.numberField).a(scale);
        bfl.F();
        bfl.F();
        bfl.b((float)(scale * 3.0f + 0.02f), (float)(scale * 11.0f), (float)(scale * 2.0f));
        bfl.a((double)pointerScale, (double)pointerScale, (double)pointerScale);
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        int minute = this.calendar.get(12);
        int hour = this.calendar.get(10);
        int seconds = this.calendar.get(13);
        float hourInterpolation = 0.016666668f * (float)minute;
        float mirror = cosmeticData.isUseRightHand() ? 0.0f : 180.0f;
        List cm = this.pointerHourMinute.m;
        ((bct)cm.get((int)0)).f = (float)Math.toRadians(-30.0f * ((float)hour + hourInterpolation) - mirror);
        ((bct)cm.get((int)1)).f = (float)Math.toRadians(-6.0f * (float)minute - mirror);
        this.pointerSeconds.f = (float)Math.toRadians(-6.0f * (float)seconds - mirror);
        bfl.b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        if (cosmeticData.isDisplaySecondPointer()) {
            this.bindTextureAndColor(Color.WHITE, ModTextures.COSMETIC_WATCH_CASE, this.pointerSeconds).a(scale);
        }
        this.bindTextureAndColor(caseColor, ModTextures.COSMETIC_WATCH_CASE, this.pointerHourMinute).a(scale);
        bfl.F();
    }

    @Override
    public int getCosmeticId() {
        return 33;
    }

    @Override
    public String getCosmeticName() {
        return "Watch";
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    @Override
    public boolean hasLeftHandSupport() {
        return false;
    }

    @Override
    public boolean isVisibleInFirstPerson(CosmeticWatchData data, boolean rightHand) {
        return rightHand ? data.isUseRightHand() : !data.isUseRightHand();
    }

    public static class CosmeticWatchData
    extends CosmeticData {
        private Color color = Color.DARK_GRAY;
        private boolean useRightHand;
        private int positionY;
        private boolean displaySecondPointer;
        private UserTextureContainer userTextureContainer;

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void init(User user) {
            this.userTextureContainer = user.getWatchContainer();
        }

        @Override
        public void loadData(String[] data) throws Exception {
            this.color = Color.decode("#" + data[0]);
            this.useRightHand = Integer.parseInt(data[1]) == 1;
            this.positionY = Integer.parseInt(data[2]);
            this.displaySecondPointer = Integer.parseInt(data[3]) == 1;
            this.userTextureContainer.setFileName(UUID.fromString(data[4]));
            this.positionY = Math.max(0, this.positionY);
            this.positionY = Math.min(10, this.positionY);
        }

        @Override
        public EnumLegacyCosmeticType getType() {
            return EnumLegacyCosmeticType.ARM;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isUseRightHand() {
            return this.useRightHand;
        }

        public int getPositionY() {
            return this.positionY;
        }

        public boolean isDisplaySecondPointer() {
            return this.displaySecondPointer;
        }
    }
}

