/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.cosmetics.partner;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.labymod.main.LabyMod;
import net.labymod.main.ModTextures;
import net.labymod.user.cosmetic.CosmeticRenderer;
import net.labymod.user.cosmetic.ModelCosmetics;
import net.labymod.user.cosmetic.util.CosmeticData;
import net.labymod.user.cosmetic.util.EnumLegacyCosmeticType;
import net.labymod.user.cosmetic.util.ModelRendererHook;
import org.lwjgl.opengl.GL11;

public class CosmeticReved
extends CosmeticRenderer<CosmeticRevedData> {
    public static final int ID = 30;
    private List<bct> framesRight;
    private List<bct> framesLeft;

    @Override
    public void addModels(ModelCosmetics modelCosmetics, float modelSize) {
        int width = 5;
        int height = 12;
        int totalFrames = 120;
        boolean isSlim = ((bcr)modelCosmetics.i.l.get((int)0)).d == 2.0f;
        this.framesRight = Lists.newArrayList();
        this.framesLeft = Lists.newArrayList();
        int slimSkinOffset = 0;
        for (int currentFrame = 0; currentFrame < totalFrames; ++currentFrame) {
            for (int sides = 0; sides < 2; ++sides) {
                boolean rightSide = sides == 0;
                bct modelFire = new ModelRendererHook((bbo)modelCosmetics).b(width * totalFrames, (width + height) * 2);
                modelFire.a(isSlim ? slimSkinOffset : currentFrame * width, isSlim ? height + width : 0);
                modelFire.a(rightSide ? -5.0f : 5.0f, 12.0f, 0.0f);
                modelFire.a(rightSide ? -2.6f - (float)(!isSlim ? 1 : 0) : -1.4f, -0.72f, -2.5f, isSlim ? 4 : 5, 12, 5, modelSize);
                if (rightSide) {
                    this.framesRight.add(modelFire);
                    continue;
                }
                this.framesLeft.add(modelFire);
            }
            slimSkinOffset += width - currentFrame % 2;
        }
    }

    @Override
    public void setInvisible(boolean invisible) {
        for (bct frame : this.framesRight) {
            frame.j = invisible;
        }
        for (bct frame : this.framesLeft) {
            frame.j = invisible;
        }
    }

    @Override
    public void render(ModelCosmetics modelCosmetics, pk entityIn, CosmeticRevedData cosmeticData, float scale, float movementFactor, float walkingSpeed, float tickValue, float firstRotationX, float secondRotationX, float partialTicks) {
        bfl.E();
        boolean fireOnRightHand = cosmeticData.isUseRightSide();
        boolean coloredTexture = cosmeticData.isUseColoredTexture() && !cosmeticData.isRainbow();
        List<bct> modelFire = fireOnRightHand ? this.framesRight : this.framesLeft;
        int index = (int)(System.currentTimeMillis() / 70L % (long)(modelFire.size() / 2 - 2)) * 2;
        bct modelFireRing = modelFire.get(index);
        int color = cosmeticData.getColor().getRGB();
        if (cosmeticData.isRainbow()) {
            long time = System.currentTimeMillis() % 10000L;
            color = Color.HSBtoRGB((float)time / 10000.0f, 1.0f, 1.0f);
        }
        this.bindTextureAndColor(color, coloredTexture ? ModTextures.COSMETIC_REVED_ARM_COLORED : ModTextures.COSMETIC_REVED_ARM, modelFireRing);
        bbj.a((bct)(fireOnRightHand ? modelCosmetics.h : modelCosmetics.i), (bct)modelFireRing);
        bfl.l();
        bfl.f();
        bfl.b((int)770, (int)771);
        bfl.a((int)516, (float)0.003921569f);
        float size = 0.91f;
        bfl.b((float)(modelFireRing.c * scale), (float)(modelFireRing.d * scale), (float)(modelFireRing.e * scale));
        bfl.a((float)size, (float)size, (float)size);
        bfl.b((float)(-modelFireRing.c * scale), (float)(-modelFireRing.d * scale), (float)(-modelFireRing.e * scale));
        modelFireRing.a(scale);
        bfl.E();
        bfl.b((float)(modelFireRing.c * scale), (float)(modelFireRing.d * scale), (float)(modelFireRing.e * scale));
        bfl.b((double)-0.25, (double)-0.2, (double)-0.2);
        for (FireParticle particle : cosmeticData.getParticle()) {
            particle.render(entityIn, coloredTexture, firstRotationX, color);
        }
        bfl.F();
        bfl.e();
        bfl.a((int)516, (float)0.1f);
        bfl.k();
        bfl.F();
    }

    @Override
    public int getCosmeticId() {
        return 30;
    }

    @Override
    public String getCosmeticName() {
        return "Reved";
    }

    @Override
    public boolean isOfflineAvailable() {
        return false;
    }

    @Override
    public float getNameTagHeight() {
        return 0.0f;
    }

    @Override
    public boolean hasLeftHandSupport() {
        return false;
    }

    @Override
    public boolean isVisibleInFirstPerson(CosmeticRevedData data, boolean rightHand) {
        return rightHand ? data.isUseRightSide() : !data.isUseRightSide();
    }

    public static class FireParticle {
        private double x;
        private double y;
        private double z;
        private float rotZ;
        private long timestamp;
        private long lifetime;

        public void render(pk entityIn, boolean coloredTexture, float firstRotationX, int color) {
            long alive = System.currentTimeMillis() - this.timestamp;
            double percent = 100.0 / (double)this.lifetime * (double)alive - 50.0;
            double fade = 255.0 - Math.min(255.0, percent * percent);
            bfl.E();
            bfl.f();
            bfl.d();
            bfl.l();
            bfl.b((double)this.x, (double)(this.y - (double)((float)alive / 6000.0f)), (double)this.z);
            biu renderManager = ave.A().af();
            if (entityIn instanceof bet) {
                bet entity = (bet)entityIn;
                float rotation = renderManager.e - entity.aK;
                if (entity != ave.A().ac()) {
                    bfl.b((float)(rotation + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                } else if (ave.A().t.aB == 1) {
                    bfl.b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                bfl.b((float)firstRotationX, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            bfl.b((float)(this.rotZ + (float)alive / 100.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            bfl.c((float)1.0f, (float)1.0f, (float)1.0f);
            if (!coloredTexture) {
                int red = color >> 16 & 0xFF;
                int green = color >> 8 & 0xFF;
                int blue = color >> 0 & 0xFF;
                GL11.glColor4f((float)((float)red / 255.0f), (float)((float)green / 255.0f), (float)((float)blue / 255.0f), (float)((float)fade / 255.0f));
            }
            ave.A().P().a(ModTextures.COSMETIC_REVED_FLAME);
            LabyMod.getInstance().getDrawUtils().drawTexture(0.0, 0.0, coloredTexture ? 0.0 : 127.0, 0.0, 127.0, 255.0, 0.05, 0.05);
            bfl.F();
            if (alive > this.lifetime) {
                Random random = LabyMod.getRandom();
                this.timestamp = System.currentTimeMillis();
                this.lifetime = (random.nextInt(4) + 1) * 1000;
                this.x = random.nextDouble() / 2.8;
                this.y = random.nextDouble();
                this.z = random.nextDouble() / 2.5;
                this.rotZ = random.nextFloat() * 360.0f;
            }
        }
    }

    public static class CosmeticRevedData
    extends CosmeticData {
        private Color color = Color.WHITE;
        private boolean useRightSide = false;
        private boolean useColoredTexture = true;
        private FireParticle[] particle = new FireParticle[0];
        private boolean rainbow = false;

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void loadData(String[] data) throws Exception {
            this.particle = new FireParticle[20];
            for (int i = 0; i < 20; ++i) {
                this.particle[i] = new FireParticle();
            }
            this.color = Color.decode("#" + data[0]);
            if (!this.color.equals(Color.WHITE)) {
                this.useColoredTexture = false;
            }
            if (data.length >= 2) {
                boolean bl = this.useRightSide = Integer.parseInt(data[1]) == 1;
            }
            if (data.length >= 3 && Integer.parseInt(data[2]) == 1) {
                this.rainbow = true;
                this.useColoredTexture = true;
            }
        }

        @Override
        public EnumLegacyCosmeticType getType() {
            return EnumLegacyCosmeticType.ARM;
        }

        public Color getColor() {
            return this.color;
        }

        public boolean isUseRightSide() {
            return this.useRightSide;
        }

        public boolean isUseColoredTexture() {
            return this.useColoredTexture;
        }

        public FireParticle[] getParticle() {
            return this.particle;
        }

        public boolean isRainbow() {
            return this.rainbow;
        }
    }
}

