/*
 * Decompiled with CFR 0.152.
 */
package net.labymod.user.cosmetic.animation;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.labymod.main.LabyMod;
import net.labymod.user.cosmetic.animation.EnumTrigger;
import net.labymod.user.cosmetic.animation.model.Animation;
import net.labymod.user.cosmetic.animation.model.BoneAnimation;
import net.labymod.user.cosmetic.animation.model.Keyframes;

public class AnimationLoader {
    private static final Gson GSON = new Gson();
    private final JsonObject tree;
    private final Map<String, Animation> animations = new HashMap<String, Animation>();

    public AnimationLoader(JsonObject tree) throws IOException {
        this.tree = tree;
    }

    public AnimationLoader(InputStream inputStream) throws IOException {
        this((JsonObject)GSON.fromJson((Reader)new InputStreamReader(inputStream), JsonObject.class));
        inputStream.close();
    }

    public AnimationLoader(String json) throws IOException {
        this((JsonObject)GSON.fromJson(json, JsonObject.class));
    }

    public AnimationLoader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public AnimationLoader load() {
        if (!this.tree.has("animations") || !this.tree.get("animations").isJsonObject()) {
            return this;
        }
        JsonObject animations = this.tree.get("animations").getAsJsonObject();
        for (Map.Entry animationEntry : animations.entrySet()) {
            String animationName = (String)animationEntry.getKey();
            JsonObject animationObject = ((JsonElement)animationEntry.getValue()).getAsJsonObject();
            if (!animationObject.has("bones")) continue;
            JsonObject bones = animationObject.get("bones").getAsJsonObject();
            Animation animation = new Animation(animationName);
            if (animationObject.has("anim_time_update")) {
                animation.parseMeta(animationObject.get("anim_time_update").getAsString());
            } else {
                animation.parseMeta(animationObject);
            }
            for (Map.Entry boneEntry : bones.entrySet()) {
                String boneName = (String)boneEntry.getKey();
                JsonObject bone = ((JsonElement)boneEntry.getValue()).getAsJsonObject();
                BoneAnimation boneAnimation = animation.getBoneAnimation(boneName);
                this.extractKeyframes(boneAnimation.rotation, bone, "rotation");
                this.extractKeyframes(boneAnimation.position, bone, "position");
                this.extractKeyframes(boneAnimation.scale, bone, "scale");
            }
            this.animations.put(animationName, animation);
        }
        return this;
    }

    private void extractKeyframes(Keyframes storage, JsonObject bone, String key) {
        if (bone.has(key)) {
            JsonElement type = bone.get(key);
            if (type.isJsonArray()) {
                this.pushVector(storage, 0L, type.getAsJsonArray(), false);
            } else if (type.isJsonObject()) {
                JsonObject object = type.getAsJsonObject();
                if (object.has("post")) {
                    boolean smooth = object.has("lerp_mode") ? object.get("lerp_mode").getAsString().equals("catmullrom") : false;
                    this.pushVector(storage, 0L, object.get("post").getAsJsonArray(), smooth);
                } else {
                    for (Map.Entry entry : object.entrySet()) {
                        long offset = (long)(Double.parseDouble((String)entry.getKey()) * 1000.0);
                        JsonElement value = (JsonElement)entry.getValue();
                        JsonArray array = null;
                        boolean smooth = false;
                        if (value.isJsonArray()) {
                            array = value.getAsJsonArray();
                        } else {
                            JsonObject entryObject = value.getAsJsonObject();
                            array = entryObject.get("post").getAsJsonArray();
                            smooth = entryObject.has("lerp_mode") ? entryObject.get("lerp_mode").getAsString().equals("catmullrom") : false;
                        }
                        this.pushVector(storage, offset, array, smooth);
                    }
                }
            } else {
                float value = type.getAsFloat();
                JsonArray array = new JsonArray();
                array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(value)));
                array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(value)));
                array.add((JsonElement)new JsonPrimitive((Number)Float.valueOf(value)));
                this.pushVector(storage, 0L, array, false);
            }
        }
    }

    private void pushVector(Keyframes storage, long offset, JsonArray arrayVector, boolean smooth) {
        float x = arrayVector.get(0).getAsFloat();
        float y = arrayVector.get(1).getAsFloat();
        float z = arrayVector.get(2).getAsFloat();
        storage.add(offset, x, y, z, smooth);
    }

    public Animation getAnimationByTrigger(EnumTrigger triggerType, pk entity) {
        Animation lastAnimation = null;
        int totalProbability = 0;
        int totalAnimations = 0;
        for (Animation animation : this.animations.values()) {
            if (!animation.hasTrigger(triggerType) || !animation.meetsConditions(entity)) continue;
            lastAnimation = animation;
            Integer probability = animation.getProbability();
            if (probability == null) continue;
            totalProbability += probability.intValue();
            ++totalAnimations;
        }
        if (totalAnimations >= 2) {
            int targetIndex = LabyMod.getRandom().nextInt(totalProbability);
            int index = 0;
            for (Animation animation : this.animations.values()) {
                Integer probability;
                if (!animation.hasTrigger(triggerType) || (probability = animation.getProbability()) == null) continue;
                if (targetIndex >= index && targetIndex < index + probability) {
                    return animation;
                }
                index += probability.intValue();
            }
            return null;
        }
        return lastAnimation;
    }

    public Animation getAnimation(String name) {
        return this.animations.get(name);
    }
}

